/*
 * Decompiled with CFR 0.152.
 */
package com.mattbertolini.spring.web.servlet.mvc.bind.resolver;

import com.mattbertolini.spring.web.bind.PropertyResolutionException;
import com.mattbertolini.spring.web.bind.annotation.RequestParameter;
import com.mattbertolini.spring.web.bind.introspect.BindingProperty;
import com.mattbertolini.spring.web.servlet.mvc.bind.resolver.RequestPropertyResolver;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.lang.NonNull;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartRequest;
import org.springframework.web.multipart.support.MultipartResolutionDelegate;

public class RequestParameterMapRequestPropertyResolver
implements RequestPropertyResolver {
    public boolean supports(@NonNull BindingProperty bindingProperty) {
        RequestParameter annotation = (RequestParameter)bindingProperty.getAnnotation(RequestParameter.class);
        return annotation != null && !StringUtils.hasText((String)annotation.value()) && Map.class.isAssignableFrom(bindingProperty.getType());
    }

    public Object resolve(@NonNull BindingProperty bindingProperty, @NonNull NativeWebRequest request) {
        ResolvableType resolvableType = ResolvableType.forMethodParameter((MethodParameter)bindingProperty.getMethodParameter());
        if (MultiValueMap.class.isAssignableFrom(bindingProperty.getType())) {
            Class mapValueType = resolvableType.as(MultiValueMap.class).getGeneric(new int[]{1}).resolve();
            if (MultipartFile.class == mapValueType) {
                MultipartRequest multipartRequest = MultipartResolutionDelegate.resolveMultipartRequest((NativeWebRequest)request);
                return multipartRequest != null ? multipartRequest.getMultiFileMap() : new LinkedMultiValueMap();
            }
            if (Part.class == mapValueType) {
                return this.resolveServletRequestPartsToMultiValueMap(request);
            }
            Map parameterMap = request.getParameterMap();
            LinkedMultiValueMap ret = new LinkedMultiValueMap(parameterMap.size());
            for (Map.Entry entry : parameterMap.entrySet()) {
                ret.put((Object)((String)entry.getKey()), new LinkedList<String>(Arrays.asList((String[])entry.getValue())));
            }
            return ret;
        }
        Class mapValueType = resolvableType.asMap().getGeneric(new int[]{1}).resolve();
        if (MultipartFile.class == mapValueType) {
            MultipartRequest multipartRequest = MultipartResolutionDelegate.resolveMultipartRequest((NativeWebRequest)request);
            return multipartRequest != null ? multipartRequest.getFileMap() : new LinkedHashMap();
        }
        if (Part.class == mapValueType) {
            return this.resolveServletRequestPartsToMap(request);
        }
        Map parameterMap = request.getParameterMap();
        LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>(parameterMap.size());
        for (Map.Entry entry : parameterMap.entrySet()) {
            ret.put((String)entry.getKey(), ((String[])entry.getValue())[0]);
        }
        return ret;
    }

    private LinkedMultiValueMap<?, ?> resolveServletRequestPartsToMultiValueMap(NativeWebRequest request) {
        try {
            HttpServletRequest servletRequest = (HttpServletRequest)request.getNativeRequest(HttpServletRequest.class);
            if (servletRequest != null && MultipartResolutionDelegate.isMultipartRequest((HttpServletRequest)servletRequest)) {
                Collection parts = servletRequest.getParts();
                LinkedMultiValueMap result = new LinkedMultiValueMap(parts.size());
                for (Part part : parts) {
                    result.add((Object)part.getName(), (Object)part);
                }
                return result;
            }
            return new LinkedMultiValueMap();
        }
        catch (IOException | ServletException e) {
            throw new PropertyResolutionException("Exception resolving multipart objects into MultiValueMap.", e);
        }
    }

    private LinkedHashMap<?, ?> resolveServletRequestPartsToMap(NativeWebRequest request) {
        try {
            HttpServletRequest servletRequest = (HttpServletRequest)request.getNativeRequest(HttpServletRequest.class);
            if (servletRequest != null && MultipartResolutionDelegate.isMultipartRequest((HttpServletRequest)servletRequest)) {
                Collection parts = servletRequest.getParts();
                LinkedHashMap<String, Part> result = new LinkedHashMap<String, Part>(parts.size());
                for (Part part : parts) {
                    if (result.containsKey(part.getName())) continue;
                    result.put(part.getName(), part);
                }
                return result;
            }
            return new LinkedHashMap();
        }
        catch (IOException | ServletException e) {
            throw new PropertyResolutionException("Exception resolving multipart objects into Map", e);
        }
    }
}

