/*
 * Decompiled with CFR 0.152.
 */
package com.mattbertolini.spring.web.servlet.mvc.bind.resolver;

import com.mattbertolini.spring.web.bind.annotation.PathParameter;
import com.mattbertolini.spring.web.bind.introspect.BindingProperty;
import com.mattbertolini.spring.web.servlet.mvc.bind.resolver.RequestPropertyResolver;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.lang.NonNull;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.servlet.HandlerMapping;

public class PathParameterMapRequestPropertyResolver
implements RequestPropertyResolver {
    public boolean supports(@NonNull BindingProperty bindingProperty) {
        PathParameter annotation = (PathParameter)bindingProperty.getAnnotation(PathParameter.class);
        return annotation != null && !StringUtils.hasText((String)annotation.value()) && Map.class.isAssignableFrom(bindingProperty.getType());
    }

    public Object resolve(@NonNull BindingProperty bindingProperty, @NonNull NativeWebRequest request) {
        Map uriTemplateVariables = (Map)request.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE, 0);
        if (uriTemplateVariables == null) {
            return Collections.emptyMap();
        }
        return new LinkedHashMap(uriTemplateVariables);
    }
}

