/*
 * Decompiled with CFR 0.152.
 */
package com.mattbertolini.spring.web.servlet.mvc.bind;

import com.mattbertolini.spring.web.bind.RequestPropertyBindingException;
import com.mattbertolini.spring.web.bind.annotation.BeanParameter;
import com.mattbertolini.spring.web.bind.introspect.AnnotatedRequestBeanIntrospector;
import com.mattbertolini.spring.web.bind.introspect.ResolvedPropertyData;
import com.mattbertolini.spring.web.servlet.mvc.bind.resolver.RequestPropertyResolver;
import java.util.Collection;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValues;
import org.springframework.core.MethodParameter;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.annotation.ModelAttributeMethodProcessor;

public class BeanParameterMethodArgumentResolver
extends ModelAttributeMethodProcessor {
    private static final String INTROSPECTOR_TARGET_CLASS = BeanParameterMethodArgumentResolver.class + ".INTROSPECTOR_TARGET_CLASS";
    private final AnnotatedRequestBeanIntrospector introspector;

    public BeanParameterMethodArgumentResolver(@NonNull AnnotatedRequestBeanIntrospector introspector) {
        super(false);
        this.introspector = introspector;
    }

    public boolean supportsParameter(@NonNull MethodParameter parameter) {
        return parameter.hasParameterAnnotation(BeanParameter.class) && !BeanUtils.isSimpleProperty((Class)parameter.getParameterType());
    }

    public boolean supportsReturnType(@NonNull MethodParameter returnType) {
        return false;
    }

    protected void bindRequestParameters(@NonNull WebDataBinder binder, @NonNull NativeWebRequest request) {
        Assert.state((binder.getTarget() != null ? 1 : 0) != 0, (String)"WebDataBinder must have a target object");
        PropertyValues propertyValues = this.makePropertyValues(binder.getTarget().getClass(), request);
        binder.bind(propertyValues);
    }

    @NonNull
    private PropertyValues makePropertyValues(@NonNull Class<?> targetType, @NonNull NativeWebRequest request) {
        MutablePropertyValues propertyValues = new MutablePropertyValues();
        Collection propertyData = this.introspector.getResolversFor(targetType);
        for (ResolvedPropertyData data : propertyData) {
            RequestPropertyResolver resolver = (RequestPropertyResolver)data.getResolver();
            try {
                Object value = resolver.resolve(data.getBindingProperty(), request);
                if (value == null) continue;
                String propertyName = data.getPropertyName();
                propertyValues.add(propertyName, value);
            }
            catch (Exception e) {
                throw new RequestPropertyBindingException("Unable to resolve property. " + e.getMessage(), (Throwable)e);
            }
        }
        return propertyValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    protected Object createAttribute(@NonNull String attributeName, MethodParameter parameter, @NonNull WebDataBinderFactory binderFactory, NativeWebRequest webRequest) throws Exception {
        try {
            MethodParameter nestedParameter = parameter.nestedIfOptional();
            Class clazz = nestedParameter.getNestedParameterType();
            webRequest.setAttribute(INTROSPECTOR_TARGET_CLASS, (Object)clazz, 0);
            Object object = super.createAttribute(attributeName, parameter, binderFactory, webRequest);
            return object;
        }
        finally {
            webRequest.removeAttribute(INTROSPECTOR_TARGET_CLASS, 0);
        }
    }

    public Object resolveConstructorArgument(@NonNull String paramName, @NonNull Class<?> paramType, NativeWebRequest request) throws Exception {
        Class clazz = (Class)request.getAttribute(INTROSPECTOR_TARGET_CLASS, 0);
        if (clazz == null) {
            return super.resolveConstructorArgument(paramName, paramType, request);
        }
        Map resolvers = this.introspector.getResolverMapFor(clazz);
        ResolvedPropertyData resolvedPropertyData = (ResolvedPropertyData)resolvers.get(paramName);
        RequestPropertyResolver resolver = (RequestPropertyResolver)resolvedPropertyData.getResolver();
        return resolver.resolve(resolvedPropertyData.getBindingProperty(), request);
    }
}

