/*
 * Decompiled with CFR 0.152.
 */
package com.mattbertolini.spring.web.servlet.mvc.bind.resolver;

import com.mattbertolini.spring.web.bind.annotation.RequestContext;
import com.mattbertolini.spring.web.servlet.mvc.bind.resolver.RequestPropertyResolver;
import java.time.ZoneId;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.http.HttpMethod;
import org.springframework.lang.NonNull;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.support.RequestContextUtils;

public class RequestContextRequestPropertyResolver
implements RequestPropertyResolver {
    public boolean supports(@NonNull TypeDescriptor typeDescriptor) {
        Class type = typeDescriptor.getType();
        return typeDescriptor.hasAnnotation(RequestContext.class) && (WebRequest.class.isAssignableFrom(type) || ServletRequest.class.isAssignableFrom(type) || HttpSession.class.isAssignableFrom(type) || HttpMethod.class.isAssignableFrom(type) || Locale.class.isAssignableFrom(type) || TimeZone.class.isAssignableFrom(type) || ZoneId.class.isAssignableFrom(type));
    }

    public Object resolve(@NonNull TypeDescriptor typeDescriptor, @NonNull NativeWebRequest request) {
        Class type = typeDescriptor.getType();
        if (WebRequest.class.isAssignableFrom(type)) {
            return request;
        }
        HttpServletRequest servletRequest = (HttpServletRequest)request.getNativeRequest(HttpServletRequest.class);
        if (servletRequest == null) {
            throw new IllegalStateException("An HttpServletRequest is required for this resolver to work.");
        }
        if (ServletRequest.class.isAssignableFrom(type)) {
            return servletRequest;
        }
        if (HttpSession.class.isAssignableFrom(type)) {
            return servletRequest.getSession(false);
        }
        if (HttpMethod.class.isAssignableFrom(type)) {
            return HttpMethod.resolve((String)servletRequest.getMethod());
        }
        if (Locale.class.isAssignableFrom(type)) {
            return RequestContextUtils.getLocale((HttpServletRequest)servletRequest);
        }
        if (TimeZone.class.isAssignableFrom(type)) {
            TimeZone timeZone = RequestContextUtils.getTimeZone((HttpServletRequest)servletRequest);
            return timeZone != null ? timeZone : TimeZone.getDefault();
        }
        if (ZoneId.class.isAssignableFrom(type)) {
            TimeZone timeZone = RequestContextUtils.getTimeZone((HttpServletRequest)servletRequest);
            if (timeZone == null) {
                return ZoneId.systemDefault();
            }
            return timeZone.toZoneId();
        }
        throw new UnsupportedOperationException("Unable to resolve type " + type);
    }
}

