/*
 * Decompiled with CFR 0.152.
 */
package com.mattbertolini.spring.web.servlet.mvc.bind.resolver;

import com.mattbertolini.spring.web.bind.annotation.PathParameter;
import com.mattbertolini.spring.web.servlet.mvc.bind.resolver.RequestPropertyResolver;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.lang.NonNull;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.servlet.HandlerMapping;

public class PathParameterMapRequestPropertyResolver
implements RequestPropertyResolver {
    public boolean supports(@NonNull TypeDescriptor typeDescriptor) {
        PathParameter annotation = (PathParameter)typeDescriptor.getAnnotation(PathParameter.class);
        return annotation != null && !StringUtils.hasText((String)annotation.value()) && Map.class.isAssignableFrom(typeDescriptor.getType());
    }

    public Object resolve(@NonNull TypeDescriptor typeDescriptor, @NonNull NativeWebRequest request) {
        Map uriTemplateVariables = (Map)request.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE, 0);
        if (uriTemplateVariables == null) {
            return Collections.emptyMap();
        }
        return new LinkedHashMap(uriTemplateVariables);
    }
}

