/*
 * Decompiled with CFR 0.152.
 */
package com.mattbertolini.spring.web.servlet.mvc.bind.config;

import com.mattbertolini.spring.web.bind.AbstractPropertyResolverRegistry;
import com.mattbertolini.spring.web.bind.introspect.AnnotatedRequestBeanIntrospector;
import com.mattbertolini.spring.web.bind.introspect.ClassPathScanningAnnotatedRequestBeanIntrospector;
import com.mattbertolini.spring.web.bind.introspect.DefaultAnnotatedRequestBeanIntrospector;
import com.mattbertolini.spring.web.servlet.mvc.bind.BeanParameterMethodArgumentResolver;
import com.mattbertolini.spring.web.servlet.mvc.bind.DefaultPropertyResolverRegistry;
import com.mattbertolini.spring.web.servlet.mvc.bind.PropertyResolverRegistry;
import com.mattbertolini.spring.web.servlet.mvc.bind.resolver.RequestPropertyResolver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;

public class BinderConfiguration
implements InitializingBean,
BeanPostProcessor {
    private final Set<String> packagesToScan = new LinkedHashSet<String>();
    private final PropertyResolverRegistry propertyResolverRegistry;
    private BeanParameterMethodArgumentResolver resolver;

    public BinderConfiguration() {
        this(new DefaultPropertyResolverRegistry());
    }

    public BinderConfiguration(PropertyResolverRegistry propertyResolverRegistry) {
        this.propertyResolverRegistry = propertyResolverRegistry;
    }

    public BinderConfiguration addPackageToScan(String packageToScan) {
        this.packagesToScan.add(packageToScan);
        return this;
    }

    public BinderConfiguration setPackagesToScan(Set<String> packagesToScan) {
        this.packagesToScan.addAll(packagesToScan);
        return this;
    }

    public BinderConfiguration addResolver(RequestPropertyResolver resolver) {
        this.propertyResolverRegistry.addResolver(resolver);
        return this;
    }

    public BinderConfiguration addResolvers(Set<RequestPropertyResolver> resolvers) {
        this.propertyResolverRegistry.addResolvers(resolvers);
        return this;
    }

    public BinderConfiguration addResolvers(PropertyResolverRegistry propertyResolverRegistry) {
        this.propertyResolverRegistry.addResolvers(propertyResolverRegistry);
        return this;
    }

    public Set<String> getPackagesToScan() {
        return Collections.unmodifiableSet(this.packagesToScan);
    }

    public void afterPropertiesSet() {
        DefaultAnnotatedRequestBeanIntrospector defaultIntrospector = new DefaultAnnotatedRequestBeanIntrospector((AbstractPropertyResolverRegistry)this.propertyResolverRegistry);
        ClassPathScanningAnnotatedRequestBeanIntrospector introspector = new ClassPathScanningAnnotatedRequestBeanIntrospector((AnnotatedRequestBeanIntrospector)defaultIntrospector, this.packagesToScan);
        try {
            introspector.afterPropertiesSet();
        }
        catch (Exception e) {
            throw new BeanInitializationException("Unable to create introspector");
        }
        this.resolver = new BeanParameterMethodArgumentResolver((AnnotatedRequestBeanIntrospector)introspector);
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (!(bean instanceof RequestMappingHandlerAdapter)) {
            return bean;
        }
        if (this.resolver == null) {
            throw new IllegalStateException("BeanParameterMethodArgumentResolver is null. Perhaps the afterPropertiesSet method was not called?");
        }
        RequestMappingHandlerAdapter adapter = (RequestMappingHandlerAdapter)bean;
        List currentResolvers = adapter.getCustomArgumentResolvers();
        if (currentResolvers == null) {
            currentResolvers = Collections.emptyList();
        }
        ArrayList<Object> newResolvers = new ArrayList<Object>(currentResolvers.size() + 1);
        newResolvers.addAll(currentResolvers);
        newResolvers.add((Object)this.resolver);
        adapter.setCustomArgumentResolvers(newResolvers);
        return adapter;
    }
}

