/*
 * Decompiled with CFR 0.152.
 */
package com.mattbertolini.spring.web.servlet.mvc.bind;

import com.mattbertolini.spring.web.bind.RequestPropertyBindingException;
import com.mattbertolini.spring.web.bind.annotation.BeanParameter;
import com.mattbertolini.spring.web.bind.introspect.AnnotatedRequestBeanIntrospector;
import com.mattbertolini.spring.web.bind.introspect.ResolvedPropertyData;
import com.mattbertolini.spring.web.servlet.mvc.bind.resolver.RequestPropertyResolver;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValues;
import org.springframework.core.MethodParameter;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.annotation.ModelAttributeMethodProcessor;

public class BeanParameterMethodArgumentResolver
extends ModelAttributeMethodProcessor {
    private final AnnotatedRequestBeanIntrospector introspector;

    public BeanParameterMethodArgumentResolver(@NonNull AnnotatedRequestBeanIntrospector introspector) {
        super(false);
        this.introspector = introspector;
    }

    public boolean supportsParameter(@NonNull MethodParameter parameter) {
        return parameter.hasParameterAnnotation(BeanParameter.class) && !BeanUtils.isSimpleProperty((Class)parameter.getParameterType());
    }

    public boolean supportsReturnType(@NonNull MethodParameter returnType) {
        return false;
    }

    protected void bindRequestParameters(WebDataBinder binder, @NonNull NativeWebRequest request) {
        Assert.state((binder.getTarget() != null ? 1 : 0) != 0, (String)"WebDataBinder must have a target object");
        PropertyValues propertyValues = this.makePropertyValues(binder.getTarget().getClass(), request);
        binder.bind(propertyValues);
    }

    @NonNull
    private PropertyValues makePropertyValues(@NonNull Class<?> targetType, @NonNull NativeWebRequest request) {
        MutablePropertyValues propertyValues = new MutablePropertyValues();
        List propertyData = this.introspector.getResolversFor(targetType);
        for (ResolvedPropertyData data : propertyData) {
            String propertyName = data.getPropertyName();
            RequestPropertyResolver resolver = (RequestPropertyResolver)data.getResolver();
            try {
                Object value = resolver.resolve(data.getTypeDescriptor(), request);
                if (value == null) continue;
                propertyValues.add(propertyName, value);
            }
            catch (Exception e) {
                throw new RequestPropertyBindingException("Unable to resolve property. " + e.getMessage(), (Throwable)e);
            }
        }
        return propertyValues;
    }
}

