/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.netty.channel;

import com.ning.http.client.providers.netty.channel.Channels;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.ChannelGroupFuture;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroupFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanupChannelGroup
extends DefaultChannelGroup {
    private static final Logger logger = LoggerFactory.getLogger(CleanupChannelGroup.class);
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public CleanupChannelGroup() {
    }

    public CleanupChannelGroup(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelGroupFuture close() {
        this.lock.writeLock().lock();
        try {
            if (!this.closed.getAndSet(true)) {
                ChannelGroupFuture channelGroupFuture = super.close();
                return channelGroupFuture;
            }
            ArrayList<ChannelFuture> futures = new ArrayList<ChannelFuture>();
            logger.debug("CleanupChannelGroup Already closed");
            DefaultChannelGroupFuture defaultChannelGroupFuture = new DefaultChannelGroupFuture((ChannelGroup)ChannelGroup.class.cast(this), futures);
            return defaultChannelGroupFuture;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(Channel channel) {
        this.lock.readLock().lock();
        try {
            if (this.closed.get()) {
                Channels.silentlyCloseChannel(channel);
                boolean bl = false;
                return bl;
            }
            boolean bl = super.add(channel);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

