/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.parseq.trace.codec.json;

import com.linkedin.parseq.trace.ShallowTrace;
import com.linkedin.parseq.trace.Trace;
import com.linkedin.parseq.trace.TraceRelationship;
import java.io.IOException;
import java.util.Map;
import org.codehaus.jackson.JsonGenerator;

class JsonTraceSerializer {
    private JsonTraceSerializer() {
    }

    public static void serialize(Trace trace, JsonGenerator generator) throws IOException {
        generator.writeStartObject();
        JsonTraceSerializer.writeTraces(trace, generator);
        JsonTraceSerializer.writeRelationships(trace, generator);
        generator.writeEndObject();
    }

    private static void writeTraces(Trace trace, JsonGenerator generator) throws IOException {
        generator.writeNumberField("planId", trace.getPlanId());
        generator.writeStringField("planClass", trace.getPlanClass());
        generator.writeArrayFieldStart("traces");
        for (Map.Entry<Long, ShallowTrace> entry : trace.getTraceMap().entrySet()) {
            ShallowTrace t = entry.getValue();
            JsonTraceSerializer.writeTrace(t, generator);
        }
        generator.writeEndArray();
    }

    private static void writeTrace(ShallowTrace trace, JsonGenerator generator) throws IOException {
        generator.writeStartObject();
        generator.writeNumberField("id", trace.getId());
        generator.writeStringField("name", trace.getName());
        generator.writeStringField("resultType", trace.getResultType().toString());
        generator.writeBooleanField("hidden", trace.getHidden());
        generator.writeBooleanField("systemHidden", trace.getSystemHidden());
        if (trace.getValue() != null) {
            generator.writeStringField("value", trace.getValue());
        }
        if (trace.getStartNanos() != null) {
            generator.writeNumberField("startNanos", trace.getStartNanos());
        }
        if (trace.getPendingNanos() != null) {
            generator.writeNumberField("pendingNanos", trace.getPendingNanos());
        }
        if (trace.getEndNanos() != null) {
            generator.writeNumberField("endNanos", trace.getEndNanos());
        }
        if (trace.getAttributes() != null && trace.getAttributes().size() > 0) {
            generator.writeArrayFieldStart("attributes");
            for (Map.Entry<String, String> attribute : trace.getAttributes().entrySet()) {
                generator.writeStartObject();
                generator.writeStringField("key", attribute.getKey());
                generator.writeStringField("value", attribute.getValue());
                generator.writeEndObject();
            }
            generator.writeEndArray();
        }
        if (trace.getTaskType() != null) {
            generator.writeStringField("taskType", trace.getTaskType());
        }
        generator.writeEndObject();
    }

    private static void writeRelationships(Trace trace, JsonGenerator generator) throws IOException {
        generator.writeArrayFieldStart("relationships");
        for (TraceRelationship rel : trace.getRelationships()) {
            generator.writeStartObject();
            generator.writeStringField("relationship", rel.getRelationhsip().name());
            generator.writeNumberField("from", rel.getFrom());
            generator.writeNumberField("to", rel.getTo());
            generator.writeEndObject();
        }
        generator.writeEndArray();
    }
}

