/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.parseq.trace.codec.json;

import com.linkedin.parseq.trace.Relationship;
import com.linkedin.parseq.trace.ResultType;
import com.linkedin.parseq.trace.ShallowTrace;
import com.linkedin.parseq.trace.ShallowTraceBuilder;
import com.linkedin.parseq.trace.Trace;
import com.linkedin.parseq.trace.TraceRelationship;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.codehaus.jackson.JsonNode;

class JsonTraceDeserializer {
    private JsonTraceDeserializer() {
    }

    public static Trace deserialize(JsonNode rootNode) throws IOException {
        try {
            Long planId = JsonTraceDeserializer.getLongField(rootNode, "planId");
            String planClass = JsonTraceDeserializer.getTextField(rootNode, "planClass");
            Map<Long, ShallowTrace> traceMap = JsonTraceDeserializer.parseTraces(rootNode);
            return new Trace(traceMap, JsonTraceDeserializer.parseRelationships(rootNode, traceMap), planClass, planId);
        }
        catch (RuntimeException e) {
            throw new IOException(e);
        }
    }

    private static Map<Long, ShallowTrace> parseTraces(JsonNode rootNode) throws IOException {
        HashMap<Long, ShallowTrace> traceMap = new HashMap<Long, ShallowTrace>();
        for (JsonNode traceNode : JsonTraceDeserializer.getField(rootNode, "traces")) {
            long traceId = JsonTraceDeserializer.getLongField(traceNode, "id");
            ShallowTraceBuilder shallowBuilder = new ShallowTraceBuilder(traceId);
            String name = JsonTraceDeserializer.getTextField(traceNode, "name");
            shallowBuilder.setName(name);
            if (traceNode.get("hidden") != null) {
                shallowBuilder.setHidden(JsonTraceDeserializer.getBooleanField(traceNode, "hidden"));
            }
            if (traceNode.get("systemHidden") != null) {
                shallowBuilder.setSystemHidden(JsonTraceDeserializer.getBooleanField(traceNode, "systemHidden"));
            }
            if (traceNode.get("value") != null) {
                shallowBuilder.setValue(JsonTraceDeserializer.getTextField(traceNode, "value"));
            }
            if (traceNode.get("startNanos") != null) {
                shallowBuilder.setStartNanos(JsonTraceDeserializer.getLongField(traceNode, "startNanos"));
            }
            if (traceNode.get("pendingNanos") != null) {
                shallowBuilder.setPendingNanos(JsonTraceDeserializer.getLongField(traceNode, "pendingNanos"));
            }
            if (traceNode.get("endNanos") != null) {
                shallowBuilder.setEndNanos(JsonTraceDeserializer.getLongField(traceNode, "endNanos"));
            }
            if (traceNode.get("attributes") != null) {
                for (JsonNode node : JsonTraceDeserializer.getField(traceNode, "attributes")) {
                    String key = JsonTraceDeserializer.getTextField(node, "key");
                    String value = JsonTraceDeserializer.getTextField(node, "value");
                    shallowBuilder.addAttribute(key, value);
                }
            }
            ResultType resultType = ResultType.valueOf(JsonTraceDeserializer.getTextField(traceNode, "resultType"));
            shallowBuilder.setResultType(resultType);
            if (traceNode.get("taskType") != null) {
                shallowBuilder.setTaskType(JsonTraceDeserializer.getTextField(traceNode, "taskType"));
            }
            traceMap.put(traceId, shallowBuilder.build());
        }
        return traceMap;
    }

    private static Set<TraceRelationship> parseRelationships(JsonNode rootNode, Map<Long, ShallowTrace> traceMap) throws IOException {
        HashSet<TraceRelationship> relationships = new HashSet<TraceRelationship>();
        for (JsonNode node : JsonTraceDeserializer.getField(rootNode, "relationships")) {
            Relationship relationship = Relationship.valueOf(JsonTraceDeserializer.getTextField(node, "relationship"));
            long from = JsonTraceDeserializer.getIntField(node, "from");
            long to = JsonTraceDeserializer.getIntField(node, "to");
            if (!traceMap.containsKey(from)) {
                throw new IOException("Missing trace with id: " + from + " referenced by relationship: " + (Object)((Object)relationship));
            }
            if (!traceMap.containsKey(to)) {
                throw new IOException("Missing trace with id: " + to + " referenced by relationship: " + (Object)((Object)relationship));
            }
            relationships.add(new TraceRelationship(new ShallowTraceBuilder(traceMap.get(from)), new ShallowTraceBuilder(traceMap.get(to)), relationship));
        }
        return relationships;
    }

    private static boolean getBooleanField(JsonNode node, String fieldName) throws IOException {
        return JsonTraceDeserializer.getField(node, fieldName).getBooleanValue();
    }

    private static int getIntField(JsonNode node, String fieldName) throws IOException {
        return JsonTraceDeserializer.getField(node, fieldName).getIntValue();
    }

    private static long getLongField(JsonNode node, String fieldName) throws IOException {
        return JsonTraceDeserializer.getField(node, fieldName).getLongValue();
    }

    private static String getTextField(JsonNode node, String fieldName) throws IOException {
        return JsonTraceDeserializer.getField(node, fieldName).getTextValue();
    }

    private static JsonNode getField(JsonNode node, String fieldName) throws IOException {
        JsonNode field = node.get(fieldName);
        if (field == null) {
            throw new IOException("Missing field: '" + fieldName + "' in " + node.getValueAsText());
        }
        return field;
    }
}

