/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.parseq.trace;

import com.linkedin.parseq.trace.Relationship;
import com.linkedin.parseq.trace.ShallowTrace;
import com.linkedin.parseq.trace.ShallowTraceBuilder;
import com.linkedin.parseq.trace.Trace;
import com.linkedin.parseq.trace.TraceRelationship;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class TraceBuilder {
    static final long UNKNOWN_PLAN_ID = -1L;
    static final String UNKNOWN_PLAN_CLASS = "unknown";
    private static final int INITIAL_RELATIONSHIP_ARRAY_SIZE = 128;
    private static final int INITIAL_BUILDER_ARRAY_SIZE = 128;
    private final int _maxTraceBuildersPerTrace;
    private final String _planClass;
    private final Long _planId;
    private final ArrayList<TraceRelationship> _relationships = new ArrayList(128);
    private final ArrayList<ShallowTraceBuilder> _traceBuilders = new ArrayList(128);

    public TraceBuilder(int maxRelationshipsCount) {
        this(maxRelationshipsCount, UNKNOWN_PLAN_CLASS, -1L);
    }

    public TraceBuilder(int maxRelationshipsCount, String planClass, Long planId) {
        this._maxTraceBuildersPerTrace = maxRelationshipsCount;
        this._planClass = planClass;
        this._planId = planId;
    }

    public synchronized void addShallowTrace(ShallowTraceBuilder shallowTrace) {
        if (this._traceBuilders.size() < this._maxTraceBuildersPerTrace) {
            this._traceBuilders.add(shallowTrace);
        }
    }

    public synchronized void addRelationship(Relationship relationship, ShallowTraceBuilder from, ShallowTraceBuilder to) {
        if (this._relationships.size() < this._maxTraceBuildersPerTrace) {
            TraceRelationship rel = new TraceRelationship(from, to, relationship);
            this._relationships.add(rel);
        }
    }

    public synchronized Trace build() {
        HashMap<Long, ShallowTrace> traceMap = new HashMap<Long, ShallowTrace>();
        HashSet<TraceRelationship> relationships = new HashSet<TraceRelationship>();
        for (ShallowTraceBuilder builder : this._traceBuilders) {
            traceMap.put(builder.getId(), builder.build());
        }
        block9: for (TraceRelationship rel : this._relationships) {
            traceMap.computeIfAbsent(rel._from.getId(), key -> rel._from.build());
            traceMap.computeIfAbsent(rel._to.getId(), key -> rel._to.build());
            switch (rel.getRelationhsip()) {
                case SUCCESSOR_OF: {
                    relationships.remove(new TraceRelationship(rel._from, rel._to, Relationship.POSSIBLE_SUCCESSOR_OF));
                    relationships.add(rel);
                    continue block9;
                }
                case POSSIBLE_SUCCESSOR_OF: {
                    if (relationships.contains(new TraceRelationship(rel._from, rel._to, Relationship.SUCCESSOR_OF))) continue block9;
                    relationships.add(rel);
                    continue block9;
                }
                case CHILD_OF: {
                    relationships.remove(new TraceRelationship(rel._to, rel._from, Relationship.POTENTIAL_PARENT_OF));
                    relationships.add(new TraceRelationship(rel._to, rel._from, Relationship.PARENT_OF));
                    continue block9;
                }
                case POTENTIAL_CHILD_OF: {
                    if (relationships.contains(new TraceRelationship(rel._to, rel._from, Relationship.PARENT_OF))) continue block9;
                    relationships.add(new TraceRelationship(rel._to, rel._from, Relationship.POTENTIAL_PARENT_OF));
                    continue block9;
                }
                case POTENTIAL_PARENT_OF: {
                    if (relationships.contains(new TraceRelationship(rel._from, rel._to, Relationship.PARENT_OF))) continue block9;
                    relationships.add(rel);
                    continue block9;
                }
                case PARENT_OF: {
                    relationships.remove(new TraceRelationship(rel._from, rel._to, Relationship.POTENTIAL_PARENT_OF));
                    relationships.add(rel);
                    continue block9;
                }
            }
            throw new IllegalStateException("Unknown relationship type: " + rel);
        }
        return new Trace(traceMap, relationships, this._planClass, this._planId);
    }
}

