/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.parseq.trace;

import com.linkedin.parseq.internal.ArgumentUtil;
import com.linkedin.parseq.trace.ResultType;
import com.linkedin.parseq.trace.ShallowTrace;
import java.util.Map;

public class ShallowTraceImp
implements ShallowTrace {
    private final Long _id;
    private final String _name;
    private final boolean _hidden;
    private final boolean _systemHidden;
    private final ResultType _resultType;
    private final String _value;
    private final Long _startNanos;
    private final Long _pendingNanos;
    private final Long _endNanos;
    private final Map<String, String> _attributes;
    private final String _taskType;

    ShallowTraceImp(Long id, String name, boolean hidden, boolean systemHidden, ResultType resultType, String value, Long startNanos, Long pendingNanos, Long endNanos, Map<String, String> attributes, String taskType) {
        ArgumentUtil.requireNotNull(id, "id");
        ArgumentUtil.requireNotNull(name, "name");
        ArgumentUtil.requireNotNull((Object)resultType, "resultType");
        this._id = id;
        this._name = name;
        this._hidden = hidden;
        this._value = value;
        this._resultType = resultType;
        this._startNanos = startNanos;
        this._pendingNanos = pendingNanos;
        this._endNanos = endNanos;
        this._systemHidden = systemHidden;
        this._attributes = attributes;
        this._taskType = taskType;
        switch (resultType) {
            case EARLY_FINISH: {
                if (value != null) {
                    throw new IllegalArgumentException("value cannot be set if the task is finished early");
                }
                ArgumentUtil.requireNotNull(startNanos, "startNanos");
                ArgumentUtil.requireNotNull(pendingNanos, "pendingNanos");
                ArgumentUtil.requireNotNull(endNanos, "endNanos");
                break;
            }
            case ERROR: 
            case SUCCESS: {
                ArgumentUtil.requireNotNull(startNanos, "startNanos");
                ArgumentUtil.requireNotNull(pendingNanos, "pendingNanos");
                ArgumentUtil.requireNotNull(endNanos, "endNanos");
                break;
            }
            case UNFINISHED: {
                if (value == null) break;
                throw new IllegalArgumentException("value cannot be set if the task is UNFINISHED");
            }
            default: {
                throw new IllegalArgumentException("Unexpected result type: " + (Object)((Object)resultType));
            }
        }
        if (startNanos != null && resultType != ResultType.UNFINISHED) {
            ArgumentUtil.requireNotNull(pendingNanos, "pendingNanos");
            ArgumentUtil.requireNotNull(endNanos, "endNanos");
        }
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public boolean getHidden() {
        return this._hidden;
    }

    @Override
    public boolean getSystemHidden() {
        return this._systemHidden;
    }

    @Override
    public String getValue() {
        return this._value;
    }

    @Override
    public ResultType getResultType() {
        return this._resultType;
    }

    @Override
    public Long getStartNanos() {
        return this._startNanos;
    }

    @Override
    public Long getPendingNanos() {
        return this._pendingNanos;
    }

    @Override
    public Long getEndNanos() {
        return this._endNanos;
    }

    @Override
    public Map<String, String> getAttributes() {
        return this._attributes;
    }

    @Override
    public Long getId() {
        return this._id;
    }

    @Override
    public String getTaskType() {
        return this._taskType;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._attributes == null ? 0 : this._attributes.hashCode());
        result = 31 * result + (this._endNanos == null ? 0 : this._endNanos.hashCode());
        result = 31 * result + (this._hidden ? 1231 : 1237);
        result = 31 * result + (this._id == null ? 0 : this._id.hashCode());
        result = 31 * result + (this._name == null ? 0 : this._name.hashCode());
        result = 31 * result + (this._pendingNanos == null ? 0 : this._pendingNanos.hashCode());
        result = 31 * result + (this._resultType == null ? 0 : this._resultType.hashCode());
        result = 31 * result + (this._startNanos == null ? 0 : this._startNanos.hashCode());
        result = 31 * result + (this._systemHidden ? 1231 : 1237);
        result = 31 * result + (this._value == null ? 0 : this._value.hashCode());
        result = 31 * result + (this._taskType == null ? 0 : this._taskType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ShallowTraceImp other = (ShallowTraceImp)obj;
        if (this._attributes == null ? other._attributes != null : !this._attributes.equals(other._attributes)) {
            return false;
        }
        if (this._endNanos == null ? other._endNanos != null : !this._endNanos.equals(other._endNanos)) {
            return false;
        }
        if (this._hidden != other._hidden) {
            return false;
        }
        if (this._id == null ? other._id != null : !this._id.equals(other._id)) {
            return false;
        }
        if (this._name == null ? other._name != null : !this._name.equals(other._name)) {
            return false;
        }
        if (this._pendingNanos == null ? other._pendingNanos != null : !this._pendingNanos.equals(other._pendingNanos)) {
            return false;
        }
        if (this._resultType != other._resultType) {
            return false;
        }
        if (this._startNanos == null ? other._startNanos != null : !this._startNanos.equals(other._startNanos)) {
            return false;
        }
        if (this._systemHidden != other._systemHidden) {
            return false;
        }
        if (this._value == null ? other._value != null : !this._value.equals(other._value)) {
            return false;
        }
        return !(this._taskType == null ? other._taskType != null : !this._taskType.equals(other._taskType));
    }

    public String toString() {
        return "ShallowTrace [id=" + this._id + ", name=" + this._name + ", hidden=" + this._hidden + ", systemHidden=" + this._systemHidden + ", resultType=" + (Object)((Object)this._resultType) + ", value=" + this._value + ", startNanos=" + this._startNanos + ", pendingNanos=" + this._pendingNanos + ", endNanos=" + this._endNanos + ", attributes=" + this._attributes + ", taskType=" + this._taskType + "]";
    }
}

