/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.parseq.trace;

import com.linkedin.parseq.Exceptions;
import com.linkedin.parseq.Task;

public enum ResultType {
    SUCCESS,
    ERROR,
    EARLY_FINISH,
    UNFINISHED;


    public static ResultType fromTask(Task<?> task) {
        if (!task.isDone()) {
            return UNFINISHED;
        }
        if (task.isFailed()) {
            if (Exceptions.isEarlyFinish(task.getError())) {
                return EARLY_FINISH;
            }
            return ERROR;
        }
        return SUCCESS;
    }
}

