/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.parseq.retry;

import com.linkedin.parseq.retry.ErrorClassification;
import com.linkedin.parseq.retry.RetryPolicyBuilder;
import com.linkedin.parseq.retry.backoff.BackoffPolicy;
import com.linkedin.parseq.retry.termination.RequireEither;
import com.linkedin.parseq.retry.termination.TerminationPolicy;
import java.util.function.Function;

public interface RetryPolicy {
    public String getName();

    public TerminationPolicy getTerminationPolicy();

    public BackoffPolicy getBackoffPolicy();

    public Function<Throwable, ErrorClassification> getErrorClassifier();

    public static RetryPolicy attempts(int attempts, long backoff) {
        return new RetryPolicyBuilder().setTerminationPolicy(TerminationPolicy.limitAttempts(attempts)).setBackoffPolicy(BackoffPolicy.constant(backoff)).build();
    }

    public static RetryPolicy duration(long duration, long backoff) {
        return new RetryPolicyBuilder().setTerminationPolicy(TerminationPolicy.limitDuration(duration)).setBackoffPolicy(BackoffPolicy.constant(backoff)).build();
    }

    public static RetryPolicy attemptsAndDuration(int attempts, long duration, long backoff) {
        RequireEither terminationPolicy = new RequireEither(TerminationPolicy.limitAttempts(attempts), TerminationPolicy.limitDuration(duration));
        return new RetryPolicyBuilder().setName("RetryPolicy.LimitAttemptsAndDuration").setTerminationPolicy(terminationPolicy).setBackoffPolicy(BackoffPolicy.constant(backoff)).build();
    }
}

