/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.parseq.promise;

import com.linkedin.parseq.promise.PromiseException;
import com.linkedin.parseq.promise.PromiseListener;
import com.linkedin.parseq.promise.PromiseUnresolvedException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;

public interface Promise<P> {
    public P get() throws PromiseException;

    public Throwable getError() throws PromiseUnresolvedException;

    public P getOrDefault(P var1) throws PromiseUnresolvedException;

    public void await() throws InterruptedException;

    public boolean await(long var1, TimeUnit var3) throws InterruptedException;

    public void addListener(PromiseListener<P> var1);

    public boolean isDone();

    public boolean isFailed();

    default public CompletionStage<P> toCompletionStage() {
        CompletableFuture future = new CompletableFuture();
        this.addListener(p -> {
            if (!p.isFailed()) {
                future.complete(p.get());
            } else {
                future.completeExceptionally(p.getError());
            }
        });
        return future;
    }
}

