/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.parseq.internal;

import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;

class ThreadDumper {
    private static final String INDENT = "    ";
    private ThreadMXBean tmbean = ManagementFactory.getThreadMXBean();
    private String findDeadlocksMethodName = "findDeadlockedThreads";
    private boolean canDumpLocks = true;

    ThreadDumper() {
    }

    void threadDump(StringBuilder out) {
        if (this.canDumpLocks && this.tmbean.isObjectMonitorUsageSupported() && this.tmbean.isSynchronizerUsageSupported()) {
            this.dumpThreadInfoWithLocks(out);
        } else {
            this.dumpThreadInfo(out);
        }
    }

    private void dumpThreadInfo(StringBuilder out) {
        ThreadInfo[] tinfos;
        long[] tids = this.tmbean.getAllThreadIds();
        for (ThreadInfo ti : tinfos = this.tmbean.getThreadInfo(tids, Integer.MAX_VALUE)) {
            this.dumpThreadInfo(ti, out);
        }
        out.append("\n");
        this.findDeadlock(out);
    }

    private void dumpThreadInfoWithLocks(StringBuilder out) {
        ThreadInfo[] tinfos;
        for (ThreadInfo ti : tinfos = this.tmbean.dumpAllThreads(true, true)) {
            this.dumpThreadInfo(ti, out);
            LockInfo[] syncs = ti.getLockedSynchronizers();
            this.dumpLockInfo(syncs, out);
        }
        out.append("\n");
        this.findDeadlock(out);
    }

    private void dumpThreadInfo(ThreadInfo ti, StringBuilder out) {
        this.dumpThread(ti, out);
        StackTraceElement[] stacktrace = ti.getStackTrace();
        MonitorInfo[] monitors = ti.getLockedMonitors();
        for (int i = 0; i < stacktrace.length; ++i) {
            StackTraceElement ste = stacktrace[i];
            out.append(INDENT).append("at ").append(ste).append("\n");
            for (MonitorInfo mi : monitors) {
                if (mi.getLockedStackDepth() != i) continue;
                out.append(INDENT).append("  - locked ").append(mi).append("\n");
            }
        }
        out.append("\n");
    }

    private void dumpThread(ThreadInfo ti, StringBuilder out) {
        out.append("\"").append(ti.getThreadName()).append("\"").append(" Id=").append(ti.getThreadId()).append(" ").append((Object)ti.getThreadState());
        if (ti.getLockName() != null) {
            out.append(" on lock=").append(ti.getLockName());
        }
        if (ti.isSuspended()) {
            out.append(" (suspended)");
        }
        if (ti.isInNative()) {
            out.append(" (running in native)");
        }
        out.append("\n");
        if (ti.getLockOwnerName() != null) {
            out.append(INDENT).append(" owned by ").append(ti.getLockOwnerName()).append(" Id=").append(ti.getLockOwnerId()).append("\n");
        }
    }

    private void dumpLockInfo(LockInfo[] locks, StringBuilder out) {
        if (locks.length > 0) {
            out.append(INDENT).append("Locked synchronizers: count = ").append(locks.length).append("\n");
            for (LockInfo li : locks) {
                out.append(INDENT).append("  - ").append(li).append("\n");
            }
            out.append("\n");
        }
    }

    private void findDeadlock(StringBuilder out) {
        if (this.findDeadlocksMethodName.equals("findDeadlockedThreads") && this.tmbean.isSynchronizerUsageSupported()) {
            ThreadInfo[] infos;
            long[] tids = this.tmbean.findDeadlockedThreads();
            if (tids == null) {
                return;
            }
            out.append("Deadlock found:\n");
            for (ThreadInfo ti : infos = this.tmbean.getThreadInfo(tids, true, true)) {
                this.dumpThreadInfo(ti, out);
                this.dumpLockInfo(ti.getLockedSynchronizers(), out);
                out.append("\n");
            }
        } else {
            ThreadInfo[] infos;
            long[] tids = this.tmbean.findMonitorDeadlockedThreads();
            if (tids == null) {
                return;
            }
            for (ThreadInfo ti : infos = this.tmbean.getThreadInfo(tids, Integer.MAX_VALUE)) {
                this.dumpThreadInfo(ti, out);
            }
        }
    }
}

