/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.parseq.internal;

import com.linkedin.parseq.internal.ArgumentUtil;
import com.linkedin.parseq.internal.ExecutionMonitor;
import com.linkedin.parseq.internal.Prioritizable;
import com.linkedin.parseq.internal.PrioritizableRunnable;
import com.linkedin.parseq.internal.UncaughtExceptionHandler;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;

public class SerialExecutor {
    private final Executor _executor;
    private final UncaughtExceptionHandler _uncaughtExecutionHandler;
    private final Runnable _executorLoop;
    private final TaskQueue<PrioritizableRunnable> _queue;
    private final AtomicInteger _pendingCount = new AtomicInteger();
    private final DeactivationListener _deactivationListener;
    private final ExecutionMonitor _executionMonitor;

    public SerialExecutor(Executor executor, UncaughtExceptionHandler uncaughtExecutionHandler, DeactivationListener deactivationListener, TaskQueue<PrioritizableRunnable> taskQueue, boolean drainSerialExecutorQueue, ExecutionMonitor executionMonitor) {
        ArgumentUtil.requireNotNull(executor, "executor");
        ArgumentUtil.requireNotNull(uncaughtExecutionHandler, "uncaughtExecutionHandler");
        ArgumentUtil.requireNotNull(deactivationListener, "deactivationListener");
        this._executor = executor;
        this._uncaughtExecutionHandler = uncaughtExecutionHandler;
        this._queue = taskQueue;
        this._deactivationListener = deactivationListener;
        this._executorLoop = drainSerialExecutorQueue ? new DrainingExecutorLoop() : new NonDrainingExecutorLoop();
        this._executionMonitor = executionMonitor;
    }

    public void execute(PrioritizableRunnable runnable) {
        this._queue.add(runnable);
        if (this._pendingCount.getAndIncrement() == 0) {
            this.tryExecuteLoop();
        }
    }

    private void tryExecuteLoop() {
        try {
            this._executor.execute(this._executorLoop);
        }
        catch (Throwable t) {
            this._uncaughtExecutionHandler.uncaughtException(t);
        }
    }

    static interface DeactivationListener {
        public void deactivated();
    }

    public static interface TaskQueue<T extends Prioritizable> {
        public void add(T var1);

        public T poll();
    }

    private class NonDrainingExecutorLoop
    implements Runnable {
        private NonDrainingExecutorLoop() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ExecutionMonitor.ExecutionMonitorState executionState;
            ExecutionMonitor.ExecutionMonitorState executionMonitorState = executionState = SerialExecutor.this._executionMonitor != null ? SerialExecutor.this._executionMonitor.getLocalMonitorState() : null;
            if (executionState != null) {
                executionState.activate();
            }
            Runnable runnable = (Runnable)SerialExecutor.this._queue.poll();
            try {
                runnable.run();
                if (SerialExecutor.this._pendingCount.get() == 1) {
                    SerialExecutor.this._deactivationListener.deactivated();
                }
            }
            catch (Throwable t) {
                SerialExecutor.this._uncaughtExecutionHandler.uncaughtException(t);
            }
            finally {
                if (SerialExecutor.this._pendingCount.decrementAndGet() > 0) {
                    SerialExecutor.this.tryExecuteLoop();
                }
            }
            if (executionState != null) {
                executionState.deactivate();
            }
        }
    }

    private class DrainingExecutorLoop
    implements Runnable {
        private DrainingExecutorLoop() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ExecutionMonitor.ExecutionMonitorState executionState;
            ExecutionMonitor.ExecutionMonitorState executionMonitorState = executionState = SerialExecutor.this._executionMonitor != null ? SerialExecutor.this._executionMonitor.getLocalMonitorState() : null;
            while (true) {
                if (executionState != null) {
                    executionState.activate();
                }
                Runnable runnable = (Runnable)SerialExecutor.this._queue.poll();
                try {
                    runnable.run();
                    if (SerialExecutor.this._pendingCount.get() != 1) continue;
                    SerialExecutor.this._deactivationListener.deactivated();
                    continue;
                }
                catch (Throwable t) {
                    SerialExecutor.this._uncaughtExecutionHandler.uncaughtException(t);
                }
                finally {
                    if (SerialExecutor.this._pendingCount.decrementAndGet() == 0) break;
                    continue;
                }
                break;
            }
            if (executionState != null) {
                executionState.deactivate();
            }
        }
    }
}

