/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.parseq.internal;

import com.linkedin.parseq.internal.PlanBasedRateLimiter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class DefaultPlanBasedRateLimiter
implements PlanBasedRateLimiter {
    private final Map<String, Semaphore> _concurrentPlansPerClass;

    public DefaultPlanBasedRateLimiter(Map<String, Integer> planConcurrencyConfig) {
        this._concurrentPlansPerClass = new ConcurrentHashMap<String, Semaphore>(planConcurrencyConfig.size());
        planConcurrencyConfig.forEach((planClass, concurrency) -> this._concurrentPlansPerClass.put((String)planClass, new Semaphore((int)concurrency)));
    }

    @Override
    public boolean tryAcquire(String planClass) {
        return this._concurrentPlansPerClass.containsKey(planClass) ? this._concurrentPlansPerClass.get(planClass).tryAcquire() : true;
    }

    @Override
    public boolean tryAcquire(String planClass, long timeout, TimeUnit unit) throws InterruptedException {
        return this._concurrentPlansPerClass.containsKey(planClass) ? this._concurrentPlansPerClass.get(planClass).tryAcquire(timeout, unit) : true;
    }

    @Override
    public void acquire(String planClass) throws InterruptedException {
        if (this._concurrentPlansPerClass.containsKey(planClass)) {
            this._concurrentPlansPerClass.get(planClass).acquire();
        }
    }

    @Override
    public void release(String planClass) {
        if (this._concurrentPlansPerClass.containsKey(planClass)) {
            this._concurrentPlansPerClass.get(planClass).release();
        }
    }
}

