/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.parseq.internal;

import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;

public class CachedLoggerFactory
implements ILoggerFactory {
    private final ILoggerFactory _loggerFactory;
    private final ConcurrentHashMap<String, Logger> _loggers;

    public CachedLoggerFactory(ILoggerFactory loggerFactory) {
        this._loggerFactory = loggerFactory;
        this._loggers = new ConcurrentHashMap();
    }

    @Override
    public Logger getLogger(String name) {
        return this._loggers.computeIfAbsent(name, this._loggerFactory::getLogger);
    }
}

