/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.parseq.internal;

public class ArgumentUtil {
    private ArgumentUtil() {
    }

    public static void requireNotNull(Object obj, String name) {
        if (obj == null) {
            throw new NullPointerException(name + " must not be null");
        }
    }

    public static void requireNotEmpty(String str, String name) {
        ArgumentUtil.requireNotNull(str, name);
        if (str.isEmpty()) {
            throw new IllegalArgumentException(name + " is an empty string");
        }
    }

    public static void requirePositive(int n, String name) {
        if (n <= 0) {
            throw new IllegalArgumentException(name + " must be a positive integer number, but is: " + n);
        }
    }

    public static void requirePositive(long n, String name) {
        if (n <= 0L) {
            throw new IllegalArgumentException(name + " must be a positive long number, but is: " + n);
        }
    }
}

