/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.parseq.httpclient;

import com.linkedin.parseq.Task;
import com.linkedin.parseq.promise.Promises;
import com.linkedin.parseq.promise.SettablePromise;
import com.ning.http.client.AsyncCompletionHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.BodyGenerator;
import com.ning.http.client.ConnectionPoolPartitioning;
import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.Param;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.Realm;
import com.ning.http.client.Request;
import com.ning.http.client.Response;
import com.ning.http.client.SignatureCalculator;
import com.ning.http.client.cookie.Cookie;
import com.ning.http.client.multipart.Part;
import com.ning.http.client.uri.Uri;
import java.io.File;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class WrappedRequestBuilder {
    private final AsyncHttpClient.BoundRequestBuilder _delegate;
    private final String _method;

    public WrappedRequestBuilder(AsyncHttpClient.BoundRequestBuilder delegate, String method) {
        this._delegate = delegate;
        this._method = method;
    }

    public int hashCode() {
        return this._delegate.hashCode();
    }

    public boolean equals(Object obj) {
        return this._delegate.equals(obj);
    }

    public String toString() {
        return this._delegate.toString();
    }

    public WrappedRequestBuilder setUri(Uri uri) {
        this._delegate.setUri(uri);
        return this;
    }

    public WrappedRequestBuilder addBodyPart(Part part) {
        this._delegate.addBodyPart(part);
        return this;
    }

    public WrappedRequestBuilder setInetAddress(InetAddress address) {
        this._delegate.setInetAddress(address);
        return this;
    }

    public WrappedRequestBuilder setLocalInetAddress(InetAddress address) {
        this._delegate.setLocalInetAddress(address);
        return this;
    }

    public WrappedRequestBuilder addCookie(Cookie cookie) {
        this._delegate.addCookie(cookie);
        return this;
    }

    public WrappedRequestBuilder addHeader(String name, String value) {
        this._delegate.addHeader(name, value);
        return this;
    }

    public WrappedRequestBuilder addFormParam(String key, String value) {
        this._delegate.addFormParam(key, value);
        return this;
    }

    public WrappedRequestBuilder addQueryParam(String name, String value) {
        this._delegate.addQueryParam(name, value);
        return this;
    }

    public Request build() {
        return this._delegate.build();
    }

    public WrappedRequestBuilder setBody(byte[] data) {
        this._delegate.setBody(data);
        return this;
    }

    public WrappedRequestBuilder setBody(InputStream stream) {
        this._delegate.setBody(stream);
        return this;
    }

    public WrappedRequestBuilder setContentLength(int length) {
        this._delegate.setContentLength(length);
        return this;
    }

    public WrappedRequestBuilder setBody(String data) {
        this._delegate.setBody(data);
        return this;
    }

    public WrappedRequestBuilder setHeader(String name, String value) {
        this._delegate.setHeader(name, value);
        return this;
    }

    public WrappedRequestBuilder setCookies(Collection<Cookie> cookies) {
        this._delegate.setCookies(cookies);
        return this;
    }

    public WrappedRequestBuilder setHeaders(FluentCaseInsensitiveStringsMap headers) {
        this._delegate.setHeaders(headers);
        return this;
    }

    public WrappedRequestBuilder setHeaders(Map<String, Collection<String>> headers) {
        this._delegate.setHeaders((Map)headers);
        return this;
    }

    public WrappedRequestBuilder addOrReplaceCookie(Cookie cookie) {
        this._delegate.addOrReplaceCookie(cookie);
        return this;
    }

    public WrappedRequestBuilder setFormParams(Map<String, List<String>> params) {
        this._delegate.setFormParams((Map)params);
        return this;
    }

    public WrappedRequestBuilder setFormParams(List<Param> params) {
        this._delegate.setFormParams((List)params);
        return this;
    }

    public WrappedRequestBuilder setUrl(String url) {
        this._delegate.setUrl(url);
        return this;
    }

    public WrappedRequestBuilder setVirtualHost(String virtualHost) {
        this._delegate.setVirtualHost(virtualHost);
        return this;
    }

    public void resetCookies() {
        this._delegate.resetCookies();
    }

    public void resetQuery() {
        this._delegate.resetQuery();
    }

    public WrappedRequestBuilder setSignatureCalculator(SignatureCalculator signatureCalculator) {
        this._delegate.setSignatureCalculator(signatureCalculator);
        return this;
    }

    public void resetFormParams() {
        this._delegate.resetFormParams();
    }

    public void resetNonMultipartData() {
        this._delegate.resetNonMultipartData();
    }

    public void resetMultipartData() {
        this._delegate.resetMultipartData();
    }

    public WrappedRequestBuilder setBody(File file) {
        this._delegate.setBody(file);
        return this;
    }

    public WrappedRequestBuilder setBody(List<byte[]> data) {
        this._delegate.setBody(data);
        return this;
    }

    public WrappedRequestBuilder setBody(BodyGenerator bodyGenerator) {
        this._delegate.setBody(bodyGenerator);
        return this;
    }

    public WrappedRequestBuilder addQueryParams(List<Param> params) {
        this._delegate.addQueryParams(params);
        return this;
    }

    public WrappedRequestBuilder setQueryParams(Map<String, List<String>> map) {
        this._delegate.setQueryParams(map);
        return this;
    }

    public WrappedRequestBuilder setQueryParams(List<Param> params) {
        this._delegate.setQueryParams(params);
        return this;
    }

    public WrappedRequestBuilder setProxyServer(ProxyServer proxyServer) {
        this._delegate.setProxyServer(proxyServer);
        return this;
    }

    public WrappedRequestBuilder setRealm(Realm realm) {
        this._delegate.setRealm(realm);
        return this;
    }

    public WrappedRequestBuilder setFollowRedirects(boolean followRedirects) {
        this._delegate.setFollowRedirects(followRedirects);
        return this;
    }

    public WrappedRequestBuilder setRequestTimeout(int requestTimeout) {
        this._delegate.setRequestTimeout(requestTimeout);
        return this;
    }

    public WrappedRequestBuilder setRangeOffset(long rangeOffset) {
        this._delegate.setRangeOffset(rangeOffset);
        return this;
    }

    public WrappedRequestBuilder setMethod(String method) {
        this._delegate.setMethod(method);
        return this;
    }

    public WrappedRequestBuilder setBodyEncoding(String charset) {
        this._delegate.setBodyEncoding(charset);
        return this;
    }

    public WrappedRequestBuilder setConnectionPoolKeyStrategy(ConnectionPoolPartitioning connectionPoolKeyStrategy) {
        this._delegate.setConnectionPoolKeyStrategy(connectionPoolKeyStrategy);
        return this;
    }

    public Task<Response> task(String desc) {
        return Task.async(desc, () -> {
            final SettablePromise result = Promises.settable();
            this._delegate.execute(new AsyncCompletionHandler<Response>(){

                @Override
                public Response onCompleted(Response response) throws Exception {
                    result.done(response);
                    return response;
                }

                @Override
                public void onThrowable(Throwable t) {
                    result.fail(t);
                }
            });
            return result;
        });
    }

    public Task<Response> task() {
        return this.task(this._method);
    }
}

