/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.parseq.httpclient;

import com.linkedin.parseq.httpclient.WrappedRequestBuilder;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import java.util.concurrent.atomic.AtomicReference;

public class HttpClient {
    private static final AtomicReference<AsyncHttpClient> _client = new AtomicReference();

    public static synchronized AsyncHttpClient getNingClient() {
        if (_client.get() == null) {
            HttpClient.initialize(new AsyncHttpClientConfig.Builder().build());
        }
        return _client.get();
    }

    public static synchronized void initialize(AsyncHttpClientConfig cfg) {
        if (!_client.compareAndSet(null, new AsyncHttpClient(cfg))) {
            throw new RuntimeException("async http client concurrently initialized");
        }
    }

    public static void close() {
        if (_client.get() != null) {
            _client.get().close();
        }
    }

    public static WrappedRequestBuilder get(String url) {
        return new WrappedRequestBuilder(HttpClient.getNingClient().prepareGet(url), "GET " + url);
    }

    public static WrappedRequestBuilder connect(String url) {
        return new WrappedRequestBuilder(HttpClient.getNingClient().prepareConnect(url), "CONNECT " + url);
    }

    public static WrappedRequestBuilder options(String url) {
        return new WrappedRequestBuilder(HttpClient.getNingClient().prepareOptions(url), "OPTIONS " + url);
    }

    public static WrappedRequestBuilder head(String url) {
        return new WrappedRequestBuilder(HttpClient.getNingClient().prepareHead(url), "HEAD " + url);
    }

    public static WrappedRequestBuilder post(String url) {
        return new WrappedRequestBuilder(HttpClient.getNingClient().preparePost(url), "POST " + url);
    }

    public static WrappedRequestBuilder put(String url) {
        return new WrappedRequestBuilder(HttpClient.getNingClient().preparePut(url), "PUT " + url);
    }

    public static WrappedRequestBuilder delete(String url) {
        return new WrappedRequestBuilder(HttpClient.getNingClient().prepareDelete(url), "DELETE " + url);
    }
}

