/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.parseq;

import com.linkedin.parseq.DotHandler;
import com.linkedin.parseq.Engine;
import com.linkedin.parseq.EngineBuilder;
import com.linkedin.parseq.GraphvizEngine;
import com.linkedin.parseq.HealthCheckHandler;
import com.linkedin.parseq.JhatHandler;
import com.linkedin.parseq.TracePostHandler;
import com.linkedin.parseq.httpclient.HttpClient;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TracevisServer {
    private static final Logger LOG = LoggerFactory.getLogger(TracevisServer.class);
    private final Path _staticContentLocation;
    private final Path _heapsterContentLocation;
    private final Path _cacheLocation;
    private final int _cacheSize;
    private final long _timeoutMs;
    private final int _port;
    private final String _dotLocation;
    final GraphvizEngine _graphvizEngine;

    public TracevisServer(String dotLocation, int port, Path baseLocation, Path heapsterLocation, int cacheSize, long timeoutMs) {
        this._dotLocation = dotLocation;
        this._port = port;
        this._staticContentLocation = baseLocation.resolve("tracevis");
        this._heapsterContentLocation = heapsterLocation.resolve("heapster");
        this._cacheLocation = this._staticContentLocation.resolve("cache");
        this._cacheSize = cacheSize;
        this._timeoutMs = timeoutMs;
        this._graphvizEngine = new GraphvizEngine(this._dotLocation, this._cacheLocation, this._cacheSize, this._timeoutMs, Runtime.getRuntime().availableProcessors(), 5L, 1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        LOG.info("TracevisServer base location: " + this._staticContentLocation + ", heapster location: " + this._heapsterContentLocation);
        LOG.info("Starting TracevisServer on port: " + this._port + ", graphviz location: " + this._dotLocation + ", cache size: " + this._cacheSize + ", graphviz timeout: " + this._timeoutMs + "ms");
        ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors() + 1);
        Engine engine = new EngineBuilder().setTaskExecutor(scheduler).setTimerScheduler(scheduler).build();
        Files.createDirectories(this._cacheLocation, new FileAttribute[0]);
        for (File f : this._cacheLocation.toFile().listFiles()) {
            f.delete();
        }
        this._graphvizEngine.start();
        Server server = new Server();
        server.setAttribute("org.eclipse.jetty.server.Request.maxFormContentSize", -1);
        server.setConnectors(this.getConnectors(server));
        TracePostHandler tracePostHandler = new TracePostHandler(this._staticContentLocation.toString());
        ResourceHandler traceHandler = new ResourceHandler();
        traceHandler.setDirectoriesListed(true);
        traceHandler.setWelcomeFiles(new String[]{"trace.html"});
        traceHandler.setResourceBase(this._staticContentLocation.toString());
        ResourceHandler heapsterHandler = new ResourceHandler();
        heapsterHandler.setDirectoriesListed(true);
        heapsterHandler.setResourceBase(this._heapsterContentLocation.toString());
        HandlerList handlers = new HandlerList();
        handlers.setHandlers(new Handler[]{new DotHandler(this._graphvizEngine, engine), new JhatHandler(engine), tracePostHandler, traceHandler, new HealthCheckHandler(), heapsterHandler, new DefaultHandler()});
        server.setHandler(handlers);
        try {
            server.start();
            server.join();
        }
        finally {
            server.stop();
            this._graphvizEngine.stop();
            engine.shutdown();
            scheduler.shutdownNow();
            HttpClient.close();
        }
    }

    protected Connector[] getConnectors(Server server) {
        ServerConnector connector = new ServerConnector(server);
        connector.setPort(this._port);
        return new Connector[]{connector};
    }
}

