/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.parseq;

import com.linkedin.parseq.TracevisServer;
import java.nio.file.Path;
import java.util.Arrays;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class TracevisHttpsServer
extends TracevisServer {
    private final int _sslPort;
    private final String _keyStorePath;
    private final String _keyStorePassword;
    private final String _trustStorePath;
    private final String _trustStorePassword;

    public TracevisHttpsServer(String dotLocation, int port, Path baseLocation, Path heapsterLocation, int cacheSize, long timeoutMs, int sslPort, String keyStorePath, String keyStorePassword, String trustStorePath, String trustStorePassword) {
        super(dotLocation, port, baseLocation, heapsterLocation, cacheSize, timeoutMs);
        this._sslPort = sslPort;
        this._keyStorePath = keyStorePath;
        this._keyStorePassword = keyStorePassword;
        this._trustStorePath = trustStorePath;
        this._trustStorePassword = trustStorePassword;
    }

    @Override
    protected Connector[] getConnectors(Server server) {
        SslContextFactory sslContextFactory = new SslContextFactory();
        sslContextFactory.setKeyStorePath(this._keyStorePath);
        sslContextFactory.setKeyStorePassword(this._keyStorePassword);
        sslContextFactory.setTrustStorePath(this._trustStorePath);
        sslContextFactory.setTrustStorePassword(this._trustStorePassword);
        HttpConfiguration config = new HttpConfiguration();
        config.setSecureScheme(HttpScheme.HTTPS.asString());
        config.addCustomizer(new SecureRequestCustomizer());
        ServerConnector sslConnector = new ServerConnector(server, new SslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(config));
        sslConnector.setPort(this._sslPort);
        Connector[] httpConnectors = super.getConnectors(server);
        Connector[] connectors = Arrays.copyOf(httpConnectors, httpConnectors.length + 1);
        connectors[httpConnectors.length] = sslConnector;
        return connectors;
    }
}

