/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.parseq;

import com.linkedin.parseq.BaseTask;
import com.linkedin.parseq.Cancellable;
import com.linkedin.parseq.Context;
import com.linkedin.parseq.Exceptions;
import com.linkedin.parseq.FusionTask;
import com.linkedin.parseq.Par10Task;
import com.linkedin.parseq.Par11Task;
import com.linkedin.parseq.Par12Task;
import com.linkedin.parseq.Par13Task;
import com.linkedin.parseq.Par14Task;
import com.linkedin.parseq.Par15Task;
import com.linkedin.parseq.Par2Task;
import com.linkedin.parseq.Par3Task;
import com.linkedin.parseq.Par4Task;
import com.linkedin.parseq.Par5Task;
import com.linkedin.parseq.Par6Task;
import com.linkedin.parseq.Par7Task;
import com.linkedin.parseq.Par8Task;
import com.linkedin.parseq.Par9Task;
import com.linkedin.parseq.ParTask;
import com.linkedin.parseq.ParTaskImpl;
import com.linkedin.parseq.TaskDescriptor;
import com.linkedin.parseq.TaskDescriptorFactory;
import com.linkedin.parseq.TaskType;
import com.linkedin.parseq.Tuple10Task;
import com.linkedin.parseq.Tuple11Task;
import com.linkedin.parseq.Tuple12Task;
import com.linkedin.parseq.Tuple13Task;
import com.linkedin.parseq.Tuple14Task;
import com.linkedin.parseq.Tuple15Task;
import com.linkedin.parseq.Tuple2Task;
import com.linkedin.parseq.Tuple3Task;
import com.linkedin.parseq.Tuple4Task;
import com.linkedin.parseq.Tuple5Task;
import com.linkedin.parseq.Tuple6Task;
import com.linkedin.parseq.Tuple7Task;
import com.linkedin.parseq.Tuple8Task;
import com.linkedin.parseq.Tuple9Task;
import com.linkedin.parseq.function.Action;
import com.linkedin.parseq.function.Consumer1;
import com.linkedin.parseq.function.Function1;
import com.linkedin.parseq.function.Try;
import com.linkedin.parseq.internal.ArgumentUtil;
import com.linkedin.parseq.internal.TimeUnitHelper;
import com.linkedin.parseq.promise.Promise;
import com.linkedin.parseq.promise.PromisePropagator;
import com.linkedin.parseq.promise.PromiseTransformer;
import com.linkedin.parseq.promise.Promises;
import com.linkedin.parseq.promise.SettablePromise;
import com.linkedin.parseq.retry.RetriableTask;
import com.linkedin.parseq.retry.RetryPolicy;
import com.linkedin.parseq.trace.ShallowTrace;
import com.linkedin.parseq.trace.ShallowTraceBuilder;
import com.linkedin.parseq.trace.Trace;
import com.linkedin.parseq.trace.TraceBuilder;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Task<T>
extends Promise<T>,
Cancellable {
    public static final Logger LOGGER = LoggerFactory.getLogger(Task.class);
    public static final TaskDescriptor _taskDescriptor = TaskDescriptorFactory.getTaskDescriptor();

    public String getName();

    public int getPriority();

    public boolean setPriority(int var1);

    public void setTraceValueSerializer(Function<T, String> var1);

    public void contextRun(Context var1, Task<?> var2, Collection<Task<?>> var3);

    public ShallowTrace getShallowTrace();

    public Trace getTrace();

    public Long getId();

    public ShallowTraceBuilder getShallowTraceBuilder();

    public TraceBuilder getTraceBuilder();

    default public <R> Task<R> apply(String desc, PromisePropagator<T, R> propagator) {
        return FusionTask.create(desc, this, propagator);
    }

    default public <R> Task<R> map(String desc, Function1<? super T, ? extends R> func) {
        ArgumentUtil.requireNotNull(func, "function");
        return this.apply(desc, new PromiseTransformer<T, R>(func));
    }

    default public <R> Task<R> map(Function1<? super T, ? extends R> func) {
        return this.map("map: " + _taskDescriptor.getDescription(func.getClass().getName()), func);
    }

    default public <R> Task<R> flatMap(String desc, Function1<? super T, Task<R>> func) {
        ArgumentUtil.requireNotNull(func, "function");
        Function1<Object, Task> flatMapFunc = x -> {
            Task t = (Task)func.apply((Object)x);
            if (t == null) {
                throw new RuntimeException(desc + " returned null");
            }
            return t;
        };
        Task<Task<R>> nested = this.map(desc, flatMapFunc);
        nested.getShallowTraceBuilder().setSystemHidden(true);
        return Task.flatten(desc, nested);
    }

    default public <R> Task<R> flatMap(Function1<? super T, Task<R>> func) {
        return this.flatMap("flatMap: " + _taskDescriptor.getDescription(func.getClass().getName()), func);
    }

    default public Task<T> withSideEffect(String desc, Function1<? super T, Task<?>> func) {
        ArgumentUtil.requireNotNull(func, "function");
        Task that = this;
        Task<T> withSideEffectTask = Task.async("withSideEffect", (Context context) -> {
            Task sideEffectWrapper = Task.async(desc, (Context ctx) -> {
                SettablePromise promise = Promises.settable();
                if (!that.isFailed()) {
                    Task sideEffect = (Task)func.apply((Object)that.get());
                    if (sideEffect == null) {
                        throw new RuntimeException(desc + " returned null");
                    }
                    ctx.runSideEffect(sideEffect);
                }
                Promises.propagateResult(that, promise);
                return promise;
            });
            context.after(that).run(sideEffectWrapper);
            context.run(that);
            return sideEffectWrapper;
        });
        withSideEffectTask.getShallowTraceBuilder().setTaskType(TaskType.WITH_SIDE_EFFECT.getName());
        return withSideEffectTask;
    }

    default public Task<T> withSideEffect(Function1<? super T, Task<?>> func) {
        return this.withSideEffect("sideEffect: " + _taskDescriptor.getDescription(func.getClass().getName()), func);
    }

    public static <T> Task<Void> withSideEffect(String desc, Callable<Task<T>> func) {
        ArgumentUtil.requireNotNull(func, "function");
        Task<T> sideEffectWrapper = Task.async(desc, (Context ctx) -> {
            Task sideEffect = (Task)func.call();
            ctx.runSideEffect(sideEffect);
            return Promises.value(null);
        });
        sideEffectWrapper.getShallowTraceBuilder().setTaskType(TaskType.WITH_SIDE_EFFECT.getName());
        return sideEffectWrapper;
    }

    public static <T> Task<Void> withSideEffect(Callable<Task<T>> func) {
        return Task.withSideEffect("withSideEffect", func);
    }

    default public Task<T> withSafeSideEffect(String desc, Function1<? super T, Task<?>> func) {
        return this.withSideEffect(desc, param -> {
            try {
                Task task = (Task)func.apply((Object)param);
                if (task == null) {
                    throw new RuntimeException(desc + " returned null");
                }
                return task;
            }
            catch (Throwable t) {
                return Task.failure(desc, t);
            }
        });
    }

    default public Task<T> withSafeSideEffect(Function1<? super T, Task<?>> func) {
        return this.withSafeSideEffect("withSafeSideEffect", func);
    }

    public static <T> Task<Void> withSafeSideEffect(String desc, Callable<Task<T>> func) {
        return Task.withSideEffect(desc, () -> {
            try {
                Task task = (Task)func.call();
                if (task == null) {
                    throw new RuntimeException(desc + "returned null");
                }
                return task;
            }
            catch (Throwable t) {
                return Task.failure(desc, t);
            }
        });
    }

    public static <T> Task<Void> withSafeSideEffect(Callable<Task<T>> func) {
        return Task.withSafeSideEffect("withSafeSideEffect", func);
    }

    default public Task<T> shareable() {
        Task that = this;
        Task<T> shareableTask = Task.async("shareable", (Context context) -> {
            SettablePromise result = Promises.settable();
            context.runSideEffect(that);
            Promises.propagateResult(that, result);
            return result;
        });
        shareableTask.getShallowTraceBuilder().setTaskType(TaskType.SHAREABLE.getName());
        return shareableTask;
    }

    default public Task<T> andThen(String desc, Consumer1<? super T> consumer) {
        ArgumentUtil.requireNotNull(consumer, "consumer");
        return this.apply(desc, new PromiseTransformer<Object, Object>(t -> {
            consumer.accept((Object)t);
            return t;
        }));
    }

    default public Task<T> andThen(Consumer1<? super T> consumer) {
        return this.andThen("andThen: " + _taskDescriptor.getDescription(consumer.getClass().getName()), consumer);
    }

    default public <R> Task<R> andThen(String desc, Task<R> task) {
        ArgumentUtil.requireNotNull(task, "task");
        Task that = this;
        return Task.async(desc, (Context context) -> {
            SettablePromise result = Promises.settable();
            context.after(that).run(task);
            Promises.propagateResult(task, result);
            context.run(that);
            return result;
        });
    }

    default public <R> Task<R> andThen(Task<R> task) {
        return this.andThen("andThen: " + task.getName(), task);
    }

    default public Task<T> recover(String desc, Function1<Throwable, T> func) {
        ArgumentUtil.requireNotNull(func, "function");
        return this.apply(desc, (src, dst) -> {
            if (src.isFailed()) {
                if (!Exceptions.isCancellation(src.getError())) {
                    try {
                        dst.done(func.apply(src.getError()));
                    }
                    catch (Throwable t) {
                        dst.fail(t);
                    }
                } else {
                    dst.fail(src.getError());
                }
            } else {
                dst.done(src.get());
            }
        });
    }

    default public Task<T> recover(Function1<Throwable, T> func) {
        return this.recover("recover: " + _taskDescriptor.getDescription(func.getClass().getName()), func);
    }

    default public Task<T> onFailure(String desc, Consumer1<Throwable> consumer) {
        ArgumentUtil.requireNotNull(consumer, "consumer");
        return this.apply(desc, (src, dst) -> {
            if (src.isFailed()) {
                if (!Exceptions.isCancellation(src.getError())) {
                    try {
                        consumer.accept(src.getError());
                    }
                    catch (Exception e) {
                        LOGGER.error("Exception thrown by onFailure consumer: ", e);
                    }
                    finally {
                        dst.fail(src.getError());
                    }
                } else {
                    dst.fail(src.getError());
                }
            } else {
                dst.done(src.get());
            }
        });
    }

    default public Task<T> onFailure(Consumer1<Throwable> consumer) {
        return this.onFailure("onFailure: " + _taskDescriptor.getDescription(consumer.getClass().getName()), consumer);
    }

    default public Task<Try<T>> toTry(String desc) {
        return this.apply(desc, (src, dst) -> {
            Try tryT = Promises.toTry(src);
            if (tryT.isFailed() && Exceptions.isCancellation(tryT.getError())) {
                dst.fail(src.getError());
            } else {
                dst.done(Promises.toTry(src));
            }
        });
    }

    default public Task<Try<T>> toTry() {
        return this.toTry("toTry");
    }

    default public <R> Task<R> transform(String desc, Function1<Try<T>, Try<R>> func) {
        ArgumentUtil.requireNotNull(func, "function");
        return this.apply(desc, (src, dst) -> {
            Try tryT = Promises.toTry(src);
            if (tryT.isFailed() && Exceptions.isCancellation(tryT.getError())) {
                dst.fail(src.getError());
            } else {
                try {
                    Try tryR = (Try)func.apply(tryT);
                    if (tryR.isFailed()) {
                        dst.fail(tryR.getError());
                    } else {
                        dst.done(tryR.get());
                    }
                }
                catch (Exception e) {
                    dst.fail(e);
                }
            }
        });
    }

    default public <R> Task<R> transform(Function1<Try<T>, Try<R>> func) {
        return this.transform("transform: " + _taskDescriptor.getDescription(func.getClass().getName()), func);
    }

    default public Task<T> recoverWith(String desc, Function1<Throwable, Task<T>> func) {
        ArgumentUtil.requireNotNull(func, "function");
        Task that = this;
        Task<T> recoverWithTask = Task.async(desc, (Context context) -> {
            SettablePromise result = Promises.settable();
            Task recovery = Task.async("recovery", (Context ctx) -> {
                SettablePromise recoveryResult = Promises.settable();
                if (that.isFailed()) {
                    if (!Exceptions.isCancellation(that.getError())) {
                        try {
                            Task r = (Task)func.apply(that.getError());
                            if (r == null) {
                                throw new RuntimeException(desc + " returned null");
                            }
                            Promises.propagateResult(r, recoveryResult);
                            ctx.run(r);
                        }
                        catch (Throwable t) {
                            recoveryResult.fail(t);
                        }
                    } else {
                        recoveryResult.fail(that.getError());
                    }
                } else {
                    recoveryResult.done(that.get());
                }
                return recoveryResult;
            });
            recovery.getShallowTraceBuilder().setSystemHidden(true);
            recovery.getShallowTraceBuilder().setTaskType(TaskType.RECOVER.getName());
            Promises.propagateResult(recovery, result);
            context.after(that).run(recovery);
            context.run(that);
            return result;
        });
        recoverWithTask.getShallowTraceBuilder().setTaskType(TaskType.WITH_RECOVER.getName());
        return recoverWithTask;
    }

    default public Task<T> recoverWith(Function1<Throwable, Task<T>> func) {
        return this.recoverWith("recoverWith: " + _taskDescriptor.getDescription(func.getClass().getName()), func);
    }

    default public Task<T> withTimeout(long time, TimeUnit unit) {
        return this.withTimeout(null, time, unit);
    }

    default public Task<T> withTimeout(String desc, long time, TimeUnit unit) {
        Task that = this;
        String taskName = "withTimeout " + time + TimeUnitHelper.toString(unit) + (desc != null ? " " + desc : "");
        String timeoutExceptionMessage = "task: '" + this.getName() + "' " + taskName;
        Task<T> withTimeout = Task.async(taskName, (Context ctx) -> {
            AtomicBoolean committed = new AtomicBoolean();
            SettablePromise result = Promises.settable();
            Task<Void> timeoutTask = Task.action("timeout", () -> {
                if (committed.compareAndSet(false, true)) {
                    result.fail(Exceptions.timeoutException(timeoutExceptionMessage));
                }
            });
            timeoutTask.setPriority(0x7FFFFFFE);
            timeoutTask.getShallowTraceBuilder().setTaskType(TaskType.TIMEOUT.getName());
            ctx.createTimer(time, unit, timeoutTask);
            that.addListener(p -> {
                if (committed.compareAndSet(false, true)) {
                    Promises.propagateResult(that, result);
                }
            });
            that.setPriority(0x7FFFFFFE);
            ctx.run(that);
            return result;
        });
        withTimeout.setPriority(this.getPriority());
        withTimeout.getShallowTraceBuilder().setTaskType(TaskType.WITH_TIMEOUT.getName());
        return withTimeout;
    }

    default public Task<T> withDelay(long time, TimeUnit unit) {
        return this.withDelay(null, time, unit);
    }

    default public Task<T> withDelay(String desc, long time, TimeUnit unit) {
        Task that = this;
        String taskName = "withDelay " + time + TimeUnitHelper.toString(unit) + (desc != null ? " " + desc : "");
        Task<T> withDelay = Task.async(taskName, (Context context) -> {
            SettablePromise result = Promises.settable();
            that.addListener(p -> Promises.propagateResult(that, result));
            context.createTimer(time, unit, that);
            return result;
        });
        withDelay.setPriority(this.getPriority());
        withDelay.getShallowTraceBuilder().setTaskType(TaskType.WITH_DELAY.getName());
        return withDelay;
    }

    public static <R> Task<R> flatten(String desc, Task<Task<R>> task) {
        ArgumentUtil.requireNotNull(task, "task");
        Task flattenTask = Task.async(desc, (Context context) -> {
            SettablePromise result = Promises.settable();
            context.after(task).run(() -> {
                try {
                    if (!task.isFailed()) {
                        Task t = (Task)task.get();
                        if (t == null) {
                            throw new RuntimeException(desc + " returned null");
                        }
                        Promises.propagateResult(t, result);
                        return t;
                    }
                    result.fail(task.getError());
                }
                catch (Throwable t) {
                    result.fail(t);
                }
                return null;
            });
            context.run(task);
            return result;
        });
        flattenTask.getShallowTraceBuilder().setTaskType(TaskType.FLATTEN.getName());
        return flattenTask;
    }

    public static <R> Task<R> flatten(Task<Task<R>> task) {
        return Task.flatten("flatten", task);
    }

    public static Task<Void> action(String desc, Action action) {
        ArgumentUtil.requireNotNull(action, "action");
        return Task.async(desc, () -> {
            action.run();
            return Promises.VOID;
        });
    }

    public static Task<Void> action(Action action) {
        return Task.action("action: " + _taskDescriptor.getDescription(action.getClass().getName()), action);
    }

    public static <T> Task<T> value(String desc, T value) {
        return FusionTask.create(desc, (src, dst) -> dst.done(value));
    }

    public static <T> Task<T> value(T value) {
        return Task.value("value", value);
    }

    public static <T> Task<T> failure(String desc, Throwable failure) {
        ArgumentUtil.requireNotNull(failure, "failure");
        return FusionTask.create(desc, (src, dst) -> dst.fail(failure));
    }

    public static <T> Task<T> failure(Throwable failure) {
        return Task.failure("failure", failure);
    }

    public static <T> Task<T> callable(String name, Callable<? extends T> callable) {
        ArgumentUtil.requireNotNull(callable, "callable");
        return FusionTask.create(name, (src, dst) -> {
            try {
                dst.done(callable.call());
            }
            catch (Throwable t) {
                dst.fail(t);
            }
        });
    }

    public static <T> Task<T> callable(Callable<? extends T> callable) {
        return Task.callable("callable: " + _taskDescriptor.getDescription(callable.getClass().getName()), callable);
    }

    public static <T> Task<T> fromCompletionStage(String desc, Callable<CompletionStage<? extends T>> callable) {
        return Task.async(desc, () -> {
            SettablePromise promise = Promises.settable();
            CompletionStage future = (CompletionStage)callable.call();
            future.whenComplete((value, exception) -> {
                if (exception != null) {
                    promise.fail((Throwable)exception);
                } else {
                    promise.done(value);
                }
            });
            return promise;
        });
    }

    public static <T> Task<T> fromCompletionStage(Callable<CompletionStage<? extends T>> callable) {
        return Task.fromCompletionStage("fromCompletionStage: " + _taskDescriptor.getDescription(callable.getClass().getName()), callable);
    }

    public static <T> Task<T> async(String name, Callable<Promise<? extends T>> callable) {
        ArgumentUtil.requireNotNull(callable, "callable");
        return Task.async(name, (Context context) -> {
            try {
                return (Promise)callable.call();
            }
            catch (Throwable e) {
                return Promises.error(e);
            }
        });
    }

    public static <T> Task<T> async(Callable<Promise<? extends T>> callable) {
        return Task.async("async: " + _taskDescriptor.getDescription(callable.getClass().getName()), callable);
    }

    public static <T> Task<T> async(String name, final Function1<Context, Promise<? extends T>> func) {
        ArgumentUtil.requireNotNull(func, "function");
        BaseTask task = new BaseTask<T>(name){

            @Override
            protected Promise<? extends T> run(Context context) throws Throwable {
                return (Promise)func.apply(context);
            }
        };
        return task;
    }

    public static <T> Task<T> async(Function1<Context, Promise<? extends T>> func) {
        return Task.async("async: " + _taskDescriptor.getDescription(func.getClass().getName()), func);
    }

    public static <T> Task<T> blocking(String name, Callable<? extends T> callable, Executor executor) {
        ArgumentUtil.requireNotNull(callable, "callable");
        ArgumentUtil.requireNotNull(callable, "executor");
        Task<T> blockingTask = Task.async(name, () -> {
            SettablePromise promise = Promises.settable();
            executor.execute(() -> {
                try {
                    promise.done(callable.call());
                }
                catch (Throwable t) {
                    promise.fail(t);
                }
            });
            return promise;
        });
        blockingTask.getShallowTraceBuilder().setTaskType(TaskType.BLOCKING.getName());
        return blockingTask;
    }

    public static <T> Task<T> blocking(Callable<? extends T> callable, Executor executor) {
        return Task.blocking("blocking: " + _taskDescriptor.getDescription(callable.getClass().getName()), callable, executor);
    }

    public static <T1, T2> Tuple2Task<T1, T2> par(Task<T1> task1, Task<T2> task2) {
        ArgumentUtil.requireNotNull(task1, "task1");
        ArgumentUtil.requireNotNull(task2, "task2");
        return new Par2Task<T1, T2>("par2", task1, task2);
    }

    public static <T1, T2, T3> Tuple3Task<T1, T2, T3> par(Task<T1> task1, Task<T2> task2, Task<T3> task3) {
        ArgumentUtil.requireNotNull(task1, "task1");
        ArgumentUtil.requireNotNull(task2, "task2");
        ArgumentUtil.requireNotNull(task3, "task3");
        return new Par3Task<T1, T2, T3>("par3", task1, task2, task3);
    }

    public static <T1, T2, T3, T4> Tuple4Task<T1, T2, T3, T4> par(Task<T1> task1, Task<T2> task2, Task<T3> task3, Task<T4> task4) {
        ArgumentUtil.requireNotNull(task1, "task1");
        ArgumentUtil.requireNotNull(task2, "task2");
        ArgumentUtil.requireNotNull(task3, "task3");
        ArgumentUtil.requireNotNull(task4, "task4");
        return new Par4Task<T1, T2, T3, T4>("par4", task1, task2, task3, task4);
    }

    public static <T1, T2, T3, T4, T5> Tuple5Task<T1, T2, T3, T4, T5> par(Task<T1> task1, Task<T2> task2, Task<T3> task3, Task<T4> task4, Task<T5> task5) {
        ArgumentUtil.requireNotNull(task1, "task1");
        ArgumentUtil.requireNotNull(task2, "task2");
        ArgumentUtil.requireNotNull(task3, "task3");
        ArgumentUtil.requireNotNull(task4, "task4");
        ArgumentUtil.requireNotNull(task5, "task5");
        return new Par5Task<T1, T2, T3, T4, T5>("par5", task1, task2, task3, task4, task5);
    }

    public static <T1, T2, T3, T4, T5, T6> Tuple6Task<T1, T2, T3, T4, T5, T6> par(Task<T1> task1, Task<T2> task2, Task<T3> task3, Task<T4> task4, Task<T5> task5, Task<T6> task6) {
        ArgumentUtil.requireNotNull(task1, "task1");
        ArgumentUtil.requireNotNull(task2, "task2");
        ArgumentUtil.requireNotNull(task3, "task3");
        ArgumentUtil.requireNotNull(task4, "task4");
        ArgumentUtil.requireNotNull(task5, "task5");
        ArgumentUtil.requireNotNull(task6, "task6");
        return new Par6Task<T1, T2, T3, T4, T5, T6>("par6", task1, task2, task3, task4, task5, task6);
    }

    public static <T1, T2, T3, T4, T5, T6, T7> Tuple7Task<T1, T2, T3, T4, T5, T6, T7> par(Task<T1> task1, Task<T2> task2, Task<T3> task3, Task<T4> task4, Task<T5> task5, Task<T6> task6, Task<T7> task7) {
        ArgumentUtil.requireNotNull(task1, "task1");
        ArgumentUtil.requireNotNull(task2, "task2");
        ArgumentUtil.requireNotNull(task3, "task3");
        ArgumentUtil.requireNotNull(task4, "task4");
        ArgumentUtil.requireNotNull(task5, "task5");
        ArgumentUtil.requireNotNull(task6, "task6");
        ArgumentUtil.requireNotNull(task7, "task7");
        return new Par7Task<T1, T2, T3, T4, T5, T6, T7>("par7", task1, task2, task3, task4, task5, task6, task7);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8> Tuple8Task<T1, T2, T3, T4, T5, T6, T7, T8> par(Task<T1> task1, Task<T2> task2, Task<T3> task3, Task<T4> task4, Task<T5> task5, Task<T6> task6, Task<T7> task7, Task<T8> task8) {
        ArgumentUtil.requireNotNull(task1, "task1");
        ArgumentUtil.requireNotNull(task2, "task2");
        ArgumentUtil.requireNotNull(task3, "task3");
        ArgumentUtil.requireNotNull(task4, "task4");
        ArgumentUtil.requireNotNull(task5, "task5");
        ArgumentUtil.requireNotNull(task6, "task6");
        ArgumentUtil.requireNotNull(task7, "task7");
        ArgumentUtil.requireNotNull(task8, "task8");
        return new Par8Task<T1, T2, T3, T4, T5, T6, T7, T8>("par8", task1, task2, task3, task4, task5, task6, task7, task8);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9> Tuple9Task<T1, T2, T3, T4, T5, T6, T7, T8, T9> par(Task<T1> task1, Task<T2> task2, Task<T3> task3, Task<T4> task4, Task<T5> task5, Task<T6> task6, Task<T7> task7, Task<T8> task8, Task<T9> task9) {
        ArgumentUtil.requireNotNull(task1, "task1");
        ArgumentUtil.requireNotNull(task2, "task2");
        ArgumentUtil.requireNotNull(task3, "task3");
        ArgumentUtil.requireNotNull(task4, "task4");
        ArgumentUtil.requireNotNull(task5, "task5");
        ArgumentUtil.requireNotNull(task6, "task6");
        ArgumentUtil.requireNotNull(task7, "task7");
        ArgumentUtil.requireNotNull(task8, "task8");
        ArgumentUtil.requireNotNull(task9, "task9");
        return new Par9Task<T1, T2, T3, T4, T5, T6, T7, T8, T9>("par9", task1, task2, task3, task4, task5, task6, task7, task8, task9);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> Tuple10Task<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> par(Task<T1> task1, Task<T2> task2, Task<T3> task3, Task<T4> task4, Task<T5> task5, Task<T6> task6, Task<T7> task7, Task<T8> task8, Task<T9> task9, Task<T10> task10) {
        ArgumentUtil.requireNotNull(task1, "task1");
        ArgumentUtil.requireNotNull(task2, "task2");
        ArgumentUtil.requireNotNull(task3, "task3");
        ArgumentUtil.requireNotNull(task4, "task4");
        ArgumentUtil.requireNotNull(task5, "task5");
        ArgumentUtil.requireNotNull(task6, "task6");
        ArgumentUtil.requireNotNull(task7, "task7");
        ArgumentUtil.requireNotNull(task8, "task8");
        ArgumentUtil.requireNotNull(task9, "task9");
        ArgumentUtil.requireNotNull(task10, "task10");
        return new Par10Task<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10>("par10", task1, task2, task3, task4, task5, task6, task7, task8, task9, task10);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> Tuple11Task<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> par(Task<T1> task1, Task<T2> task2, Task<T3> task3, Task<T4> task4, Task<T5> task5, Task<T6> task6, Task<T7> task7, Task<T8> task8, Task<T9> task9, Task<T10> task10, Task<T11> task11) {
        ArgumentUtil.requireNotNull(task1, "task1");
        ArgumentUtil.requireNotNull(task2, "task2");
        ArgumentUtil.requireNotNull(task3, "task3");
        ArgumentUtil.requireNotNull(task4, "task4");
        ArgumentUtil.requireNotNull(task5, "task5");
        ArgumentUtil.requireNotNull(task6, "task6");
        ArgumentUtil.requireNotNull(task7, "task7");
        ArgumentUtil.requireNotNull(task8, "task8");
        ArgumentUtil.requireNotNull(task9, "task9");
        ArgumentUtil.requireNotNull(task10, "task10");
        ArgumentUtil.requireNotNull(task11, "task11");
        return new Par11Task<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11>("par11", task1, task2, task3, task4, task5, task6, task7, task8, task9, task10, task11);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12> Tuple12Task<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12> par(Task<T1> task1, Task<T2> task2, Task<T3> task3, Task<T4> task4, Task<T5> task5, Task<T6> task6, Task<T7> task7, Task<T8> task8, Task<T9> task9, Task<T10> task10, Task<T11> task11, Task<T12> task12) {
        ArgumentUtil.requireNotNull(task1, "task1");
        ArgumentUtil.requireNotNull(task2, "task2");
        ArgumentUtil.requireNotNull(task3, "task3");
        ArgumentUtil.requireNotNull(task4, "task4");
        ArgumentUtil.requireNotNull(task5, "task5");
        ArgumentUtil.requireNotNull(task6, "task6");
        ArgumentUtil.requireNotNull(task7, "task7");
        ArgumentUtil.requireNotNull(task8, "task8");
        ArgumentUtil.requireNotNull(task9, "task9");
        ArgumentUtil.requireNotNull(task10, "task10");
        ArgumentUtil.requireNotNull(task11, "task11");
        ArgumentUtil.requireNotNull(task12, "task12");
        return new Par12Task<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12>("par12", task1, task2, task3, task4, task5, task6, task7, task8, task9, task10, task11, task12);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13> Tuple13Task<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13> par(Task<T1> task1, Task<T2> task2, Task<T3> task3, Task<T4> task4, Task<T5> task5, Task<T6> task6, Task<T7> task7, Task<T8> task8, Task<T9> task9, Task<T10> task10, Task<T11> task11, Task<T12> task12, Task<T13> task13) {
        ArgumentUtil.requireNotNull(task1, "task1");
        ArgumentUtil.requireNotNull(task2, "task2");
        ArgumentUtil.requireNotNull(task3, "task3");
        ArgumentUtil.requireNotNull(task4, "task4");
        ArgumentUtil.requireNotNull(task5, "task5");
        ArgumentUtil.requireNotNull(task6, "task6");
        ArgumentUtil.requireNotNull(task7, "task7");
        ArgumentUtil.requireNotNull(task8, "task8");
        ArgumentUtil.requireNotNull(task9, "task9");
        ArgumentUtil.requireNotNull(task10, "task10");
        ArgumentUtil.requireNotNull(task11, "task11");
        ArgumentUtil.requireNotNull(task12, "task12");
        ArgumentUtil.requireNotNull(task13, "task13");
        return new Par13Task<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13>("par13", task1, task2, task3, task4, task5, task6, task7, task8, task9, task10, task11, task12, task13);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14> Tuple14Task<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14> par(Task<T1> task1, Task<T2> task2, Task<T3> task3, Task<T4> task4, Task<T5> task5, Task<T6> task6, Task<T7> task7, Task<T8> task8, Task<T9> task9, Task<T10> task10, Task<T11> task11, Task<T12> task12, Task<T13> task13, Task<T14> task14) {
        ArgumentUtil.requireNotNull(task1, "task1");
        ArgumentUtil.requireNotNull(task2, "task2");
        ArgumentUtil.requireNotNull(task3, "task3");
        ArgumentUtil.requireNotNull(task4, "task4");
        ArgumentUtil.requireNotNull(task5, "task5");
        ArgumentUtil.requireNotNull(task6, "task6");
        ArgumentUtil.requireNotNull(task7, "task7");
        ArgumentUtil.requireNotNull(task8, "task8");
        ArgumentUtil.requireNotNull(task9, "task9");
        ArgumentUtil.requireNotNull(task10, "task10");
        ArgumentUtil.requireNotNull(task11, "task11");
        ArgumentUtil.requireNotNull(task12, "task12");
        ArgumentUtil.requireNotNull(task13, "task13");
        ArgumentUtil.requireNotNull(task14, "task14");
        return new Par14Task<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14>("par14", task1, task2, task3, task4, task5, task6, task7, task8, task9, task10, task11, task12, task13, task14);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15> Tuple15Task<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15> par(Task<T1> task1, Task<T2> task2, Task<T3> task3, Task<T4> task4, Task<T5> task5, Task<T6> task6, Task<T7> task7, Task<T8> task8, Task<T9> task9, Task<T10> task10, Task<T11> task11, Task<T12> task12, Task<T13> task13, Task<T14> task14, Task<T15> task15) {
        ArgumentUtil.requireNotNull(task1, "task1");
        ArgumentUtil.requireNotNull(task2, "task2");
        ArgumentUtil.requireNotNull(task3, "task3");
        ArgumentUtil.requireNotNull(task4, "task4");
        ArgumentUtil.requireNotNull(task5, "task5");
        ArgumentUtil.requireNotNull(task6, "task6");
        ArgumentUtil.requireNotNull(task7, "task7");
        ArgumentUtil.requireNotNull(task8, "task8");
        ArgumentUtil.requireNotNull(task9, "task9");
        ArgumentUtil.requireNotNull(task10, "task10");
        ArgumentUtil.requireNotNull(task11, "task11");
        ArgumentUtil.requireNotNull(task12, "task12");
        ArgumentUtil.requireNotNull(task13, "task13");
        ArgumentUtil.requireNotNull(task14, "task14");
        ArgumentUtil.requireNotNull(task15, "task15");
        return new Par15Task<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15>("par15", task1, task2, task3, task4, task5, task6, task7, task8, task9, task10, task11, task12, task13, task14, task15);
    }

    public static <T> ParTask<T> par(Iterable<? extends Task<? extends T>> tasks) {
        return tasks.iterator().hasNext() ? new ParTaskImpl("par", tasks) : new ParTaskImpl("par");
    }

    public static <T> Task<T> withRetryPolicy(RetryPolicy policy, Callable<Task<T>> taskSupplier) {
        return Task.withRetryPolicy("operation", policy, taskSupplier);
    }

    public static <T> Task<T> withRetryPolicy(RetryPolicy policy, Function1<Integer, Task<T>> taskSupplier) {
        return Task.withRetryPolicy("operation", policy, taskSupplier);
    }

    public static <T> Task<T> withRetryPolicy(String name, RetryPolicy policy, Callable<Task<T>> taskSupplier) {
        return Task.withRetryPolicy(name, policy, (Integer attempt) -> (Task)taskSupplier.call());
    }

    public static <T> Task<T> withRetryPolicy(String name, RetryPolicy policy, Function1<Integer, Task<T>> taskSupplier) {
        return RetriableTask.withRetryPolicy(name, policy, taskSupplier);
    }
}

