/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.parseq;

import com.linkedin.parseq.BaseTask;
import com.linkedin.parseq.Context;
import com.linkedin.parseq.MultiException;
import com.linkedin.parseq.ParTask;
import com.linkedin.parseq.Task;
import com.linkedin.parseq.internal.InternalUtil;
import com.linkedin.parseq.promise.Promise;
import com.linkedin.parseq.promise.PromiseListener;
import com.linkedin.parseq.promise.Promises;
import com.linkedin.parseq.promise.SettablePromise;
import com.linkedin.parseq.trace.ResultType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

class ParTaskImpl<T>
extends BaseTask<List<T>>
implements ParTask<T> {
    private final Task<? extends Task<? extends T>>[] _tasks;
    private static final Task<? extends Task<?>>[] EMPTY = new Task[0];

    public ParTaskImpl(String name) {
        super(name);
        this._tasks = EMPTY;
    }

    public ParTaskImpl(String name, Iterable<? extends Task<? extends T>> tasks) {
        super(name);
        this._tasks = tasks instanceof Collection ? this.tasksFromCollection((Collection)tasks) : this.tasksFromIterable(tasks);
        if (this._tasks.length == 0) {
            throw new IllegalArgumentException("No tasks to parallelize!");
        }
    }

    private Task<? extends Task<? extends T>>[] tasksFromIterable(Iterable<? extends Task<? extends T>> tasks) {
        ArrayList<Task<? extends T>> taskList = new ArrayList<Task<? extends T>>();
        Iterator<Task<T>> iterator = tasks.iterator();
        while (iterator.hasNext()) {
            Task<? extends T> task;
            Task<? extends T> coercedTask = task = iterator.next();
            taskList.add(coercedTask);
        }
        return (Task[])taskList.toArray();
    }

    private Task<? extends Task<? extends T>>[] tasksFromCollection(Collection<? extends Task<? extends T>> tasks) {
        Task[] tasksArr = new Task[tasks.size()];
        int i = 0;
        for (Task<T> task : tasks) {
            tasksArr[i++] = task;
        }
        return tasksArr;
    }

    @Override
    protected Promise<List<T>> run(Context context) throws Exception {
        if (this._tasks.length == 0) {
            return Promises.value(Collections.emptyList());
        }
        SettablePromise<List<T>> result = Promises.settable();
        PromiseListener listener = resolvedPromise -> {
            boolean allEarlyFinish = true;
            ArrayList taskResult = new ArrayList(this._tasks.length);
            ArrayList<Throwable> errors = null;
            for (Task<Task<Task<T>>> task : this._tasks) {
                if (task.isFailed()) {
                    if (allEarlyFinish && ResultType.fromTask(task) != ResultType.EARLY_FINISH) {
                        allEarlyFinish = false;
                    }
                    if (errors == null) {
                        errors = new ArrayList<Throwable>();
                    }
                    errors.add(task.getError());
                    continue;
                }
                taskResult.add(task.get());
            }
            if (errors != null) {
                result.fail(allEarlyFinish ? (Throwable)errors.get(0) : new MultiException("Multiple errors in 'ParTask' task.", (Collection<? extends Throwable>)errors));
            } else {
                result.done(taskResult);
            }
        };
        InternalUtil.after(listener, this._tasks);
        for (Task<? extends Task<? extends T>> task : this._tasks) {
            context.run(task);
        }
        return result;
    }

    @Override
    public List<Task<T>> getTasks() {
        ArrayList<Task<T>> tasks = new ArrayList<Task<T>>(this._tasks.length);
        for (Task<? extends Task<? extends T>> task : this._tasks) {
            tasks.add(task);
        }
        return tasks;
    }

    @Override
    public List<T> getSuccessful() {
        if (!this.isFailed()) {
            return (List)this.get();
        }
        ArrayList taskResult = new ArrayList();
        for (Task<Task<Task<T>>> task : this._tasks) {
            if (task.isFailed()) continue;
            taskResult.add(task.get());
        }
        return taskResult;
    }
}

