/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.parseq;

import com.linkedin.parseq.Engine;
import com.linkedin.parseq.HttpResponse;
import com.linkedin.parseq.Task;
import com.linkedin.parseq.httpclient.HttpClient;
import com.linkedin.parseq.trace.ShallowTrace;
import com.linkedin.parseq.trace.ShallowTraceBuilder;
import com.linkedin.parseq.trace.Trace;
import com.linkedin.parseq.trace.TraceBuilder;
import com.linkedin.parseq.trace.TraceRelationship;
import com.linkedin.parseq.trace.codec.json.JsonTraceCodec;
import com.ning.http.client.Response;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.AsyncContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;

final class JhatHandler
extends AbstractHandler {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final Pattern REGEX = Pattern.compile("^.*?<table border='1'>.*?<tr><td>\\s*(.*)\\s*</td></tr>", 32);
    private static final JsonTraceCodec CODEC = new JsonTraceCodec();
    private final Engine _engine;
    private final String _script;

    JhatHandler(Engine engine) throws IOException {
        this._engine = engine;
        this._script = JhatHandler.read(this.getClass().getClassLoader().getResourceAsStream("RecoverParSeqTracesFromHeapDump.js"));
    }

    private static String read(InputStream input) throws IOException {
        try (BufferedReader buffer = new BufferedReader(new InputStreamReader(input));){
            String string = buffer.lines().collect(Collectors.joining("\n"));
            return string;
        }
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (target.startsWith("/jhat")) {
            baseRequest.setHandled(true);
            AsyncContext ctx = request.startAsync();
            Task<HttpResponse> responseTask = this.fetchJSON(request).recover("handleFailure", this::handleFailure).andThen("writeResponseAndComplete", r -> this.writeResponseAndComplete(response, (HttpResponse)r, ctx));
            this._engine.run(responseTask);
        }
    }

    private void writeResponseAndComplete(HttpServletResponse response, HttpResponse r, AsyncContext ctx) throws IOException {
        response.getWriter().write(r.getBody());
        response.setStatus(r.getStatus());
        ctx.complete();
    }

    private HttpResponse handleFailure(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        String stackTrace = sw.toString();
        return new HttpResponse(500, "Error processing request:\n" + stackTrace);
    }

    private Task<HttpResponse> fetchJSON(HttpServletRequest request) {
        String location = request.getParameter("location");
        if (location == null) {
            return Task.value(new HttpResponse(400, "Missing location query parameter"));
        }
        return Task.flatten(Task.callable(() -> this.oqlGetTask(location))).map("processOQLResponse", this::processOQLResponse);
    }

    private Task<Response> oqlGetTask(String location) {
        try {
            return HttpClient.get(location + "/oql/").setRequestTimeout(900000).addQueryParam("query", this._script).task("runOQL");
        }
        catch (Exception e) {
            throw new RuntimeException("Can't create GET request to jhat server using location: " + location, e);
        }
    }

    private HttpResponse processOQLResponse(Response response) throws IOException {
        String responseBody = response.getResponseBody();
        if (response.getStatusCode() != 200) {
            return new HttpResponse(500, "Failed to query Jhat:\n" + responseBody);
        }
        Matcher regexMatcher = REGEX.matcher(responseBody);
        if (regexMatcher.find()) {
            String cutResponse = regexMatcher.group(1);
            String fixedCutResponse = cutResponse.substring(0, cutResponse.length() - 4) + " ]";
            JsonNode resultsArr = OBJECT_MAPPER.readTree(OBJECT_MAPPER.getJsonFactory().createJsonParser(fixedCutResponse));
            StringJoiner joiner = new StringJoiner(", ", "[ ", " ]");
            for (JsonNode node : resultsArr) {
                Trace trace = CODEC.decode(node.toString());
                TraceBuilder builder = new TraceBuilder(trace.getRelationships().size() + 1, trace.getPlanClass(), trace.getPlanId());
                HashMap traceMap = new HashMap();
                trace.getTraceMap().forEach((key, value) -> {
                    ShallowTraceBuilder stb = new ShallowTraceBuilder((ShallowTrace)value);
                    traceMap.put(key, stb);
                    builder.addShallowTrace(stb);
                });
                for (TraceRelationship rel : trace.getRelationships()) {
                    builder.addRelationship(rel.getRelationhsip(), (ShallowTraceBuilder)traceMap.get(rel.getFrom()), (ShallowTraceBuilder)traceMap.get(rel.getTo()));
                }
                joiner.add(CODEC.encode(builder.build()));
            }
            return new HttpResponse(200, joiner.toString());
        }
        return new HttpResponse(500, "Failed parsing Jhat response:\n" + responseBody);
    }
}

