/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.parseq;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;

public class HashManager {
    private final Consumer<String> _evictor;
    private final Deque<String> _hashDeque = new ArrayDeque<String>();
    private final Set<String> _hashSet = new HashSet<String>();
    private final int _max;

    public HashManager(Consumer<String> evictor, int max) {
        this._evictor = evictor;
        this._max = max;
    }

    public synchronized boolean contains(String hash) {
        if (this._hashSet.contains(hash)) {
            this._hashDeque.remove(hash);
            this._hashDeque.add(hash);
            return true;
        }
        return false;
    }

    public synchronized void add(String hash) {
        if (!this.contains(hash)) {
            this._hashSet.add(hash);
            this._hashDeque.add(hash);
            if (this._hashDeque.size() > this._max) {
                this._evictor.accept(this._hashDeque.poll());
            }
        }
    }
}

