/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.parseq;

import com.linkedin.parseq.DelayedExecutor;
import com.linkedin.parseq.EngineShutdownException;
import com.linkedin.parseq.Task;
import com.linkedin.parseq.TaskQueueFactory;
import com.linkedin.parseq.internal.ArgumentUtil;
import com.linkedin.parseq.internal.ContextImpl;
import com.linkedin.parseq.internal.ExecutionMonitor;
import com.linkedin.parseq.internal.LIFOBiPriorityQueue;
import com.linkedin.parseq.internal.PlanBasedRateLimiter;
import com.linkedin.parseq.internal.PlanCompletionListener;
import com.linkedin.parseq.internal.PlanContext;
import com.linkedin.parseq.internal.PlanDeactivationListener;
import com.linkedin.parseq.internal.PlatformClock;
import com.linkedin.parseq.internal.SerialExecutor;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class Engine {
    public static final String LOGGER_BASE = Engine.class.getName();
    public static final String MAX_RELATIONSHIPS_PER_TRACE = "_MaxRelationshipsPerTrace_";
    private static final int DEFUALT_MAX_RELATIONSHIPS_PER_TRACE = 65536;
    public static final String MAX_CONCURRENT_PLANS = "_MaxConcurrentPlans_";
    private static final int DEFUALT_MAX_CONCURRENT_PLANS = Integer.MAX_VALUE;
    public static final String DRAIN_SERIAL_EXECUTOR_QUEUE = "_DrainSerialExecutorQueue_";
    private static final boolean DEFAULT_DRAIN_SERIAL_EXECUTOR_QUEUE = true;
    public static final String DEFAULT_TASK_QUEUE = "_DefaultTaskQueue_";
    private static final State INIT = new State(StateName.RUN, 0L);
    private static final State TERMINATED = new State(StateName.TERMINATED, 0L);
    private static final Logger LOG = LoggerFactory.getLogger(LOGGER_BASE);
    public static final String MAX_EXECUTION_MONITORS = "_MaxExecutionMonitors_";
    private static final int DEFAULT_MAX_EXECUTION_MONITORS = 1024;
    public static final String MONITOR_EXECUTION = "_MonitorExecution_";
    private static final boolean DEFAULT_MONITOR_EXECUTION = false;
    public static final String EXECUTION_MONITOR_DURATION_THRESHOLD_NANO = "_ExecutionMonitorDurationThresholdNano_";
    private static final long DEFAULT_EXECUTION_MONITOR_DURATION_THRESHOLD_NANO = TimeUnit.SECONDS.toNanos(1L);
    public static final String EXECUTION_MONITOR_CHECK_INTERVAL_NANO = "_ExecutionMonitorCheckIntervaldNano_";
    private static final long DEFAULT_EXECUTION_MONITOR_CHECK_INTERVAL_NANO = TimeUnit.MILLISECONDS.toNanos(10L);
    public static final String EXECUTION_MONITOR_IDLE_DURATION_NANO = "_ExecutionMonitorIdleDurationNano_";
    private static final long DEFAULT_EXECUTION_MONITOR_IDLE_DURATION_NANO = TimeUnit.MINUTES.toNanos(1L);
    public static final String EXECUTION_MONITOR_LOGGING_INTERVAL_NANO = "_ExecutionMonitorLoggingIntervalNano_";
    private static final long DEFAULT_EXECUTION_MONITOR_LOGGING_INTERVAL_NANO = TimeUnit.MINUTES.toNanos(1L);
    public static final String EXECUTION_MONITOR_MIN_STALL_NANO = "_ExecutionMonitorMinStallNano_";
    private static final long DEFAULT_EXECUTION_MONITOR_MIN_STALL_NANO = TimeUnit.MILLISECONDS.toNanos(10L);
    public static final String EXECUTION_MONITOR_STALLS_HISTORY_SIZE = "_ExecutionMonitorStallsHistorySize_";
    private static final int DEFAULT_EXECUTION_MONITOR_STALLS_HISTORY_SIZE = 1024;
    public static final String EXECUTION_MONITOR_LOG_LEVEL = "_ExecutionMonitorLogLevel_";
    private static final Level DEFAULT_EXECUTION_MONITOR_LOG_LEVEL = Level.WARN;
    private final Executor _taskExecutor;
    private final DelayedExecutor _timerExecutor;
    private final ILoggerFactory _loggerFactory;
    private final TaskQueueFactory _taskQueueFactory;
    private final AtomicReference<State> _stateRef = new AtomicReference<State>(INIT);
    private final CountDownLatch _terminated = new CountDownLatch(1);
    private final Map<String, Object> _properties;
    private final int _maxRelationshipsPerTrace;
    private final int _maxConcurrentPlans;
    private final Semaphore _concurrentPlans;
    private final PlanBasedRateLimiter _planBasedRateLimiter;
    private final boolean _drainSerialExecutorQueue;
    private final ExecutionMonitor _executionMonitor;
    private final PlanDeactivationListener _planDeactivationListener;
    private final PlanCompletionListener _planCompletionListener;
    private final PlanCompletionListener _taskDoneListener;
    private final Logger _allLogger;
    private final Logger _rootLogger;

    Engine(Executor taskExecutor, DelayedExecutor timerExecutor, ILoggerFactory loggerFactory, Map<String, Object> properties, PlanDeactivationListener planActivityListener, PlanCompletionListener planCompletionListener, TaskQueueFactory taskQueueFactory, PlanBasedRateLimiter planClassRateLimiter) {
        this._taskExecutor = taskExecutor;
        this._timerExecutor = timerExecutor;
        this._loggerFactory = loggerFactory;
        this._properties = properties;
        this._planDeactivationListener = planActivityListener;
        this._planBasedRateLimiter = planClassRateLimiter;
        this._taskQueueFactory = this.createTaskQueueFactory(properties, taskQueueFactory);
        this._allLogger = loggerFactory.getLogger(LOGGER_BASE + ":all");
        this._rootLogger = loggerFactory.getLogger(LOGGER_BASE + ":root");
        this._maxRelationshipsPerTrace = this._properties.containsKey(MAX_RELATIONSHIPS_PER_TRACE) ? (Integer)this.getProperty(MAX_RELATIONSHIPS_PER_TRACE) : 65536;
        this._maxConcurrentPlans = this._properties.containsKey(MAX_CONCURRENT_PLANS) ? (Integer)this.getProperty(MAX_CONCURRENT_PLANS) : Integer.MAX_VALUE;
        this._concurrentPlans = new Semaphore(this._maxConcurrentPlans);
        this._drainSerialExecutorQueue = this._properties.containsKey(DRAIN_SERIAL_EXECUTOR_QUEUE) ? (Boolean)this.getProperty(DRAIN_SERIAL_EXECUTOR_QUEUE) : true;
        this._taskDoneListener = resolvedPromise -> {
            State newState;
            State currState;
            assert (this._stateRef.get()._pendingCount > 0L);
            assert (this._stateRef.get()._stateName != StateName.TERMINATED);
            while (!this._stateRef.compareAndSet(currState = this._stateRef.get(), newState = new State(currState._stateName, currState._pendingCount - 1L))) {
            }
            this._concurrentPlans.release();
            if (planClassRateLimiter != null) {
                this._planBasedRateLimiter.release(resolvedPromise.getPlanClass());
            }
            if (newState._stateName == StateName.SHUTDOWN && newState._pendingCount == 0L) {
                this.tryTransitionTerminate();
            }
        };
        this._planCompletionListener = planContext -> {
            try {
                planCompletionListener.onPlanCompleted(planContext);
            }
            catch (Throwable t) {
                LOG.error("Uncaught throwable from custom PlanCompletionListener.", t);
            }
            finally {
                this._taskDoneListener.onPlanCompleted(planContext);
            }
        };
        int maxMonitors = 1024;
        if (this._properties.containsKey(MAX_EXECUTION_MONITORS)) {
            maxMonitors = (Integer)this.getProperty(MAX_EXECUTION_MONITORS);
        }
        long durationThresholdNano = DEFAULT_EXECUTION_MONITOR_DURATION_THRESHOLD_NANO;
        if (this._properties.containsKey(EXECUTION_MONITOR_DURATION_THRESHOLD_NANO)) {
            durationThresholdNano = (Long)this.getProperty(EXECUTION_MONITOR_DURATION_THRESHOLD_NANO);
        }
        long checkIntervalNano = DEFAULT_EXECUTION_MONITOR_CHECK_INTERVAL_NANO;
        if (this._properties.containsKey(EXECUTION_MONITOR_CHECK_INTERVAL_NANO)) {
            checkIntervalNano = (Long)this.getProperty(EXECUTION_MONITOR_CHECK_INTERVAL_NANO);
        }
        long idleDurationNano = DEFAULT_EXECUTION_MONITOR_IDLE_DURATION_NANO;
        if (this._properties.containsKey(EXECUTION_MONITOR_IDLE_DURATION_NANO)) {
            idleDurationNano = (Long)this.getProperty(EXECUTION_MONITOR_IDLE_DURATION_NANO);
        }
        long loggingIntervalNano = DEFAULT_EXECUTION_MONITOR_LOGGING_INTERVAL_NANO;
        if (this._properties.containsKey(EXECUTION_MONITOR_LOGGING_INTERVAL_NANO)) {
            loggingIntervalNano = (Long)this.getProperty(EXECUTION_MONITOR_LOGGING_INTERVAL_NANO);
        }
        long minStallNano = DEFAULT_EXECUTION_MONITOR_MIN_STALL_NANO;
        if (this._properties.containsKey(EXECUTION_MONITOR_MIN_STALL_NANO)) {
            minStallNano = (Long)this.getProperty(EXECUTION_MONITOR_MIN_STALL_NANO);
        }
        int stallsHistorySize = 1024;
        if (this._properties.containsKey(EXECUTION_MONITOR_STALLS_HISTORY_SIZE)) {
            stallsHistorySize = (Integer)this.getProperty(EXECUTION_MONITOR_STALLS_HISTORY_SIZE);
        }
        Level level = DEFAULT_EXECUTION_MONITOR_LOG_LEVEL;
        if (this._properties.containsKey(EXECUTION_MONITOR_LOG_LEVEL)) {
            level = (Level)((Object)this.getProperty(EXECUTION_MONITOR_LOG_LEVEL));
        }
        boolean monitorExecution = false;
        if (this._properties.containsKey(MONITOR_EXECUTION)) {
            monitorExecution = (Boolean)this.getProperty(MONITOR_EXECUTION);
        }
        this._executionMonitor = monitorExecution ? new ExecutionMonitor(maxMonitors, durationThresholdNano, checkIntervalNano, idleDurationNano, loggingIntervalNano, minStallNano, stallsHistorySize, level, new PlatformClock()) : null;
    }

    private TaskQueueFactory createTaskQueueFactory(Map<String, Object> properties, TaskQueueFactory taskQueueFactory) {
        if (taskQueueFactory == null) {
            if (this._properties.containsKey(DEFAULT_TASK_QUEUE)) {
                String className = (String)properties.get(DEFAULT_TASK_QUEUE);
                try {
                    Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
                    return () -> {
                        try {
                            return (SerialExecutor.TaskQueue)clazz.newInstance();
                        }
                        catch (IllegalAccessException | InstantiationException e) {
                            return new LIFOBiPriorityQueue();
                        }
                    };
                }
                catch (ClassNotFoundException e) {
                    LOG.error("Failed to load TasQueue implementation: " + className + ", will use default implementation", e);
                }
            }
            return LIFOBiPriorityQueue::new;
        }
        return taskQueueFactory;
    }

    public Object getProperty(String key) {
        return this._properties.get(key);
    }

    private final String defaultPlanClass(Task<?> task) {
        return task.getClass().getName();
    }

    public void run(Task<?> task) {
        this.run(task, this.defaultPlanClass(task));
    }

    public void run(Task<?> task, String planClass) {
        if (!this.tryRun(task, planClass)) {
            throw new IllegalStateException("Starting new plan rejected, exceeded limit of concurrent plans: " + this._maxConcurrentPlans);
        }
    }

    public void blockingRun(Task<?> task) {
        this.blockingRun(task, this.defaultPlanClass(task));
    }

    public void blockingRun(Task<?> task, String planClass) {
        try {
            this.acquirePermit(planClass);
            this.runWithPermit(task, planClass);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public boolean tryRun(Task<?> task) {
        return this.tryRun(task, this.defaultPlanClass(task));
    }

    public boolean tryRun(Task<?> task, String planClass) {
        if (this.tryAcquirePermit(planClass)) {
            this.runWithPermit(task, planClass);
            return true;
        }
        return false;
    }

    public boolean tryRun(Task<?> task, long timeout, TimeUnit unit) throws InterruptedException {
        return this.tryRun(task, this.defaultPlanClass(task), timeout, unit);
    }

    public boolean tryRun(Task<?> task, String planClass, long timeout, TimeUnit unit) throws InterruptedException {
        if (this.tryAcquirePermit(planClass, timeout, unit)) {
            this.runWithPermit(task, planClass);
            return true;
        }
        return false;
    }

    private void runWithPermit(Task<?> task, String planClass) {
        State newState;
        State currState;
        ArgumentUtil.requireNotNull(task, "task");
        ArgumentUtil.requireNotNull(planClass, "planClass");
        do {
            if ((currState = this._stateRef.get())._stateName == StateName.RUN) continue;
            task.cancel(new EngineShutdownException("Task submitted after engine shutdown"));
            return;
        } while (!this._stateRef.compareAndSet(currState, newState = new State(StateName.RUN, currState._pendingCount + 1L)));
        PlanContext planContext = new PlanContext(this, this._taskExecutor, this._timerExecutor, this._loggerFactory, this._allLogger, this._rootLogger, planClass, task, this._maxRelationshipsPerTrace, this._planDeactivationListener, this._planCompletionListener, this._taskQueueFactory.newTaskQueue(), this._drainSerialExecutorQueue, this._executionMonitor);
        new ContextImpl(planContext, task).runTask();
    }

    private boolean tryAcquirePermit(String planClass) {
        return this._concurrentPlans.tryAcquire() && (this._planBasedRateLimiter == null || this._planBasedRateLimiter.tryAcquire(planClass));
    }

    private boolean tryAcquirePermit(String planClass, long timeout, TimeUnit unit) throws InterruptedException {
        return this._concurrentPlans.tryAcquire(timeout, unit) && (this._planBasedRateLimiter == null || this._planBasedRateLimiter.tryAcquire(planClass, timeout, unit));
    }

    private void acquirePermit(String planClass) throws InterruptedException {
        this._concurrentPlans.acquire();
        if (this._planBasedRateLimiter != null) {
            this._planBasedRateLimiter.acquire(planClass);
        }
    }

    public void shutdown() {
        if (this.tryTransitionShutdown()) {
            this.tryTransitionTerminate();
        }
    }

    public boolean isShutdown() {
        return this._stateRef.get()._stateName != StateName.RUN;
    }

    public boolean isTerminated() {
        return this._stateRef.get()._stateName == StateName.TERMINATED;
    }

    public boolean awaitTermination(int time, TimeUnit unit) throws InterruptedException {
        return this._terminated.await(time, unit);
    }

    private boolean tryTransitionShutdown() {
        State newState;
        State currState;
        do {
            if ((currState = this._stateRef.get())._stateName == StateName.RUN) continue;
            return false;
        } while (!this._stateRef.compareAndSet(currState, newState = new State(StateName.SHUTDOWN, currState._pendingCount)));
        return true;
    }

    private void tryTransitionTerminate() {
        State currState;
        do {
            if ((currState = this._stateRef.get())._stateName == StateName.SHUTDOWN && currState._pendingCount == 0L) continue;
            return;
        } while (!this._stateRef.compareAndSet(currState, TERMINATED));
        this._terminated.countDown();
    }

    private static class State {
        private final StateName _stateName;
        private final long _pendingCount;

        private State(StateName stateName, long pendingCount) {
            this._pendingCount = pendingCount;
            this._stateName = stateName;
        }
    }

    private static enum StateName {
        RUN,
        SHUTDOWN,
        TERMINATED;

    }
}

