/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.parseq;

import com.linkedin.parseq.Engine;
import com.linkedin.parseq.GraphvizEngine;
import com.linkedin.parseq.HttpResponse;
import com.linkedin.parseq.Task;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.AsyncContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;

final class DotHandler
extends AbstractHandler {
    private final GraphvizEngine _graphvizEngine;
    private final Engine _engine;

    DotHandler(GraphvizEngine graphvizEngine, Engine engine) {
        this._graphvizEngine = graphvizEngine;
        this._engine = engine;
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (target.startsWith("/dot")) {
            baseRequest.setHandled(true);
            AsyncContext ctx = request.startAsync();
            Task<HttpResponse> responseTask = this._graphvizEngine.build(request.getParameter("hash"), request.getInputStream()).andThen("response", graphvizResponse -> {
                response.setStatus(graphvizResponse.getStatus());
                PrintWriter writer = response.getWriter();
                writer.write(graphvizResponse.getBody());
                ctx.complete();
            });
            this._engine.run(responseTask);
        }
    }
}

