/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.parseq;

import com.linkedin.parseq.After;
import com.linkedin.parseq.Cancellable;
import com.linkedin.parseq.CancellationException;
import com.linkedin.parseq.Context;
import com.linkedin.parseq.Exceptions;
import com.linkedin.parseq.ParSeqGlobalConfiguration;
import com.linkedin.parseq.Task;
import com.linkedin.parseq.internal.IdGenerator;
import com.linkedin.parseq.internal.TaskLogger;
import com.linkedin.parseq.promise.DelegatingPromise;
import com.linkedin.parseq.promise.Promise;
import com.linkedin.parseq.promise.Promises;
import com.linkedin.parseq.promise.SettablePromise;
import com.linkedin.parseq.trace.Relationship;
import com.linkedin.parseq.trace.ResultType;
import com.linkedin.parseq.trace.ShallowTrace;
import com.linkedin.parseq.trace.ShallowTraceBuilder;
import com.linkedin.parseq.trace.Trace;
import com.linkedin.parseq.trace.TraceBuilder;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTask<T>
extends DelegatingPromise<T>
implements Task<T> {
    private static final int TASK_NAME_MAX_LENGTH = 1024;
    static final Logger LOGGER = LoggerFactory.getLogger(BaseTask.class);
    private static final String CANONICAL_NAME = BaseTask.class.getCanonicalName();
    private final Long _id = IdGenerator.getNextId();
    private final AtomicReference<State> _stateRef;
    private final String _name;
    protected final ShallowTraceBuilder _shallowTraceBuilder;
    protected volatile Function<T, String> _traceValueProvider;
    private volatile TraceBuilder _traceBuilder;
    private final Throwable _taskStackTraceHolder;

    public BaseTask() {
        this((String)null);
    }

    public BaseTask(String name) {
        this(name, null);
    }

    public BaseTask(String name, String taskType) {
        super(Promises.settable());
        this._name = this.truncate(name);
        State state = State.INIT;
        this._shallowTraceBuilder = new ShallowTraceBuilder(this._id);
        this._shallowTraceBuilder.setName(this.getName());
        this._shallowTraceBuilder.setResultType(ResultType.UNFINISHED);
        if (taskType != null) {
            this._shallowTraceBuilder.setTaskType(taskType);
        }
        this._stateRef = new AtomicReference<State>(state);
        this._taskStackTraceHolder = ParSeqGlobalConfiguration.isCrossThreadStackTracesEnabled() ? new Throwable() : null;
    }

    private String truncate(String name) {
        if (name == null || name.length() <= 1024) {
            return name;
        }
        return name.substring(0, 1024);
    }

    @Override
    public Long getId() {
        return this._id;
    }

    @Override
    public int getPriority() {
        return this._stateRef.get().getPriority();
    }

    @Override
    public boolean setPriority(int priority) {
        State newState;
        State state;
        if (priority < -2147483647 || priority > 0x7FFFFFFE) {
            throw new IllegalArgumentException("Priority out of bounds: " + priority);
        }
        do {
            if ((state = this._stateRef.get()).getType() == StateType.INIT) continue;
            return false;
        } while (!this._stateRef.compareAndSet(state, newState = new State(state.getType(), priority)));
        return true;
    }

    @Override
    public TraceBuilder getTraceBuilder() {
        return this._traceBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void contextRun(Context context, Task<?> parent, Collection<Task<?>> predecessors) {
        TaskLogger taskLogger = context.getTaskLogger();
        TraceBuilder traceBuilder = context.getTraceBuilder();
        if (this.transitionRun(traceBuilder)) {
            this.markTaskStarted();
            try {
                Promise<T> promise;
                if (parent != null) {
                    traceBuilder.addRelationship(Relationship.CHILD_OF, this.getShallowTraceBuilder(), parent.getShallowTraceBuilder());
                }
                for (Task<?> predecessor : predecessors) {
                    traceBuilder.addRelationship(Relationship.SUCCESSOR_OF, this.getShallowTraceBuilder(), predecessor.getShallowTraceBuilder());
                }
                taskLogger.logTaskStart(this);
                try {
                    WrappedContext wrapperContext = new WrappedContext(context);
                    promise = this.doContextRun(wrapperContext);
                }
                finally {
                    this.transitionPending();
                }
                promise.addListener((Promise<P> resolvedPromise) -> {
                    if (resolvedPromise.isFailed()) {
                        this.fail(resolvedPromise.getError(), taskLogger);
                    } else {
                        this.done(resolvedPromise.get(), taskLogger);
                    }
                });
            }
            catch (Throwable t) {
                this.fail(t, taskLogger);
            }
        } else {
            if (parent != null) {
                traceBuilder.addRelationship(Relationship.POTENTIAL_CHILD_OF, this.getShallowTraceBuilder(), parent.getShallowTraceBuilder());
            }
            for (Task<?> predecessor : predecessors) {
                traceBuilder.addRelationship(Relationship.POSSIBLE_SUCCESSOR_OF, this.getShallowTraceBuilder(), predecessor.getShallowTraceBuilder());
            }
        }
    }

    private Promise<T> doContextRun(Context context) throws Throwable {
        return this.run(context);
    }

    @Override
    public String getName() {
        return this._name == null ? this.toString() : this._name;
    }

    @Override
    public boolean cancel(Exception rootReason) {
        if (this.transitionCancel(rootReason)) {
            CancellationException reason = new CancellationException(rootReason);
            this.traceFailure(reason);
            this.getSettableDelegate().fail(reason);
            return true;
        }
        return false;
    }

    protected void traceFailure(Throwable reason) {
        if (Exceptions.isEarlyFinish(reason)) {
            this._shallowTraceBuilder.setResultType(ResultType.EARLY_FINISH);
        } else {
            this._shallowTraceBuilder.setResultType(ResultType.ERROR);
            this._shallowTraceBuilder.setValue(Exceptions.failureToString(reason));
        }
    }

    @Override
    public ShallowTraceBuilder getShallowTraceBuilder() {
        return this._shallowTraceBuilder;
    }

    @Override
    public ShallowTrace getShallowTrace() {
        return this._shallowTraceBuilder.build();
    }

    @Override
    public void setTraceValueSerializer(Function<T, String> traceValueProvider) {
        this._traceValueProvider = traceValueProvider;
    }

    @Override
    public Trace getTrace() {
        TraceBuilder traceBuilder = this.getTraceBuilder();
        if (traceBuilder != null) {
            return traceBuilder.build();
        }
        return Trace.single(this.getShallowTrace(), "none", 0L);
    }

    protected abstract Promise<? extends T> run(Context var1) throws Throwable;

    private void traceDone(T value) {
        this._shallowTraceBuilder.setResultType(ResultType.SUCCESS);
        Function<T, String> traceValueProvider = this._traceValueProvider;
        if (traceValueProvider != null) {
            try {
                this._shallowTraceBuilder.setValue(traceValueProvider.apply(value));
            }
            catch (Exception e) {
                this._shallowTraceBuilder.setValue(Exceptions.failureToString(e));
            }
        }
    }

    private void done(T value, TaskLogger taskLogger) {
        if (this.transitionDone()) {
            this.traceDone(value);
            this.getSettableDelegate().done(value);
            taskLogger.logTaskEnd(this, this._traceValueProvider);
        }
    }

    private void fail(Throwable error, TaskLogger taskLogger) {
        if (this.transitionDone()) {
            this.appendTaskStackTrace(error);
            this.traceFailure(error);
            this.getSettableDelegate().fail(error);
            taskLogger.logTaskEnd(this, this._traceValueProvider);
        }
    }

    private void appendTaskStackTrace(Throwable error) {
        int combinedLength;
        int skipTaskFrames;
        int index;
        int skipErrorFrames;
        StackTraceElement[] taskStackTrace;
        StackTraceElement[] stackTraceElementArray = taskStackTrace = this._taskStackTraceHolder != null ? this._taskStackTraceHolder.getStackTrace() : null;
        if (!ParSeqGlobalConfiguration.isCrossThreadStackTracesEnabled() || error == null || taskStackTrace == null || taskStackTrace.length <= 2) {
            return;
        }
        StackTraceElement[] errorStackTrace = error.getStackTrace();
        if (errorStackTrace.length <= 2) {
            return;
        }
        for (skipErrorFrames = 1; skipErrorFrames < errorStackTrace.length && (errorStackTrace[index = errorStackTrace.length - 1 - skipErrorFrames].getClassName().equals(CANONICAL_NAME) || !errorStackTrace[index + 1].getClassName().equals(CANONICAL_NAME)); ++skipErrorFrames) {
        }
        if (skipErrorFrames == errorStackTrace.length) {
            skipErrorFrames = 0;
        }
        for (skipTaskFrames = 1; skipTaskFrames < taskStackTrace.length && (taskStackTrace[skipTaskFrames].getClassName().equals(CANONICAL_NAME) || !taskStackTrace[skipTaskFrames - 1].getClassName().equals(CANONICAL_NAME)); ++skipTaskFrames) {
        }
        if (skipTaskFrames == taskStackTrace.length) {
            skipTaskFrames = 0;
        }
        if ((combinedLength = errorStackTrace.length - skipErrorFrames + taskStackTrace.length - skipTaskFrames) <= 0) {
            return;
        }
        StackTraceElement[] concatenatedStackTrace = new StackTraceElement[combinedLength + 1];
        System.arraycopy(errorStackTrace, 0, concatenatedStackTrace, 0, errorStackTrace.length - skipErrorFrames);
        concatenatedStackTrace[errorStackTrace.length - skipErrorFrames] = new StackTraceElement("********** Task \"" + this.getName() + "\" (above) was instantiated as following (below): **********", "", null, 0);
        System.arraycopy(taskStackTrace, skipTaskFrames, concatenatedStackTrace, errorStackTrace.length - skipErrorFrames + 1, taskStackTrace.length - skipTaskFrames);
        error.setStackTrace(concatenatedStackTrace);
    }

    protected boolean transitionRun(TraceBuilder traceBuilder) {
        State newState;
        State state;
        do {
            if ((state = this._stateRef.get()).getType() == StateType.INIT) continue;
            return false;
        } while (!this._stateRef.compareAndSet(state, newState = state.transitionRun()));
        this._traceBuilder = traceBuilder;
        traceBuilder.addShallowTrace(this._shallowTraceBuilder);
        return true;
    }

    protected void markTaskStarted() {
        this._shallowTraceBuilder.setStartNanos(System.nanoTime());
    }

    protected void transitionPending() {
        State newState;
        State state;
        do {
            if ((state = this._stateRef.get()).getType() == StateType.RUN) continue;
            return;
        } while (!this._stateRef.compareAndSet(state, newState = state.transitionPending()));
        this.markTaskPending();
    }

    protected void markTaskPending() {
        this._shallowTraceBuilder.setPendingNanos(System.nanoTime());
    }

    protected boolean transitionCancel(Exception reason) {
        State newState;
        State state;
        do {
            StateType type;
            if ((type = (state = this._stateRef.get()).getType()) != StateType.RUN && type != StateType.DONE) continue;
            return false;
        } while (!this._stateRef.compareAndSet(state, newState = state.transitionDone()));
        return true;
    }

    protected boolean transitionDone() {
        State newState;
        State state;
        do {
            if ((state = this._stateRef.get()).getType() != StateType.DONE) continue;
            return false;
        } while (!this._stateRef.compareAndSet(state, newState = state.transitionDone()));
        return true;
    }

    protected SettablePromise<T> getSettableDelegate() {
        return (SettablePromise)super.getDelegate();
    }

    public String toString() {
        return "Task [id=" + this._id + ", name=" + this._name + "]";
    }

    private class WrappedContext
    implements Context {
        private final Context _context;

        public WrappedContext(Context context) {
            this._context = context;
        }

        @Override
        public Cancellable createTimer(long time, TimeUnit unit, Task<?> task) {
            Cancellable cancellable = this._context.createTimer(time, unit, task);
            this.getTraceBuilder().addRelationship(Relationship.POTENTIAL_PARENT_OF, this.getShallowTraceBuilder(), task.getShallowTraceBuilder());
            return cancellable;
        }

        @Override
        public void run(Task<?> ... tasks) {
            this._context.run(tasks);
            for (Task<?> task : tasks) {
                this.getTraceBuilder().addRelationship(Relationship.POTENTIAL_PARENT_OF, this.getShallowTraceBuilder(), task.getShallowTraceBuilder());
            }
        }

        @Override
        public After after(Promise<?> ... promises) {
            return new WrappedAfter(this._context.after(promises));
        }

        @Override
        public Object getEngineProperty(String key) {
            return this._context.getEngineProperty(key);
        }

        @Override
        public TraceBuilder getTraceBuilder() {
            return this._context.getTraceBuilder();
        }

        @Override
        public ShallowTraceBuilder getShallowTraceBuilder() {
            return this._context.getShallowTraceBuilder();
        }

        @Override
        public Long getPlanId() {
            return this._context.getPlanId();
        }

        @Override
        public Long getTaskId() {
            return this._context.getTaskId();
        }

        @Override
        public TaskLogger getTaskLogger() {
            return this._context.getTaskLogger();
        }

        @Override
        public void runSideEffect(Task<?> ... tasks) {
            this._context.runSideEffect(tasks);
            for (Task<?> task : tasks) {
                this.getTraceBuilder().addRelationship(Relationship.POTENTIAL_PARENT_OF, this.getShallowTraceBuilder(), task.getShallowTraceBuilder());
            }
        }

        @Override
        public String getPlanClass() {
            return this._context.getPlanClass();
        }

        private class WrappedAfter
        implements After {
            private final After _after;

            public WrappedAfter(After after) {
                this._after = after;
            }

            @Override
            public void run(Task<?> task) {
                this._after.run(task);
                WrappedContext.this.getTraceBuilder().addRelationship(Relationship.POTENTIAL_PARENT_OF, WrappedContext.this.getShallowTraceBuilder(), task.getShallowTraceBuilder());
            }

            @Override
            public void run(Supplier<Task<?>> taskSupplier) {
                this._after.run(() -> {
                    Task task = (Task)taskSupplier.get();
                    if (task != null) {
                        WrappedContext.this.getTraceBuilder().addRelationship(Relationship.POTENTIAL_PARENT_OF, WrappedContext.this.getShallowTraceBuilder(), task.getShallowTraceBuilder());
                    }
                    return task;
                });
            }
        }
    }

    protected static class State {
        private final StateType _type;
        private final int _priority;
        public static final State INIT = new State(StateType.INIT, 0){

            @Override
            public final State transitionDone() {
                return DONE;
            }

            @Override
            public final State transitionRun() {
                return RUN;
            }

            @Override
            public final State transitionPending() {
                return PENDING;
            }
        };
        public static final State RUN = new State(StateType.RUN, 0){

            @Override
            public final State transitionDone() {
                return DONE;
            }

            @Override
            public final State transitionRun() {
                return RUN;
            }

            @Override
            public final State transitionPending() {
                return PENDING;
            }
        };
        public static final State PENDING = new State(StateType.PENDING, 0){

            @Override
            public final State transitionDone() {
                return DONE;
            }

            @Override
            public final State transitionRun() {
                return RUN;
            }

            @Override
            public final State transitionPending() {
                return PENDING;
            }
        };
        public static final State DONE = new State(StateType.DONE, 0){

            @Override
            public final State transitionDone() {
                return DONE;
            }

            @Override
            public final State transitionRun() {
                return RUN;
            }

            @Override
            public final State transitionPending() {
                return PENDING;
            }
        };

        private State(StateType type, int priority) {
            this._type = type;
            this._priority = priority;
        }

        public StateType getType() {
            return this._type;
        }

        public int getPriority() {
            return this._priority;
        }

        public State transitionRun() {
            return new State(StateType.RUN, this._priority);
        }

        public State transitionPending() {
            return new State(StateType.PENDING, this._priority);
        }

        public State transitionDone() {
            return new State(StateType.DONE, this._priority);
        }
    }

    private static enum StateType {
        INIT,
        RUN,
        PENDING,
        DONE;

    }
}

