package mill.api

object BuildInfo {
  private[this] val buildInfoProperties: java.util.Properties = new java.util.Properties()

  {
    val buildInfoInputStream = getClass
      .getResourceAsStream("BuildInfo.buildinfo.properties")

    if(buildInfoInputStream == null)
      throw new RuntimeException("Could not load resource BuildInfo.buildinfo.properties")
    else try {
      buildInfoProperties.load(buildInfoInputStream)
    } finally {
      buildInfoInputStream.close()
    }
  }

  /** Mill documentation url. */
  val millDocUrl = buildInfoProperties.getProperty("millDocUrl")

  /** URL to create a new issue in Mills issue tracker. */
  val millReportNewIssueUrl = buildInfoProperties.getProperty("millReportNewIssueUrl")

  /** Mill version. */
  val millVersion = buildInfoProperties.getProperty("millVersion")
}