package mill.kotlinlib

object Versions {
  private[this] val buildInfoProperties: java.util.Properties = new java.util.Properties()

  {
    val buildInfoInputStream = getClass
      .getResourceAsStream("Versions.buildinfo.properties")

    if(buildInfoInputStream == null)
      throw new RuntimeException("Could not load resource Versions.buildinfo.properties")
    else try {
      buildInfoProperties.load(buildInfoInputStream)
    } finally {
      buildInfoInputStream.close()
    }
  }

  /** Version of Detekt. */
  val detektVersion = buildInfoProperties.getProperty("detektVersion")

  /** Version of Dokka. */
  val dokkaVersion = buildInfoProperties.getProperty("dokkaVersion")

  /** Version of Kover. */
  val koverVersion = buildInfoProperties.getProperty("koverVersion")

  /** Version of Ktfmt. */
  val ktfmtVersion = buildInfoProperties.getProperty("ktfmtVersion")
}