/*
 * Decompiled with CFR 0.152.
 */
package mill.contrib.scoverage;

import java.io.Serializable;
import mill.api.AggWrapper;
import mill.api.Ctx;
import mill.api.PathRef;
import mill.api.PathRef$;
import mill.api.Result$;
import mill.contrib.scoverage.ScoverageReport$workerModule$;
import mill.contrib.scoverage.ScoverageReportWorker$;
import mill.contrib.scoverage.api.ScoverageReportWorkerApi;
import mill.define.Caller;
import mill.define.Command;
import mill.define.Ctx$;
import mill.define.Module;
import mill.define.NamedTask;
import mill.define.Overrides;
import mill.define.Target;
import mill.define.Task;
import mill.eval.Evaluator;
import mill.main.Resolve;
import mill.main.ResolveTasks$;
import mill.main.RunScript$;
import mill.moduledefs.Scaladoc;
import mill.package$;
import mill.util.EnclosingClass;
import os.Path;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function5;
import scala.MatchError;
import scala.Predef$;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.Enclosing;
import sourcecode.File;
import sourcecode.Line;
import sourcecode.Name;
import upickle.core.Types;

@Scaladoc(value="/**\n * Allows the aggregation of coverage reports across multi-module projects.\n *\n * Once tests have been run across all modules, this collects reports from\n * all modules that extend [[mill.contrib.scoverage.ScoverageModule]]. Simply\n * define a module that extends [[mill.contrib.scoverage.ScoverageReport]] and\n * call one of the available \"report all\" functions.\n *\n * For example, define the following `scoverage` module and use the relevant\n * reporting option to generate a report:\n * {{{\n * object scoverage extends ScoverageReport {\n *   override def scalaVersion     = \"<scala-version>\"\n *   override def scoverageVersion = \"<scoverage-version>\"\n * }\n * }}}\n *\n * - mill __.test                     # run tests for all modules\n * - mill scoverage.htmlReportAll     # generates report in html format for all modules\n * - mill scoverage.xmlReportAll      # generates report in xml format for all modules\n * - mill scoverage.consoleReportAll  # reports to the console for all modules\n *\n * The aggregated report will be available at either `out/scoverage/htmlReportAll/dest/`\n * for html reports or `out/scoverage/xmlReportAll/dest/` for xml reports.\n */")
@ScalaSignature(bytes="\u0006\u0005\u0005\u001dda\u0002\u000b\u0016!\u0003\r\t\u0001\b\u0005\u0006G\u0001!\t\u0001\n\u0005\u0006W\u00011\t\u0001\f\u0005\u0006\u0003\u00021\t\u0001\f\u0005\u0006\u0005\u0002!\taQ\u0004\u0006\u0011\u0002A\t!\u0013\u0004\u0006\u0017\u0002A\t\u0001\u0014\u0005\u0006%\u001a!\ta\u0015\u0005\u0006W\u0019!\t\u0005\f\u0005\u0006\u0003\u001a!\t\u0005\f\u0005\u0006?\u0002!\t\u0001\u0019\u0005\bm\u0002\t\n\u0011\"\u0001x\u0011!\t)\u0001AI\u0001\n\u00039\bbBA\u0004\u0001\u0011\u0005\u0011\u0011\u0002\u0005\t\u0003/\u0001\u0011\u0013!C\u0001o\"A\u0011\u0011\u0004\u0001\u0012\u0002\u0013\u0005q\u000fC\u0004\u0002\u001c\u0001!\t!!\b\t\u0011\u0005-\u0002!%A\u0005\u0002]D\u0001\"!\f\u0001#\u0003%\ta\u001e\u0005\b\u0003_\u0001A\u0011AA\u0019\u0005=\u00196m\u001c<fe\u0006<WMU3q_J$(B\u0001\f\u0018\u0003%\u00198m\u001c<fe\u0006<WM\u0003\u0002\u00193\u000591m\u001c8ue&\u0014'\"\u0001\u000e\u0002\t5LG\u000e\\\u0002\u0001'\t\u0001Q\u0004\u0005\u0002\u001fC5\tqD\u0003\u0002!3\u00051A-\u001a4j]\u0016L!AI\u0010\u0003\r5{G-\u001e7f\u0003\u0019!\u0013N\\5uIQ\tQ\u0005\u0005\u0002'S5\tqEC\u0001)\u0003\u0015\u00198-\u00197b\u0013\tQsE\u0001\u0003V]&$\u0018\u0001D:dC2\fg+\u001a:tS>tW#A\u0017\u0011\u000792\u0014H\u0004\u00020i9\u0011\u0001gM\u0007\u0002c)\u0011!gG\u0001\u0007yI|w\u000e\u001e \n\u0003iI!!N\r\u0002\u000fA\f7m[1hK&\u0011q\u0007\u000f\u0002\u0002)*\u0011Q'\u0007\t\u0003uyr!a\u000f\u001f\u0011\u0005A:\u0013BA\u001f(\u0003\u0019\u0001&/\u001a3fM&\u0011q\b\u0011\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005u:\u0013\u0001E:d_Z,'/Y4f-\u0016\u00148/[8o\u0003m\u00198m\u001c<fe\u0006<WMU3q_J$xk\u001c:lKJlu\u000eZ;mKV\tAI\u0004\u0002F\r6\tQ#\u0003\u0002H+\u0005)2kY8wKJ\fw-\u001a*fa>\u0014HoV8sW\u0016\u0014\u0018\u0001D<pe.,'/T8ek2,\u0007C\u0001&\u0007\u001b\u0005\u0001!\u0001D<pe.,'/T8ek2,7c\u0001\u0004N\u001fB\u0011aFT\u0005\u0003Ea\u0002\"!\u0012)\n\u0005E+\"aD*d_Z,'/Y4f\u001b>$W\u000f\\3\u0002\rqJg.\u001b;?)\u0005I\u0005\u0006\u0002\u0004V7r\u0003\"AV-\u000e\u0003]S!\u0001W\r\u0002\u00155|G-\u001e7fI\u001647/\u0003\u0002[/\nA1kY1mC\u0012|7-A\u0003wC2,X-I\u0001^\u0003uz#F\u000b\u0011XK\u0002*8/\u001a\u0011uQ&\u001c\be\u001c8ms\u0002\"x\u000eI4fi\u0002\n7mY3tg\u0002\"x\u000e\t;iK\u0002\u0012\u0018n\u001a5uA\rd\u0017m]:qCRD7\u000f\t\u00160Q\u0011)Qk\u0017/\u0002\u001b!$X\u000e\u001c*fa>\u0014H/\u00117m)\u0011\twm\\9\u0011\u0007y\u0011G-\u0003\u0002d?\t91i\\7nC:$\u0007C\u0001\u0018f\u0013\t1\u0007HA\u0004QCRD'+\u001a4\t\u000b!T\u0001\u0019A5\u0002\u0013\u00154\u0018\r\\;bi>\u0014\bC\u00016n\u001b\u0005Y'B\u00017\u001a\u0003\u0011)g/\u00197\n\u00059\\'!C#wC2,\u0018\r^8s\u0011\u001d\u0001(\u0002%AA\u0002e\nqa]8ve\u000e,7\u000fC\u0004s\u0015A\u0005\t\u0019A\u001d\u0002\u0017\u0011\fG/\u0019+be\u001e,Go\u001d\u0015\u0005\u0015U[F/I\u0001v\u0003Yz#F\u000b\u0011HK:,'/\u0019;fg\u0002\u0012X\r]8si\u0002Jg\u000e\t5u[2\u0004cm\u001c:nCR\u0004cm\u001c:!C2d\u0007%\\8ek2,7\u000f\t\u00160\u0003]AG/\u001c7SKB|'\u000f^!mY\u0012\"WMZ1vYR$#'F\u0001yU\tI\u0014pK\u0001{!\rY\u0018\u0011A\u0007\u0002y*\u0011QP`\u0001\nk:\u001c\u0007.Z2lK\u0012T!a`\u0014\u0002\u0015\u0005tgn\u001c;bi&|g.C\u0002\u0002\u0004q\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003]AG/\u001c7SKB|'\u000f^!mY\u0012\"WMZ1vYR$3'\u0001\u0007y[2\u0014V\r]8si\u0006cG\u000eF\u0004b\u0003\u0017\ti!a\u0004\t\u000b!l\u0001\u0019A5\t\u000fAl\u0001\u0013!a\u0001s!9!/\u0004I\u0001\u0002\u0004I\u0004&B\u0007V7\u0006M\u0011EAA\u000b\u0003Uz#F\u000b\u0011HK:,'/\u0019;fg\u0002\u0012X\r]8si\u0002Jg\u000e\t=nY\u00022wN]7bi\u00022wN\u001d\u0011bY2\u0004Sn\u001c3vY\u0016\u001c\bEK\u0018\u0002-alGNU3q_J$\u0018\t\u001c7%I\u00164\u0017-\u001e7uII\na\u0003_7m%\u0016\u0004xN\u001d;BY2$C-\u001a4bk2$HeM\u0001\u0011G>t7o\u001c7f%\u0016\u0004xN\u001d;BY2$r!YA\u0010\u0003C\t\u0019\u0003C\u0003i!\u0001\u0007\u0011\u000eC\u0004q!A\u0005\t\u0019A\u001d\t\u000fI\u0004\u0002\u0013!a\u0001s!*\u0001#V.\u0002(\u0005\u0012\u0011\u0011F\u0001._)R\u0003EU3q_J$8\u000f\t;pAQDW\rI2p]N|G.\u001a\u0011g_J\u0004\u0013\r\u001c7![>$W\u000f\\3tA)z\u0013AG2p]N|G.\u001a*fa>\u0014H/\u00117mI\u0011,g-Y;mi\u0012\u0012\u0014AG2p]N|G.\u001a*fa>\u0014H/\u00117mI\u0011,g-Y;mi\u0012\u001a\u0014A\u0003:fa>\u0014H\u000fV1tWRQ\u00111GA\u001d\u0003w\ti&a\u0018\u0011\ty\t)\u0004Z\u0005\u0004\u0003oy\"\u0001\u0002+bg.DQ\u0001[\nA\u0002%Dq!!\u0010\u0014\u0001\u0004\ty$\u0001\u0006sKB|'\u000f\u001e+za\u0016\u0004B!!\u0011\u0002X9!\u00111IA)\u001d\u0011\t)%!\u0014\u000f\t\u0005\u001d\u00131\n\b\u0004_\u0005%\u0013B\u0001\r\u001a\u0013\t1r#C\u0002\u0002PU\t1!\u00199j\u0013\u0011\t\u0019&!\u0016\u00021M\u001bwN^3sC\u001e,'+\u001a9peR<vN]6fe\u0006\u0003\u0018NC\u0002\u0002PUIA!!\u0017\u0002\\\tQ!+\u001a9peR$\u0016\u0010]3\u000b\t\u0005M\u0013Q\u000b\u0005\u0006aN\u0001\r!\u000f\u0005\u0006eN\u0001\r!\u000f\u0015\u0006\u0001U[\u00161M\u0011\u0003\u0003K\n\u0011RC\u0018+U)\u0001#\u0006I!mY><8\u000f\t;iK\u0002\nwm\u001a:fO\u0006$\u0018n\u001c8!_\u001a\u00043m\u001c<fe\u0006<W\r\t:fa>\u0014Ho\u001d\u0011bGJ|7o\u001d\u0011nk2$\u0018.L7pIVdW\r\t9s_*,7\r^:/\u0015\u0001R#\u0002\t\u0016!\u001f:\u001cW\r\t;fgR\u001c\b\u0005[1wK\u0002\u0012W-\u001a8!eVt\u0007%Y2s_N\u001c\b%\u00197mA5|G-\u001e7fg2\u0002C\u000f[5tA\r|G\u000e\\3diN\u0004#/\u001a9peR\u001c\bE\u001a:p[*\u0001#\u0006I1mY\u0002jw\u000eZ;mKN\u0004C\u000f[1uA\u0015DH/\u001a8eAm[V.\u001b7m]\r|g\u000e\u001e:jE:\u001a8m\u001c<fe\u0006<WML*d_Z,'/Y4f\u001b>$W\u000f\\3^;:\u00023+[7qYfT\u0001E\u000b\u0011eK\u001aLg.\u001a\u0011bA5|G-\u001e7fAQD\u0017\r\u001e\u0011fqR,g\u000eZ:!7nk\u0017\u000e\u001c7/G>tGO]5c]M\u001cwN^3sC\u001e,gfU2pm\u0016\u0014\u0018mZ3SKB|'\u000f^/^A\u0005tGM\u0003\u0011+A\r\fG\u000e\u001c\u0011p]\u0016\u0004sN\u001a\u0011uQ\u0016\u0004\u0013M^1jY\u0006\u0014G.\u001a\u0011#e\u0016\u0004xN\u001d;!C2d'\u0005\t4v]\u000e$\u0018n\u001c8t])\u0001#F\u0003\u0011+A\u0019{'\u000fI3yC6\u0004H.\u001a\u0017!I\u00164\u0017N\\3!i\",\u0007EZ8mY><\u0018N\\4!AN\u001cwN^3sC\u001e,\u0007\rI7pIVdW\rI1oI\u0002*8/\u001a\u0011uQ\u0016\u0004#/\u001a7fm\u0006tGO\u0003\u0011+AI,\u0007o\u001c:uS:<\u0007e\u001c9uS>t\u0007\u0005^8!O\u0016tWM]1uK\u0002\n\u0007E]3q_J$(H\u0003\u0011+Am\\8P\u0003\u0011+A=\u0014'.Z2uAM\u001cwN^3sC\u001e,\u0007%\u001a=uK:$7\u000fI*d_Z,'/Y4f%\u0016\u0004xN\u001d;!w*\u0001#\u0006\t\u0011!_Z,'O]5eK\u0002\"WM\u001a\u0011tG\u0006d\u0017MV3sg&|g\u000e\t\u0011!A\u0001j\u0004E\t\u001ftG\u0006d\u0017-\f<feNLwN\u001c #\u0015\u0001R\u0003\u0005\t\u0011pm\u0016\u0014(/\u001b3fA\u0011,g\rI:d_Z,'/Y4f-\u0016\u00148/[8oAu\u0002#\u0005P:d_Z,'/Y4f[Y,'o]5p]z\u0012#\u0002\t\u0016!{*\u0001#\u0006I?~{*\u0001#F\u0003\u0011+A5\u0002S.\u001b7mA}{f\u0006^3ti\u0002\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\r\u0002#/\u001e8!i\u0016\u001cHo\u001d\u0011g_J\u0004\u0013\r\u001c7![>$W\u000f\\3t\u0015\u0001R\u0003%\f\u0011nS2d\u0007e]2pm\u0016\u0014\u0018mZ3/QRlGNU3q_J$\u0018\t\u001c7!A\u0001\u0002\u0003e\t\u0011hK:,'/\u0019;fg\u0002\u0012X\r]8si\u0002Jg\u000e\t5u[2\u0004cm\u001c:nCR\u0004cm\u001c:!C2d\u0007%\\8ek2,7O\u0003\u0011+A5\u0002S.\u001b7mAM\u001cwN^3sC\u001e,g\u0006_7m%\u0016\u0004xN\u001d;BY2\u0004\u0003\u0005\t\u0011!A\r\u0002s-\u001a8fe\u0006$Xm\u001d\u0011sKB|'\u000f\u001e\u0011j]\u0002BX\u000e\u001c\u0011g_Jl\u0017\r\u001e\u0011g_J\u0004\u0013\r\u001c7![>$W\u000f\\3t\u0015\u0001R\u0003%\f\u0011nS2d\u0007e]2pm\u0016\u0014\u0018mZ3/G>t7o\u001c7f%\u0016\u0004xN\u001d;BY2\u0004\u0003e\t\u0011sKB|'\u000f^:!i>\u0004C\u000f[3!G>t7o\u001c7fA\u0019|'\u000fI1mY\u0002jw\u000eZ;mKNT\u0001E\u000b\u0006!U\u0001\"\u0006.\u001a\u0011bO\u001e\u0014XmZ1uK\u0012\u0004#/\u001a9peR\u0004s/\u001b7mA\t,\u0007%\u0019<bS2\f'\r\\3!CR\u0004S-\u001b;iKJ\u0004\u0003m\\;u_M\u001cwN^3sC\u001e,w\u0006\u001b;nYJ+\u0007o\u001c:u\u00032dw\u0006Z3ti>\u0002'\u0002\t\u0016!M>\u0014\b\u0005\u001b;nY\u0002\u0012X\r]8siN\u0004sN\u001d\u0011a_V$xf]2pm\u0016\u0014\u0018mZ30q6d'+\u001a9peR\fE\u000e\\\u0018eKN$x\u0006\u0019\u0011g_J\u0004\u00030\u001c7!e\u0016\u0004xN\u001d;t])\u0001#f\f")
public interface ScoverageReport {
    @Scaladoc(value="/** We use this only to get access to the right classpaths */")
    public ScoverageReport$workerModule$ workerModule();

    public Target<String> scalaVersion();

    public Target<String> scoverageVersion();

    public static /* synthetic */ ScoverageReportWorker$ scoverageReportWorkerModule$(ScoverageReport $this) {
        return $this.scoverageReportWorkerModule();
    }

    default public ScoverageReportWorker$ scoverageReportWorkerModule() {
        return ScoverageReportWorker$.MODULE$;
    }

    public static /* synthetic */ Command htmlReportAll$(ScoverageReport $this, Evaluator evaluator, String sources, String dataTargets) {
        return $this.htmlReportAll(evaluator, sources, dataTargets);
    }

    @Scaladoc(value="/** Generates report in html format for all modules */")
    default public Command<PathRef> htmlReportAll(Evaluator evaluator, String sources, String dataTargets) {
        return new Command((Task)package$.MODULE$.T().zipMap((Object)package$.MODULE$.T().underlying(this.reportTask(evaluator, (ScoverageReportWorkerApi.ReportType)ScoverageReportWorkerApi.ReportType$.Html$.MODULE$, sources, dataTargets)), (Function2 & Serializable)(tmp$macro$2, ctx$macro$1) -> Result$.MODULE$.create((Function0 & Serializable)() -> tmp$macro$2)), Ctx$.MODULE$.make(new Enclosing("mill.contrib.scoverage.ScoverageReport#htmlReportAll"), new Line(55), new Name("htmlReportAll"), ((Module)this).millModuleBasePath(), ((Module)this).millModuleSegments(), new Overrides(0), ((Module)this).millModuleExternal(), ((Module)this).millModuleShared(), new File("/home/runner/work/mill/mill/contrib/scoverage/src/ScoverageReport.scala"), new Caller((Object)this)), (Types.Writer)PathRef$.MODULE$.jsonFormatter(), new EnclosingClass(this.getClass()).value(), new Overrides(0).value());
    }

    public static /* synthetic */ String htmlReportAll$default$2$(ScoverageReport $this) {
        return $this.htmlReportAll$default$2();
    }

    default public String htmlReportAll$default$2() {
        return "__.allSources";
    }

    public static /* synthetic */ String htmlReportAll$default$3$(ScoverageReport $this) {
        return $this.htmlReportAll$default$3();
    }

    default public String htmlReportAll$default$3() {
        return "__.scoverage.data";
    }

    public static /* synthetic */ Command xmlReportAll$(ScoverageReport $this, Evaluator evaluator, String sources, String dataTargets) {
        return $this.xmlReportAll(evaluator, sources, dataTargets);
    }

    @Scaladoc(value="/** Generates report in xml format for all modules */")
    default public Command<PathRef> xmlReportAll(Evaluator evaluator, String sources, String dataTargets) {
        return new Command((Task)package$.MODULE$.T().zipMap((Object)package$.MODULE$.T().underlying(this.reportTask(evaluator, (ScoverageReportWorkerApi.ReportType)ScoverageReportWorkerApi.ReportType$.Xml$.MODULE$, sources, dataTargets)), (Function2 & Serializable)(tmp$macro$2, ctx$macro$1) -> Result$.MODULE$.create((Function0 & Serializable)() -> tmp$macro$2)), Ctx$.MODULE$.make(new Enclosing("mill.contrib.scoverage.ScoverageReport#xmlReportAll"), new Line(64), new Name("xmlReportAll"), ((Module)this).millModuleBasePath(), ((Module)this).millModuleSegments(), new Overrides(0), ((Module)this).millModuleExternal(), ((Module)this).millModuleShared(), new File("/home/runner/work/mill/mill/contrib/scoverage/src/ScoverageReport.scala"), new Caller((Object)this)), (Types.Writer)PathRef$.MODULE$.jsonFormatter(), new EnclosingClass(this.getClass()).value(), new Overrides(0).value());
    }

    public static /* synthetic */ String xmlReportAll$default$2$(ScoverageReport $this) {
        return $this.xmlReportAll$default$2();
    }

    default public String xmlReportAll$default$2() {
        return "__.allSources";
    }

    public static /* synthetic */ String xmlReportAll$default$3$(ScoverageReport $this) {
        return $this.xmlReportAll$default$3();
    }

    default public String xmlReportAll$default$3() {
        return "__.scoverage.data";
    }

    public static /* synthetic */ Command consoleReportAll$(ScoverageReport $this, Evaluator evaluator, String sources, String dataTargets) {
        return $this.consoleReportAll(evaluator, sources, dataTargets);
    }

    @Scaladoc(value="/** Reports to the console for all modules */")
    default public Command<PathRef> consoleReportAll(Evaluator evaluator, String sources, String dataTargets) {
        return new Command((Task)package$.MODULE$.T().zipMap((Object)package$.MODULE$.T().underlying(this.reportTask(evaluator, (ScoverageReportWorkerApi.ReportType)ScoverageReportWorkerApi.ReportType$.Console$.MODULE$, sources, dataTargets)), (Function2 & Serializable)(tmp$macro$2, ctx$macro$1) -> Result$.MODULE$.create((Function0 & Serializable)() -> tmp$macro$2)), Ctx$.MODULE$.make(new Enclosing("mill.contrib.scoverage.ScoverageReport#consoleReportAll"), new Line(73), new Name("consoleReportAll"), ((Module)this).millModuleBasePath(), ((Module)this).millModuleSegments(), new Overrides(0), ((Module)this).millModuleExternal(), ((Module)this).millModuleShared(), new File("/home/runner/work/mill/mill/contrib/scoverage/src/ScoverageReport.scala"), new Caller((Object)this)), (Types.Writer)PathRef$.MODULE$.jsonFormatter(), new EnclosingClass(this.getClass()).value(), new Overrides(0).value());
    }

    public static /* synthetic */ String consoleReportAll$default$2$(ScoverageReport $this) {
        return $this.consoleReportAll$default$2();
    }

    default public String consoleReportAll$default$2() {
        return "__.allSources";
    }

    public static /* synthetic */ String consoleReportAll$default$3$(ScoverageReport $this) {
        return $this.consoleReportAll$default$3();
    }

    default public String consoleReportAll$default$3() {
        return "__.scoverage.data";
    }

    public static /* synthetic */ Task reportTask$(ScoverageReport $this, Evaluator evaluator, ScoverageReportWorkerApi.ReportType reportType, String sources, String dataTargets) {
        return $this.reportTask(evaluator, reportType, sources, dataTargets);
    }

    default public Task<PathRef> reportTask(Evaluator evaluator, ScoverageReportWorkerApi.ReportType reportType, String sources, String dataTargets) {
        List tasks;
        List tasks2;
        Either either = RunScript$.MODULE$.resolveTasks((Resolve)ResolveTasks$.MODULE$, evaluator, (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{sources})), false, ClassTag$.MODULE$.apply(NamedTask.class));
        if (either instanceof Left) {
            Left left = (Left)either;
            String err = (String)left.value();
            throw new Exception(err);
        }
        if (!(either instanceof Right)) {
            throw new MatchError((Object)either);
        }
        Right right = (Right)either;
        List list = tasks2 = (List)right.value();
        List sourcesTasks = list;
        Either either2 = RunScript$.MODULE$.resolveTasks((Resolve)ResolveTasks$.MODULE$, evaluator, (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{dataTargets})), false, ClassTag$.MODULE$.apply(NamedTask.class));
        if (either2 instanceof Left) {
            Left left = (Left)either2;
            String err = (String)left.value();
            throw new Exception(err);
        }
        if (!(either2 instanceof Right)) {
            throw new MatchError((Object)either2);
        }
        Right right2 = (Right)either2;
        List list2 = tasks = (List)right2.value();
        List dataTasks = list2;
        return (Task)package$.MODULE$.T().zipMap((Object)package$.MODULE$.T().underlying((Task)package$.MODULE$.T().sequence((Seq)sourcesTasks)), (Object)package$.MODULE$.T().underlying((Task)package$.MODULE$.T().sequence((Seq)dataTasks)), (Object)package$.MODULE$.T().underlying(this.scoverageReportWorkerModule().scoverageReportWorker()), (Object)package$.MODULE$.T().underlying((Task)this.workerModule().toolsClasspath()), (Function5 & Serializable)(tmp$macro$2, tmp$macro$3, tmp$macro$4, tmp$macro$5, ctx$macro$1) -> {
            Seq sourcePaths = (Seq)((IterableOps)tmp$macro$2.flatten(Predef$.MODULE$.$conforms())).map((Function1 & Serializable)x$1 -> x$1.path());
            Seq dataPaths = (Seq)tmp$macro$3.map((Function1 & Serializable)x$2 -> x$2.path());
            tmp$macro$4.bridge((AggWrapper.Agg<Path>)tmp$macro$5.map((Function1 & Serializable)x$3 -> x$3.path()), (Ctx)ctx$macro$1).report(reportType, sourcePaths, dataPaths, ctx$macro$1);
            return Result$.MODULE$.create((Function0 & Serializable)() -> package$.MODULE$.PathRef().apply(package$.MODULE$.T().dest((Ctx.Dest)ctx$macro$1), package$.MODULE$.PathRef().apply$default$2()));
        });
    }

    public static void $init$(ScoverageReport $this) {
    }
}

