/*
 * Copyright © 2016-2024 Lightbend, Inc. All rights reserved.
 * No information contained herein may be reproduced or transmitted in any form
 * or by any means without the express written permission of Lightbend, Inc.
 */

package com.lightbend.tools.fortify.plugin

import dotty.tools.dotc
import dotc.plugins.{StandardPlugin, PluginPhase}
import dotc.core.Contexts.Context
import scala.annotation.nowarn

trait VersionSpecificPlugin extends StandardPlugin:
  def init(options: List[String], error: String => Unit): List[PluginPhase]
  override def initialize(options: List[String])(using ctx: Context) =
    init(options, dotc.report.error(_)): @nowarn("cat=deprecation")
