/*
 * Copyright © 2016-2024 Lightbend, Inc. All rights reserved.
 * No information contained herein may be reproduced or transmitted in any form
 * or by any means without the express written permission of Lightbend, Inc.
 */

package com.lightbend.tools.fortify.plugin

import scala.jdk.CollectionConverters.IteratorHasAsScala

import dotty.tools.dotc
import dotc.core.Symbols.Symbol
import dotc.core.Flags.*
import dotc.core.Contexts.Context

object VersionSpecificHelpers:
  extension [T](it: java.util.Iterator[T])
    def asScala: scala.Iterator[T] =
      new IteratorHasAsScala(it).asScala
  def hasJavaEnumFlag(sym: Symbol)(using Context) =
    sym.isAllOf(JavaEnum)
  def makeRegex(s: String, ss: Seq[String]) =
    new scala.util.matching.Regex(s, ss*)
