/*
 * Copyright © 2016-2024 Lightbend, Inc. All rights reserved.
 * No information contained herein may be reproduced or transmitted in any form
 * or by any means without the express written permission of Lightbend, Inc.
 */

package com.lightbend.tools.fortify.plugin

import com.fortify.frontend.nst
import nst._
import nodes._

// This is where we put pieces of Translator that are independent
// of Scala version.

trait TranslatorBase {

  def showSourceInfo: Boolean

  // abstract because Scala-version-dependent
  type SourceFile
  type Tree
  type Symbol
  def translateAll(tree: Tree): List[STClassDecl]
  def closure(source: SourceFile): STExternalDeclarations

  def apply(
      path: String,
      source: SourceFile,
      tree: Tree,
      lineMapper: Int => Int,
      out: java.io.PrintWriter): Unit = {
    this.lineMapper = lineMapper
    out.println()
    val result =
      new STCompilationUnit(new SourceInfo, "scala", new java.io.File(path))
    for (decl <- translateAll(tree))
      result.add(decl)
    result.setExternalDeclarations(closure(source))
    val writer = new STWriter
    writer.setShowSourceInfo(showSourceInfo)
    out.println(result.accept(writer))
  }

  /// helpers

  val VoidType = STType.makePrimitiveVoid(new SourceInfo)

  // must we use a `var` for this? we don't have trait parameters in Scala 2, so it's awkward
  var lineMapper: Int => Int = identity
  def mapLine(lineNumber: Int): Int =
    lineMapper(lineNumber)

  /// name manipulation

  def squiggles(s: String): String =
    unDollar(s.replaceAll("\\.", "~"))

  // avoid "Poor Style : Identifier Contains Dollar Symbol ($)"
  // @ is a totally arbitrary choice for what to use instead
  def unDollar(s: String) =
    s.replaceAll("\\$", "@")

  /// unique names for things

  private val labelNumbers = Iterator.from(0)
  def nextLabel(prefix: String): String =
    s"$prefix${labelNumbers.next()}"

}
