/*
 * Copyright © 2016-2024 Lightbend, Inc. All rights reserved.
 * No information contained herein may be reproduced or transmitted in any form
 * or by any means without the express written permission of Lightbend, Inc.
 */

package com.lightbend.tools.fortify.plugin

import com.fortify.frontend.nst

import dotty.tools.dotc

// I consider it safe to use an implicit conversion here, since
// we never use either SourcePosition or SourceInfo in any other way.

trait Positions:
  def mapLine(lineNumber: Int): Int
  given Conversion[dotc.util.SourcePosition, nst.SourceInfo] with
    def apply(p: dotc.util.SourcePosition): nst.SourceInfo =
      if p.exists
      then nst.SourceInfo(mapLine(p.line + 1), p.column + 1)
      else nst.SourceInfo()
