/*
 * Copyright © 2016-2024 Lightbend, Inc. All rights reserved.
 * No information contained herein may be reproduced or transmitted in any form
 * or by any means without the express written permission of Lightbend, Inc.
 */

package com.lightbend.tools.fortify.plugin

import java.io.File
import java.nio.file.PathMatcher

object Paths {
  def sourcePathToNstPath(sourceFile: File, dir: File): File = {
    import VersionSpecificHelpers._
    new File(
      sourceFile.toPath
        .toRealPath()
        .getParent
        .iterator
        .asScala
        .map(_.toString)
        .foldLeft(dir)(new File(_, _)),
      sourceFile.getName + ".nst")
  }
  def parseExcludes(specs: String): Vector[PathMatcher] = {
    val fs = java.nio.file.FileSystems.getDefault
    specs.split(java.io.File.pathSeparatorChar)
      .map(spec => fs.getPathMatcher(s"glob:$spec"))
      .toVector
  }
  def isExcluded(excludes: Seq[PathMatcher], file: File): Boolean =
    excludes.exists(_.matches(file.toPath))
}
