/*
 * Copyright © 2016-2024 Lightbend, Inc. All rights reserved.
 * No information contained herein may be reproduced or transmitted in any form
 * or by any means without the express written permission of Lightbend, Inc.
 */

package com.lightbend.tools.fortify.plugin

import scala.reflect.internal.Flags
import scala.tools.nsc

trait VersionSpecificHelpers[T <: nsc.symtab.SymbolTable] {
  val global: T
  import global._
  def hasSynthesizeImplInSubclassFlag(sym: Symbol) =
    sym.hasFlag(Flags.SYNTHESIZE_IMPL_IN_SUBCLASS)
  def isImplClass(sym: Symbol) =
    false
  def isLateDeferred(sym: Symbol) =
    false
  def hasJavaEnumFlag(sym: Symbol) =
    sym.hasJavaEnumFlag
  def isDelambdafyTarget(sym: Symbol) =
    sym.isDelambdafyTarget
}

object VersionSpecificHelpers {
  implicit class AsScala[T](it: java.util.Iterator[T]) {
    def asScala: scala.Iterator[T] = {
      new scala.jdk.CollectionConverters.IteratorHasAsScala(it).asScala
    }
  }
  def newStoreReporter(s: nsc.Settings): nsc.reporters.StoreReporter =
    new nsc.reporters.StoreReporter(s)
  def makeRegex(s: String, ss: Seq[String]) =
    new scala.util.matching.Regex(s, ss: _*)
}
