/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.frontend.nst.nodes;

import com.fortify.frontend.nst.NSTModifierSet;
import com.fortify.frontend.nst.NSTModifiers;
import com.fortify.frontend.nst.SourceInfo;
import com.fortify.frontend.nst.nodes.STAllocation;
import com.fortify.frontend.nst.nodes.STArrayAccess;
import com.fortify.frontend.nst.nodes.STAssignmentStmt;
import com.fortify.frontend.nst.nodes.STBlock;
import com.fortify.frontend.nst.nodes.STBreak;
import com.fortify.frontend.nst.nodes.STCatch;
import com.fortify.frontend.nst.nodes.STClassDecl;
import com.fortify.frontend.nst.nodes.STCompilationUnit;
import com.fortify.frontend.nst.nodes.STContinue;
import com.fortify.frontend.nst.nodes.STDereference;
import com.fortify.frontend.nst.nodes.STExpression;
import com.fortify.frontend.nst.nodes.STExternalDeclarations;
import com.fortify.frontend.nst.nodes.STFieldAccess;
import com.fortify.frontend.nst.nodes.STFieldDecl;
import com.fortify.frontend.nst.nodes.STFinally;
import com.fortify.frontend.nst.nodes.STFunCall;
import com.fortify.frontend.nst.nodes.STFunDecl;
import com.fortify.frontend.nst.nodes.STFunIdentifier;
import com.fortify.frontend.nst.nodes.STGoto;
import com.fortify.frontend.nst.nodes.STIfElse;
import com.fortify.frontend.nst.nodes.STLiteralExp;
import com.fortify.frontend.nst.nodes.STMapAccess;
import com.fortify.frontend.nst.nodes.STNode;
import com.fortify.frontend.nst.nodes.STOpExp;
import com.fortify.frontend.nst.nodes.STReturnStmt;
import com.fortify.frontend.nst.nodes.STStaticFieldAccess;
import com.fortify.frontend.nst.nodes.STThrow;
import com.fortify.frontend.nst.nodes.STTry;
import com.fortify.frontend.nst.nodes.STType;
import com.fortify.frontend.nst.nodes.STTypeCast;
import com.fortify.frontend.nst.nodes.STVarAccess;
import com.fortify.frontend.nst.nodes.STVarDecl;
import com.fortify.frontend.nst.nodes.STWhileStmt;
import com.fortify.frontend.nst.nodes.Visitor;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;

public class STWriter
extends Visitor<String> {
    private int indents = 0;
    private boolean showSourceInfo = true;

    public STWriter setShowSourceInfo(boolean bl) {
        this.showSourceInfo = bl;
        return this;
    }

    public boolean isSourceInfoEnabled() {
        return this.showSourceInfo;
    }

    public void incIndent() {
        ++this.indents;
    }

    public void decIndent() {
        --this.indents;
    }

    public String tab() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.indents; ++i) {
            stringBuilder.append("  ");
        }
        return stringBuilder.toString();
    }

    @Override
    public String visit(STNode sTNode) {
        throw new RuntimeException("Unimplemented print method for '" + sTNode + "' " + sTNode.getClass().getName());
    }

    @Override
    public String visit(STType.STClassType sTClassType) {
        return STWriter.identifier(sTClassType.getName());
    }

    private static boolean shouldEscapeIdentifierChar(int n) {
        return !(n >= 97 && n <= 122 || n >= 65 && n <= 90 || n >= 48 && n <= 57 || n == 94 || n == 63 || n == 36 || n == 95 || n == 46 || n == 126) && n != 64;
    }

    protected static String identifier(String string) {
        boolean bl = false;
        if (string.length() > 0 && string.charAt(0) == '^') {
            bl = true;
        }
        for (int n : new CodePointIterator(string)) {
            if (!STWriter.shouldEscapeIdentifierChar(n)) continue;
            bl = true;
            break;
        }
        if (bl) {
            string = string.replaceAll("\\\\", Matcher.quoteReplacement("\\\\"));
            string = string.replaceAll("\\|", Matcher.quoteReplacement("\\|"));
            return "|" + string + "|";
        }
        return string;
    }

    @Override
    public String visit(STType.STFunctionPointerType sTFunctionPointerType) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(sTFunctionPointerType.getReturnType().accept(this));
        stringBuilder.append(" (");
        boolean bl = true;
        for (STType sTType : sTFunctionPointerType.getParameters()) {
            if (!bl) {
                stringBuilder.append(", ");
            } else {
                bl = false;
            }
            stringBuilder.append(sTType.accept(this));
        }
        stringBuilder.append(')');
        stringBuilder.append(" :*:");
        return stringBuilder.toString();
    }

    @Override
    public String visit(STFunIdentifier sTFunIdentifier) {
        return "-> " + STWriter.identifier(sTFunIdentifier.getName());
    }

    @Override
    public String visit(STType.STPrimitiveType sTPrimitiveType) {
        return ":" + sTPrimitiveType.getName() + ":";
    }

    @Override
    public String visit(STType.STAnyType sTAnyType) {
        return ":anytype:";
    }

    @Override
    public String visit(STType.STArrayType sTArrayType) {
        return sTArrayType.getBase().accept(this) + "[]";
    }

    @Override
    public String visit(STType.STPointerType sTPointerType) {
        return sTPointerType.getBase().accept(this) + ":*:";
    }

    @Override
    public String visit(STFieldDecl sTFieldDecl) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getColumn(sTFieldDecl));
        this.printModifiers(sTFieldDecl.getModifiers(), stringBuilder);
        if (!sTFieldDecl.getModifiers().isEmpty()) {
            stringBuilder.append(' ');
        }
        stringBuilder.append(sTFieldDecl.getType().accept(this));
        stringBuilder.append(" ");
        stringBuilder.append(STWriter.identifier(sTFieldDecl.getName()));
        return stringBuilder.toString();
    }

    @Override
    public String visit(STArrayAccess sTArrayAccess) {
        return "((" + sTArrayAccess.getBase().accept(this) + ")[" + sTArrayAccess.getIndex().accept(this) + "])";
    }

    @Override
    public String visit(STMapAccess sTMapAccess) {
        return "(" + sTMapAccess.getBase().accept(this) + "){" + sTMapAccess.getIndex().accept(this) + "}";
    }

    @Override
    public String visit(STTypeCast sTTypeCast) {
        return "< " + sTTypeCast.getType().accept(this) + " > " + sTTypeCast.getExpression().accept(this);
    }

    @Override
    public String visit(STAllocation sTAllocation) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(":new: ");
        if (sTAllocation.getType() instanceof STType.STArrayType) {
            STType sTType = ((STType.STArrayType)sTAllocation.getType()).getBase();
            stringBuilder.append(sTType.accept(this));
            if (sTAllocation.getIndexes().isEmpty()) {
                stringBuilder.append("[");
            } else {
                for (STExpression sTExpression : sTAllocation.getIndexes()) {
                    stringBuilder.append("[");
                    stringBuilder.append(sTExpression.accept(this));
                    stringBuilder.append("]");
                }
            }
        } else {
            stringBuilder.append(sTAllocation.getType().accept(this));
            stringBuilder.append("()");
        }
        return stringBuilder.toString();
    }

    private String getColumn(STNode sTNode) {
        SourceInfo sourceInfo = sTNode.getSourceInfo();
        if (this.isSourceInfoEnabled() && sourceInfo != null && sourceInfo.getColumn() != -1) {
            return "#" + sourceInfo.getColumn() + "# ";
        }
        return "";
    }

    @Override
    public String visit(STVarDecl sTVarDecl) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(sTVarDecl.getType().accept(this));
        stringBuilder.append(" ");
        stringBuilder.append(STWriter.identifier(sTVarDecl.getName()));
        return stringBuilder.toString();
    }

    @Override
    public String visit(STFunDecl sTFunDecl) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getColumn(sTFunDecl));
        this.printModifiers(sTFunDecl.getModifiers(), stringBuilder);
        if (!sTFunDecl.getModifiers().isEmpty()) {
            stringBuilder.append(' ');
        }
        stringBuilder.append(sTFunDecl.getReturnType().accept(this));
        stringBuilder.append(" ");
        stringBuilder.append(STWriter.identifier(sTFunDecl.getName()));
        stringBuilder.append("(");
        boolean bl = true;
        for (STVarDecl object : sTFunDecl.getParameters()) {
            if (!bl) {
                stringBuilder.append(", ");
            } else {
                bl = false;
            }
            stringBuilder.append(this.getColumn(object));
            stringBuilder.append(object.accept(this));
        }
        stringBuilder.append(")");
        stringBuilder.append(": ");
        stringBuilder.append('\"');
        stringBuilder.append(STWriter.escapeString(sTFunDecl.getSimpleName()));
        stringBuilder.append('\"');
        if (!sTFunDecl.getOverrides().isEmpty()) {
            stringBuilder.append(" :overrides: ");
            bl = true;
            for (String string : sTFunDecl.getOverrides()) {
                if (!bl) {
                    stringBuilder.append(", ");
                } else {
                    bl = false;
                }
                stringBuilder.append(string);
            }
        }
        if (sTFunDecl.getBody() == null) {
            stringBuilder.append(";\n");
        } else {
            stringBuilder.append(" {");
            stringBuilder.append("\n");
            this.incIndent();
            stringBuilder.append(sTFunDecl.getBody().accept(this));
            this.decIndent();
            stringBuilder.append("\n}");
        }
        return stringBuilder.toString();
    }

    public String getLine(STNode sTNode) {
        SourceInfo sourceInfo = sTNode.getSourceInfo();
        if (this.isSourceInfoEnabled() && sourceInfo != null && sourceInfo.getLine() != -1) {
            return "#source-line " + sourceInfo.getLine() + "\n";
        }
        return "";
    }

    private boolean shouldOutputColumnInBlock(STNode sTNode) {
        if (!this.isSourceInfoEnabled()) {
            return false;
        }
        return !(sTNode instanceof STBlock);
    }

    @Override
    public String visit(STBlock sTBlock) {
        StringBuilder stringBuilder = new StringBuilder();
        if (sTBlock.getLabel() != null) {
            stringBuilder.append(sTBlock.getLabel());
            stringBuilder.append(":\n");
        }
        if (!sTBlock.isFoldable()) {
            stringBuilder.append(this.tab());
            stringBuilder.append("{\n");
            this.incIndent();
        }
        int n = -1;
        for (STNode sTNode : sTBlock.getBody()) {
            if (this.isSourceInfoEnabled() && sTNode.getSourceInfo().getLine() != n) {
                stringBuilder.append(this.getLine(sTNode));
                n = sTNode.getSourceInfo().getLine();
            }
            stringBuilder.append(this.tab());
            if (this.shouldOutputColumnInBlock(sTNode)) {
                stringBuilder.append(this.getColumn(sTNode));
            }
            stringBuilder.append(sTNode.accept(this));
            stringBuilder.append(sTNode.accept(new TerminalWriter()));
            stringBuilder.append("\n");
        }
        if (!sTBlock.isFoldable()) {
            this.decIndent();
            stringBuilder.append(this.tab());
            stringBuilder.append("}\n");
        }
        return stringBuilder.toString();
    }

    @Override
    public String visit(STDereference sTDereference) {
        return ":*: " + sTDereference.getBase().accept(this);
    }

    @Override
    public String visit(STVarAccess sTVarAccess) {
        return this.getColumn(sTVarAccess) + STWriter.identifier(sTVarAccess.getName());
    }

    @Override
    public String visit(STFunCall.Indirect indirect) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getColumn(indirect));
        stringBuilder.append("--> ");
        stringBuilder.append('(');
        stringBuilder.append(indirect.getPointer().accept(this));
        stringBuilder.append(')');
        stringBuilder.append("(");
        boolean bl = true;
        for (STExpression sTExpression : indirect.getArguments()) {
            if (!bl) {
                stringBuilder.append(", ");
            } else {
                bl = false;
            }
            stringBuilder.append(sTExpression.accept(this));
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public String visit(STFunCall sTFunCall) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getColumn(sTFunCall));
        if (sTFunCall.isDirect()) {
            stringBuilder.append("->");
        } else {
            stringBuilder.append("-~>");
        }
        stringBuilder.append(' ');
        stringBuilder.append(STWriter.identifier(sTFunCall.getName()));
        stringBuilder.append("(");
        boolean bl = true;
        for (STExpression sTExpression : sTFunCall.getArguments()) {
            if (!bl) {
                stringBuilder.append(", ");
            } else {
                bl = false;
            }
            stringBuilder.append(sTExpression.accept(this));
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public String visit(STAssignmentStmt sTAssignmentStmt) {
        return sTAssignmentStmt.getLeft().accept(this) + " " + this.getColumn(sTAssignmentStmt) + ":=: " + sTAssignmentStmt.getRight().accept(this);
    }

    @Override
    public String visit(STFinally sTFinally) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(":finally: {\n");
        this.incIndent();
        stringBuilder.append(sTFinally.getBody().accept(this));
        this.decIndent();
        stringBuilder.append(this.tab());
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    @Override
    public String visit(STCatch sTCatch) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(":catch: (");
        stringBuilder.append(sTCatch.getException().accept(this));
        stringBuilder.append("){\n");
        this.incIndent();
        stringBuilder.append(sTCatch.getBody().accept(this));
        this.decIndent();
        stringBuilder.append(this.tab());
        stringBuilder.append("} ");
        return stringBuilder.toString();
    }

    @Override
    public String visit(STTry sTTry) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(":try: {\n");
        this.incIndent();
        stringBuilder.append(sTTry.getBody().accept(this));
        this.decIndent();
        stringBuilder.append(this.tab());
        stringBuilder.append("} ");
        for (STCatch sTCatch : sTTry.getCatches()) {
            stringBuilder.append(sTCatch.accept(this));
        }
        if (sTTry.getFinally() != null) {
            stringBuilder.append(sTTry.getFinally().accept(this));
        }
        return stringBuilder.toString();
    }

    @Override
    public String visit(STOpExp sTOpExp) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        if (sTOpExp.getOperator().isUnary()) {
            stringBuilder.append(sTOpExp.getOperator().nstString());
            stringBuilder.append(" ");
            stringBuilder.append(sTOpExp.getLeft().accept(this));
        } else {
            stringBuilder.append(sTOpExp.getLeft().accept(this));
            stringBuilder.append(" ");
            stringBuilder.append(this.getColumn(sTOpExp));
            stringBuilder.append(sTOpExp.getOperator().nstString());
            if (sTOpExp.getRight() != null) {
                stringBuilder.append(" ");
                stringBuilder.append(sTOpExp.getRight().accept(this));
            }
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public String visit(STBreak sTBreak) {
        return ":break:";
    }

    @Override
    public String visit(STContinue sTContinue) {
        return ":continue:";
    }

    @Override
    public String visit(STGoto sTGoto) {
        return ":goto: " + sTGoto.getTargetLabel();
    }

    @Override
    public String visit(STIfElse sTIfElse) {
        StringBuilder stringBuilder = new StringBuilder();
        if (sTIfElse.getLabel() != null) {
            stringBuilder.append(sTIfElse.getLabel()).append(":");
            stringBuilder.append("\n");
            stringBuilder.append(this.tab());
        }
        stringBuilder.append(":if: ");
        stringBuilder.append("(");
        stringBuilder.append(sTIfElse.getPredicate().accept(this));
        stringBuilder.append("){\n");
        this.incIndent();
        stringBuilder.append(sTIfElse.getIfBody().accept(this));
        this.decIndent();
        stringBuilder.append(this.tab());
        stringBuilder.append("}");
        if (sTIfElse.getElseBody() != null) {
            stringBuilder.append(" :else: {\n");
            this.incIndent();
            stringBuilder.append(sTIfElse.getElseBody().accept(this));
            this.decIndent();
            stringBuilder.append(this.tab());
            stringBuilder.append("}\n");
        } else {
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    @Override
    public String visit(STFieldAccess sTFieldAccess) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        stringBuilder.append(sTFieldAccess.getInstanceType().accept(this));
        stringBuilder.append("]");
        stringBuilder.append(" (");
        stringBuilder.append(sTFieldAccess.getInstance().accept(this));
        stringBuilder.append(')');
        stringBuilder.append(" :.: ");
        stringBuilder.append(this.getColumn(sTFieldAccess));
        stringBuilder.append(STWriter.identifier(sTFieldAccess.getName()));
        return stringBuilder.toString();
    }

    @Override
    public String visit(STStaticFieldAccess sTStaticFieldAccess) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getColumn(sTStaticFieldAccess));
        stringBuilder.append("[");
        stringBuilder.append(sTStaticFieldAccess.getType().accept(this));
        stringBuilder.append("] ");
        stringBuilder.append(STWriter.identifier(sTStaticFieldAccess.getName()));
        return stringBuilder.toString();
    }

    @Override
    public String visit(STWhileStmt sTWhileStmt) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(":while: (");
        stringBuilder.append(sTWhileStmt.getPredicate().accept(this));
        stringBuilder.append("){\n");
        this.incIndent();
        stringBuilder.append(sTWhileStmt.getBody().accept(this));
        this.decIndent();
        stringBuilder.append(this.tab());
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }

    @Override
    public String visit(STLiteralExp.Null nullVal) {
        return this.getColumn(nullVal) + ":null:";
    }

    @Override
    public String visit(STLiteralExp.Integer integer) {
        return this.getColumn(integer) + String.valueOf(integer.getIntegerValue());
    }

    @Override
    public String visit(STLiteralExp.Long longVal) {
        return this.getColumn(longVal) + String.valueOf(longVal.getLongValue());
    }

    @Override
    public String visit(STThrow sTThrow) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(":throw: ");
        stringBuilder.append(sTThrow.getExpression().accept(this));
        return stringBuilder.toString();
    }

    @Override
    public String visit(STReturnStmt sTReturnStmt) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(":return:");
        if (sTReturnStmt.getExpression() != null) {
            stringBuilder.append(" ");
            stringBuilder.append(sTReturnStmt.getExpression().accept(this));
        }
        return stringBuilder.toString();
    }

    @Override
    public String visit(STLiteralExp.Double double_) {
        return this.getColumn(double_) + String.valueOf(double_.getDoubleValue());
    }

    public static String escapeChar(char c) {
        switch (c) {
            case '\\': {
                return "\\\\";
            }
            case '\'': {
                return "\\'";
            }
            case '\b': {
                return "\\b";
            }
            case '\t': {
                return "\\t";
            }
            case '\n': {
                return "\\n";
            }
            case '\f': {
                return "\\f";
            }
            case '\r': {
                return "\\r";
            }
        }
        return "" + c;
    }

    public static String escapeString(String string) {
        StringBuffer stringBuffer = null;
        block9: for (int i = 0; i < string.length(); ++i) {
            String string2;
            char c = string.charAt(i);
            switch (c) {
                case '\\': {
                    string2 = "\\\\";
                    break;
                }
                case '\"': {
                    string2 = "\\\"";
                    break;
                }
                case '\b': {
                    string2 = "\\b";
                    break;
                }
                case '\t': {
                    string2 = "\\t";
                    break;
                }
                case '\n': {
                    string2 = "\\n";
                    break;
                }
                case '\f': {
                    string2 = "\\f";
                    break;
                }
                case '\r': {
                    string2 = "\\r";
                    break;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        String string3 = "0000" + Integer.toString(c, 16);
                        string2 = "\\u" + string3.substring(string3.length() - 4, string3.length());
                        break;
                    }
                    if (stringBuffer == null) continue block9;
                    stringBuffer.append(c);
                    continue block9;
                }
            }
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
                if (i > 0) {
                    stringBuffer.append(string.substring(0, i));
                }
            }
            stringBuffer.append(string2);
        }
        if (stringBuffer != null) {
            return stringBuffer.toString();
        }
        return string;
    }

    @Override
    public String visit(STLiteralExp.String string) {
        return this.getColumn(string) + '\"' + STWriter.escapeString(string.getStringValue()) + '\"';
    }

    @Override
    public String visit(STLiteralExp.Character character) {
        return this.getColumn(character) + "'" + STWriter.escapeChar(character.getCharacterValue()) + "'";
    }

    public String getFunctionSignature(STFunDecl sTFunDecl) {
        StringBuilder stringBuilder = new StringBuilder();
        this.printModifiers(sTFunDecl.getModifiers(), stringBuilder);
        if (!sTFunDecl.getModifiers().isEmpty()) {
            stringBuilder.append(' ');
        }
        stringBuilder.append(sTFunDecl.getReturnType().accept(this));
        stringBuilder.append(" ");
        stringBuilder.append(STWriter.identifier(sTFunDecl.getName()));
        stringBuilder.append('(');
        boolean bl = true;
        for (STVarDecl object : sTFunDecl.getParameters()) {
            if (!bl) {
                stringBuilder.append(", ");
            } else {
                bl = false;
            }
            stringBuilder.append(object.accept(this));
        }
        stringBuilder.append(')');
        stringBuilder.append(": ");
        stringBuilder.append('\"');
        stringBuilder.append(STWriter.escapeString(sTFunDecl.getSimpleName()));
        stringBuilder.append('\"');
        if (!sTFunDecl.getOverrides().isEmpty()) {
            stringBuilder.append(" :overrides: ");
            bl = true;
            for (String string : sTFunDecl.getOverrides()) {
                if (!bl) {
                    stringBuilder.append(", ");
                } else {
                    bl = false;
                }
                stringBuilder.append(string);
            }
        }
        return stringBuilder.toString();
    }

    public String printModifier(NSTModifiers nSTModifiers) {
        switch (nSTModifiers) {
            case Abstract: {
                return ":abstract:";
            }
            case Annotation: {
                return ":annotation:";
            }
            case Const: {
                return ":const:";
            }
            case Enum: {
                return ":enum:";
            }
            case Environment: {
                return ":environment:";
            }
            case Extern: {
                return ":extern:";
            }
            case Final: {
                return ":final:";
            }
            case Inline: {
                return ":inline:";
            }
            case Interface: {
                return ":interface:";
            }
            case Module: {
                return ":module:";
            }
            case Native: {
                return ":native:";
            }
            case Private: {
                return ":private:";
            }
            case Property: {
                return ":property:";
            }
            case Protected: {
                return ":protected:";
            }
            case Public: {
                return ":public:";
            }
            case Serializable: {
                return ":serializable:";
            }
            case Static: {
                return ":static:";
            }
            case Strictfp: {
                return ":strictfp:";
            }
            case Synchronized: {
                return ":synchronized:";
            }
            case Synthetic: {
                return ":synthetic:";
            }
            case Transient: {
                return ":transient:";
            }
            case Union: {
                return ":union:";
            }
            case Virtual: {
                return ":virtual:";
            }
            case Volatile: {
                return ":volatile:";
            }
            case Webservice: {
                return ":webservice:";
            }
        }
        return "";
    }

    public StringBuilder printModifiers(NSTModifierSet nSTModifierSet, StringBuilder stringBuilder) {
        boolean bl = true;
        for (NSTModifiers nSTModifiers : nSTModifierSet) {
            if (!bl) {
                stringBuilder.append(' ');
            } else {
                bl = false;
            }
            stringBuilder.append(this.printModifier(nSTModifiers));
        }
        return stringBuilder;
    }

    @Override
    public String visit(STClassDecl sTClassDecl) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getColumn(sTClassDecl));
        this.printModifiers(sTClassDecl.getModifiers(), stringBuilder);
        if (!sTClassDecl.getModifiers().isEmpty()) {
            stringBuilder.append(' ');
        }
        stringBuilder.append(":class:");
        stringBuilder.append(" ");
        stringBuilder.append(STWriter.identifier(sTClassDecl.getName()));
        if (!sTClassDecl.getExtendsList().isEmpty()) {
            stringBuilder.append(" :extends: ");
            boolean bl = true;
            for (STType sTType : sTClassDecl.getExtendsList()) {
                if (!bl) {
                    stringBuilder.append(" ");
                }
                bl = false;
                stringBuilder.append(sTType.accept(this));
            }
            stringBuilder.append(" ");
        }
        if (sTClassDecl.getNamespace() != null) {
            stringBuilder.append(": ");
            stringBuilder.append('\"');
            stringBuilder.append(sTClassDecl.getNamespace());
            stringBuilder.append("\" ");
        }
        stringBuilder.append(": ");
        stringBuilder.append('\"');
        stringBuilder.append(STWriter.escapeString(sTClassDecl.getSimpleName()));
        stringBuilder.append('\"');
        stringBuilder.append(" {\n");
        this.incIndent();
        for (STFunDecl sTFunDecl : sTClassDecl.getFunDecls()) {
            stringBuilder.append(this.tab());
            stringBuilder.append(this.getFunctionSignature(sTFunDecl));
            stringBuilder.append(";\n");
        }
        for (STFieldDecl sTFieldDecl : sTClassDecl.getFieldDecls()) {
            stringBuilder.append(this.tab());
            stringBuilder.append(sTFieldDecl.accept(this));
            stringBuilder.append(";\n");
        }
        this.decIndent();
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    @Override
    public String visit(STLiteralExp.Boolean boolean_) {
        if (boolean_.getBooleanValue()) {
            return ":true:";
        }
        return ":false:";
    }

    @Override
    public String visit(STCompilationUnit sTCompilationUnit) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("#source-file ").append(sTCompilationUnit.getSourceFile().getAbsolutePath()).append("\n");
        stringBuilder.append("#source-type ").append(sTCompilationUnit.getSourceLanguage()).append("\n");
        for (STClassDecl sTNode : sTCompilationUnit.getClasses()) {
            for (STFunDecl sTFunDecl : sTNode.getFunDecls()) {
                stringBuilder.append(this.getLine(sTFunDecl));
                stringBuilder.append(sTFunDecl.accept(this));
                stringBuilder.append("\n");
            }
        }
        for (STFunDecl sTFunDecl : sTCompilationUnit.getFunctions()) {
            stringBuilder.append(this.getLine(sTFunDecl));
            stringBuilder.append(sTFunDecl.accept(this));
            stringBuilder.append('\n');
        }
        for (STVarDecl sTVarDecl : sTCompilationUnit.getVars()) {
            stringBuilder.append(this.getLine(sTVarDecl));
            stringBuilder.append(sTVarDecl.accept(this));
            stringBuilder.append('\n');
        }
        for (STClassDecl sTClassDecl : sTCompilationUnit.getClasses()) {
            stringBuilder.append(this.getLine(sTClassDecl));
            stringBuilder.append(sTClassDecl.accept(this));
            stringBuilder.append('\n');
        }
        if (sTCompilationUnit.getExternalDeclarations() != null) {
            stringBuilder.append(sTCompilationUnit.getExternalDeclarations().accept(this));
        }
        return stringBuilder.toString();
    }

    @Override
    public String visit(STExternalDeclarations sTExternalDeclarations) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("#NO-SOURCE-INFO\n");
        for (STFunDecl sTNode : sTExternalDeclarations.getFunctions()) {
            stringBuilder.append(this.getFunctionSignature(sTNode));
            stringBuilder.append("\n");
        }
        for (STClassDecl sTClassDecl : sTExternalDeclarations.getClasses()) {
            stringBuilder.append(sTClassDecl.accept(this));
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    private static class TerminalWriter
    extends Visitor<String> {
        private TerminalWriter() {
        }

        @Override
        public String visit(STNode sTNode) {
            return "";
        }

        @Override
        public String visit(STExpression sTExpression) {
            return ";";
        }

        @Override
        public String visit(STAssignmentStmt sTAssignmentStmt) {
            return ";";
        }

        @Override
        public String visit(STVarDecl sTVarDecl) {
            return ";";
        }

        @Override
        public String visit(STFunCall sTFunCall) {
            return ";";
        }

        @Override
        public String visit(STGoto sTGoto) {
            return ";";
        }

        @Override
        public String visit(STBreak sTBreak) {
            return ";";
        }

        @Override
        public String visit(STContinue sTContinue) {
            return ";";
        }

        @Override
        public String visit(STReturnStmt sTReturnStmt) {
            return ";";
        }

        @Override
        public String visit(STThrow sTThrow) {
            return ";";
        }
    }

    private static class CodePointIterator
    implements Iterator<Integer>,
    Iterable<Integer> {
        private final char[] chars;
        private int next;

        public CodePointIterator(CharSequence charSequence) {
            this.chars = charSequence.toString().toCharArray();
        }

        @Override
        public boolean hasNext() {
            return this.next < this.chars.length;
        }

        @Override
        public Integer next() {
            if (this.next > this.chars.length) {
                throw new NoSuchElementException();
            }
            int n = Character.codePointAt(this.chars, this.next);
            this.next += Character.charCount(n);
            return n;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<Integer> iterator() {
            return this;
        }
    }
}

