/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.frontend.nst.nodes;

import com.ergy.fset.FList;
import com.ergy.fset.FTreeList;
import com.fortify.frontend.nst.SourceInfo;
import com.fortify.frontend.nst.nodes.STExpression;
import com.fortify.frontend.nst.nodes.STNode;
import com.fortify.frontend.nst.nodes.Visitor;

public abstract class STLiteralExp
extends STExpression {
    private STLiteralExp(SourceInfo sourceInfo) {
        super(sourceInfo);
    }

    @Override
    public FList<STNode> getChildren() {
        return FTreeList.emptyList();
    }

    public static Boolean create(SourceInfo sourceInfo, boolean bl) {
        return new Boolean(sourceInfo, bl);
    }

    public static Boolean create(boolean bl) {
        return new Boolean(new SourceInfo(), bl);
    }

    public static Character create(SourceInfo sourceInfo, char c) {
        return new Character(sourceInfo, c);
    }

    public static Character create(char c) {
        return new Character(new SourceInfo(), c);
    }

    public static Long create(SourceInfo sourceInfo, long l) {
        return new Long(sourceInfo, l);
    }

    public static Double create(SourceInfo sourceInfo, double d) {
        return new Double(sourceInfo, d);
    }

    public static String create(SourceInfo sourceInfo, java.lang.String string) {
        return new String(sourceInfo, string);
    }

    public static String create(java.lang.String string) {
        return STLiteralExp.create(new SourceInfo(), string);
    }

    public static Integer create(SourceInfo sourceInfo, int n) {
        return new Integer(sourceInfo, n);
    }

    public static Integer create(int n) {
        return STLiteralExp.create(new SourceInfo(), n);
    }

    public static Null create(SourceInfo sourceInfo) {
        return new Null(sourceInfo);
    }

    public static Null create() {
        return STLiteralExp.create(new SourceInfo());
    }

    public static class Null
    extends STLiteralExp {
        private Null(SourceInfo sourceInfo) {
            super(sourceInfo);
        }

        @Override
        public <E> E accept(Visitor<E> visitor) {
            return visitor.visit(this);
        }

        @Override
        public Null clone() {
            return (Null)super.clone(new Null(this.getSourceInfo()));
        }

        public java.lang.String toString() {
            return "null";
        }
    }

    public static class Double
    extends STLiteralExp {
        private final double value;

        private Double(SourceInfo sourceInfo, double d) {
            super(sourceInfo);
            this.value = d;
        }

        @Override
        public <E> E accept(Visitor<E> visitor) {
            return visitor.visit(this);
        }

        @Override
        public Double clone() {
            return (Double)super.clone(new Double(this.getSourceInfo(), this.value));
        }

        public double getDoubleValue() {
            return this.value;
        }

        public java.lang.String toString() {
            return java.lang.String.valueOf(this.value);
        }
    }

    public static class Long
    extends STLiteralExp {
        private final long value;

        private Long(SourceInfo sourceInfo, long l) {
            super(sourceInfo);
            this.value = l;
        }

        @Override
        public Long clone() {
            return (Long)super.clone(new Long(this.getSourceInfo(), this.value));
        }

        @Override
        public <E> E accept(Visitor<E> visitor) {
            return visitor.visit(this);
        }

        public long getLongValue() {
            return this.value;
        }

        public java.lang.String toString() {
            return java.lang.String.valueOf(this.value);
        }
    }

    public static class Boolean
    extends STLiteralExp {
        private final boolean value;

        private Boolean(SourceInfo sourceInfo, boolean bl) {
            super(sourceInfo);
            this.value = bl;
        }

        @Override
        public <E> E accept(Visitor<E> visitor) {
            return visitor.visit(this);
        }

        @Override
        public Boolean clone() {
            return (Boolean)super.clone(new Boolean(this.getSourceInfo(), this.value));
        }

        public boolean getBooleanValue() {
            return this.value;
        }

        public java.lang.String toString() {
            return java.lang.String.valueOf(this.value);
        }
    }

    public static class Integer
    extends STLiteralExp {
        private int value;

        private Integer(SourceInfo sourceInfo, int n) {
            super(sourceInfo);
            this.value = n;
        }

        @Override
        public <E> E accept(Visitor<E> visitor) {
            return visitor.visit(this);
        }

        @Override
        public Integer clone() {
            return (Integer)super.clone(new Integer(this.getSourceInfo(), this.value));
        }

        public int getIntegerValue() {
            return this.value;
        }

        public java.lang.String toString() {
            return java.lang.String.valueOf(this.value);
        }
    }

    public static class Character
    extends STLiteralExp {
        private final char value;

        private Character(SourceInfo sourceInfo, char c) {
            super(sourceInfo);
            this.value = c;
        }

        public java.lang.String toString() {
            return "" + this.value;
        }

        @Override
        public String clone() {
            return (String)super.clone(new Character(this.getSourceInfo(), this.value));
        }

        @Override
        public <E> E accept(Visitor<E> visitor) {
            return visitor.visit(this);
        }

        public char getCharacterValue() {
            return this.value;
        }
    }

    public static class String
    extends STLiteralExp {
        private final java.lang.String value;

        private String(SourceInfo sourceInfo, java.lang.String string) {
            super(sourceInfo);
            this.value = string;
        }

        public java.lang.String toString() {
            return this.value;
        }

        @Override
        public String clone() {
            return (String)super.clone(new String(this.getSourceInfo(), this.value));
        }

        @Override
        public <E> E accept(Visitor<E> visitor) {
            return visitor.visit(this);
        }

        public java.lang.String getStringValue() {
            return this.value;
        }
    }
}

