/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.frontend.nst.nodes;

import com.ergy.fset.FList;
import com.ergy.fset.FTreeList;
import com.fortify.frontend.nst.NSTModifierSet;
import com.fortify.frontend.nst.NSTModifiers;
import com.fortify.frontend.nst.SourceInfo;
import com.fortify.frontend.nst.nodes.STBlock;
import com.fortify.frontend.nst.nodes.STDecl;
import com.fortify.frontend.nst.nodes.STNode;
import com.fortify.frontend.nst.nodes.STType;
import com.fortify.frontend.nst.nodes.STVarDecl;
import com.fortify.frontend.nst.nodes.Visitor;

public class STFunDecl
extends STDecl {
    private String className = null;
    private NSTModifierSet modifiers = NSTModifierSet.Empty;
    private String name;
    private String simpleName;
    private String namespace;
    private STType returnType;
    private FList<STType> exceptions = FTreeList.emptyList();
    private FList<STVarDecl> parameters = FTreeList.emptyList();
    private FList<String> overrides = FTreeList.emptyList();
    private STBlock block;
    private boolean varArg;

    @Override
    public FList<STNode> getChildren() {
        FList<Object> fList = FTreeList.emptyList();
        fList = fList.withLast(this.returnType);
        fList = fList.concat(this.parameters);
        fList = fList.concat(this.exceptions);
        fList = fList.withLast(this.block);
        return fList;
    }

    public FList<STVarDecl> getParameters() {
        return this.parameters;
    }

    public STVarDecl getParameter(int n) {
        if (this.parameters.size() >= n) {
            return (STVarDecl)this.parameters.get(n);
        }
        return null;
    }

    public STVarDecl getParameter(String string) {
        for (STVarDecl sTVarDecl : this.parameters) {
            if (!sTVarDecl.getName().equals(string)) continue;
            return sTVarDecl;
        }
        return null;
    }

    public void setParameters(FList<STVarDecl> fList) {
        for (STVarDecl sTVarDecl : fList) {
            sTVarDecl.setParent(this);
        }
        this.parameters = fList;
    }

    public void setBody(STBlock sTBlock) {
        if (sTBlock != null) {
            sTBlock.setParent(this);
        }
        this.block = sTBlock;
    }

    public String toString() {
        return this.name;
    }

    public STFunDecl(SourceInfo sourceInfo) {
        super(sourceInfo);
        this.setReturnType(new STType.STAnyType());
    }

    public STFunDecl() {
        this.setReturnType(new STType.STAnyType());
    }

    public STFunDecl(String string) {
        this.name = string;
        this.setReturnType(new STType.STAnyType());
    }

    public NSTModifierSet getModifiers() {
        return this.modifiers;
    }

    public boolean isVarArg() {
        return this.varArg;
    }

    public void setIsVarArg(boolean bl) {
        this.varArg = bl;
    }

    public void addParameter(STVarDecl sTVarDecl) {
        sTVarDecl.setParent(this);
        this.parameters = this.parameters.withLast(sTVarDecl);
    }

    public FList<STVarDecl> getArglist() {
        return this.parameters;
    }

    public STType getReturnType() {
        return this.returnType;
    }

    public void setReturnType(STType sTType) {
        sTType.setParent(this);
        this.returnType = sTType;
    }

    public void setSimpleName(String string) {
        this.simpleName = string;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public void add(STNode sTNode) {
        this.block.add(sTNode);
    }

    public void addFront(STNode sTNode) {
        this.block.addFront(sTNode);
    }

    public void addBlock(STBlock sTBlock) {
        if (this.block == null) {
            sTBlock.setParent(this);
            this.block = sTBlock;
        } else {
            this.block.add(sTBlock);
        }
    }

    public STBlock getBody() {
        return this.block;
    }

    public void addOverride(String string) {
        this.overrides = this.overrides.withLast(string);
    }

    public FList<String> getOverrides() {
        return this.overrides;
    }

    public FList<STType> getExceptions() {
        return this.exceptions;
    }

    public void setExceptions(FList<STType> fList) {
        this.exceptions = fList;
    }

    public void addException(STType sTType) {
        sTType.setParent(this);
        this.exceptions = this.exceptions.withLast(sTType);
    }

    public void setNamespace(String string) {
        this.namespace = string;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setModifiers(NSTModifiers ... nSTModifiersArray) {
        this.modifiers = this.modifiers.add(nSTModifiersArray);
    }

    public boolean isStatic() {
        return this.modifiers.contains(NSTModifiers.Static);
    }

    public void setModifiers(NSTModifierSet nSTModifierSet) {
        this.modifiers = nSTModifierSet;
    }

    @Override
    public STFunDecl clone() {
        return this.clone(new STFunDecl(this.getSourceInfo()));
    }

    @Override
    protected STFunDecl clone(STNode sTNode) {
        STFunDecl sTFunDecl = (STFunDecl)sTNode;
        super.clone(sTFunDecl);
        sTFunDecl.setModifiers(this.modifiers);
        sTFunDecl.setIsVarArg(this.varArg);
        sTFunDecl.setName(this.name);
        sTFunDecl.setSimpleName(this.simpleName);
        sTFunDecl.setReturnType(this.returnType.clone());
        sTFunDecl.setNamespace(this.namespace);
        sTFunDecl.setClassName(this.className);
        for (STVarDecl sTNode2 : this.parameters) {
            sTFunDecl.addParameter(sTNode2.clone());
        }
        for (STType sTType : this.exceptions) {
            sTFunDecl.addException(sTType.clone());
        }
        if (this.block != null) {
            sTFunDecl.addBlock(this.block.clone());
        }
        return sTFunDecl;
    }

    @Override
    public <E> E accept(Visitor<E> visitor) {
        return visitor.visit(this);
    }

    public void popArg() {
        this.parameters = this.parameters.suffixFrom(1);
    }

    public void pushArg(STVarDecl sTVarDecl) {
        sTVarDecl.setParent(this);
        this.parameters = this.parameters.withFirst(sTVarDecl);
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String string) {
        this.className = string;
    }

    public boolean similarPrototype(STFunDecl sTFunDecl) {
        return this.name.equals(sTFunDecl.getName());
    }
}

