/*
 * Decompiled with CFR 0.152.
 */
package com.ergy.fset;

import com.ergy.fset.AbstractFSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;

public final class FTreeSet<Elt>
extends AbstractFSet<Elt>
implements SortedSet<Elt>,
Comparable<FTreeSet<Elt>>,
Serializable {
    private static final int EQUALS_CACHE_THRESHOLD = 8;
    private static final FTreeSet<?> EMPTY_INSTANCE = new FTreeSet();
    final transient Object tree;
    private final Comparator<Elt> comp;
    private transient int hash_code = Integer.MIN_VALUE;
    private static final int MAX_LEAF_ARRAY_LENGTH = 8;
    private static final int BALANCE_FACTOR = 4;
    static final Object NEGATIVE_INFINITY = new Object();
    static final Object POSITIVE_INFINITY = new Object();
    static final Object NO_ELEMENT = new Object();
    private static final int BIN_SEARCH_NOT_FOUND = 0;
    private static final int BIN_SEARCH_FOUND = 1;
    private static final int BIN_SEARCH_FOUND_MASK = 1;
    private static final int BIN_SEARCH_INDEX_SHIFT = 1;
    private static Field TreeField;

    public static <Elt> FTreeSet<Elt> emptySet() {
        return EMPTY_INSTANCE;
    }

    public static <Elt> FTreeSet<Elt> emptySet(Comparator<? super Elt> comparator) {
        if (comparator == null) {
            return FTreeSet.emptySet();
        }
        return new FTreeSet<Elt>(comparator);
    }

    public FTreeSet() {
        this.tree = null;
        this.comp = null;
    }

    public FTreeSet(Elt Elt) {
        this.comp = null;
        this.tree = this.with(null, Elt);
    }

    public FTreeSet(Comparator<? super Elt> comparator) {
        this.tree = null;
        this.comp = comparator;
    }

    public FTreeSet(Elt Elt, Comparator<? super Elt> comparator) {
        this.comp = comparator;
        this.tree = this.with(null, Elt);
    }

    public FTreeSet(Collection<? extends Elt> collection) {
        this.comp = null;
        this.tree = this.fromCollection(collection);
    }

    public FTreeSet(Collection<? extends Elt> collection, Comparator<? super Elt> comparator) {
        this.comp = comparator;
        this.tree = this.fromCollection(collection);
    }

    public FTreeSet(SortedSet<Elt> sortedSet) {
        this.comp = sortedSet.comparator();
        this.tree = this.fromCollection(sortedSet);
    }

    private Object fromCollection(Collection<? extends Elt> collection) {
        if (collection instanceof FTreeSet && FTreeSet.eql(this.comp, ((FTreeSet)collection).comp)) {
            return ((FTreeSet)collection).tree;
        }
        Object object = null;
        for (Elt Elt : collection) {
            object = this.with(object, Elt);
        }
        return object;
    }

    public <T extends Elt> FTreeSet(T ... TArray) {
        this.comp = null;
        Object object = null;
        for (T t : TArray) {
            object = this.with(object, t);
        }
        this.tree = object;
    }

    public <T extends Elt> FTreeSet(Comparator<? super Elt> comparator, T ... TArray) {
        this.comp = comparator;
        Object object = null;
        for (T t : TArray) {
            object = this.with(object, t);
        }
        this.tree = object;
    }

    @Override
    public boolean isEmpty() {
        return this.tree == null;
    }

    @Override
    public int size() {
        return FTreeSet.treeSize(this.tree);
    }

    @Override
    public Elt arb() {
        if (this.tree == null) {
            throw new NoSuchElementException();
        }
        if (!(this.tree instanceof Node)) {
            Object[] objectArray = (Object[])this.tree;
            int n = objectArray.length;
            return (Elt)objectArray[n >> 1];
        }
        Node node = (Node)this.tree;
        if (node.element instanceof EquivalentSet) {
            return (Elt)((EquivalentSet)node.element).contents.get(0);
        }
        return (Elt)node.element;
    }

    @Override
    public boolean contains(Object object) {
        return this.contains(this.tree, object);
    }

    @Override
    public Iterator<Elt> iterator() {
        return new FTSIterator(this.tree);
    }

    @Override
    public FTreeSet<Elt> with(Elt Elt) {
        Object object = this.with(this.tree, Elt);
        if (object == this.tree) {
            return this;
        }
        return FTreeSet.make(object, this.comp);
    }

    @Override
    public FTreeSet<Elt> less(Elt Elt) {
        Object object = this.less(this.tree, Elt);
        if (object == this.tree) {
            return this;
        }
        if (object == null) {
            return FTreeSet.emptySet();
        }
        return FTreeSet.make(object, this.comp);
    }

    @Override
    public FTreeSet<Elt> union(Collection<? extends Elt> collection) {
        if (collection == this || collection.isEmpty()) {
            return this;
        }
        if (collection instanceof FTreeSet && FTreeSet.eql(this.comp, ((FTreeSet)collection).comp)) {
            FTreeSet fTreeSet = (FTreeSet)collection;
            if (this.isEmpty()) {
                return fTreeSet;
            }
            Object object = this.union(this.tree, fTreeSet.tree);
            return FTreeSet.make(object, this.comp);
        }
        FTreeSet<? extends Elt> fTreeSet = new FTreeSet<Elt>(collection, this.comp);
        Object object = this.union(this.tree, fTreeSet.tree);
        return FTreeSet.make(object, this.comp);
    }

    @Override
    public FTreeSet<Elt> intersection(Collection<? extends Elt> collection) {
        if (collection == this) {
            return this;
        }
        if (this.isEmpty() || collection.isEmpty()) {
            return FTreeSet.emptySet(this.comp);
        }
        if (collection instanceof FTreeSet && FTreeSet.eql(this.comp, ((FTreeSet)collection).comp)) {
            FTreeSet fTreeSet = (FTreeSet)collection;
            Object object = this.intersection(this.tree, fTreeSet.tree);
            return FTreeSet.make(object, this.comp);
        }
        FTreeSet<? extends Elt> fTreeSet = new FTreeSet<Elt>(collection, this.comp);
        Object object = this.intersection(this.tree, fTreeSet.tree);
        return FTreeSet.make(object, this.comp);
    }

    @Override
    public FTreeSet<Elt> difference(Collection<? extends Elt> collection) {
        if (collection == this) {
            return FTreeSet.emptySet(this.comp);
        }
        if (collection.isEmpty()) {
            return this;
        }
        if (collection instanceof FTreeSet && FTreeSet.eql(this.comp, ((FTreeSet)collection).comp)) {
            FTreeSet fTreeSet = (FTreeSet)collection;
            Object object = this.difference(this.tree, fTreeSet.tree);
            return FTreeSet.make(object, this.comp);
        }
        FTreeSet<? extends Elt> fTreeSet = new FTreeSet<Elt>(collection, this.comp);
        Object object = this.difference(this.tree, fTreeSet.tree);
        return FTreeSet.make(object, this.comp);
    }

    @Override
    public int compareTo(FTreeSet<Elt> fTreeSet) {
        if (fTreeSet == this) {
            return 0;
        }
        if (fTreeSet == null || !(fTreeSet instanceof FTreeSet) || !FTreeSet.eql(this.comp, fTreeSet.comp)) {
            throw new ClassCastException();
        }
        return this.compareTo(this.tree, fTreeSet.tree);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof FTreeSet && FTreeSet.eql(this.comp, ((FTreeSet)object).comp)) {
            FTreeSet fTreeSet = (FTreeSet)object;
            return this.equals(this.tree, fTreeSet.tree);
        }
        if (!(object instanceof Collection)) {
            return false;
        }
        Collection collection = (Collection)object;
        if (this.size() != collection.size()) {
            return false;
        }
        for (Object e : collection) {
            if (this.contains(this.tree, e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSubset(Collection<?> collection) {
        if (collection == this) {
            return true;
        }
        if (this.size() > collection.size()) {
            return false;
        }
        if (collection instanceof FTreeSet && FTreeSet.eql(this.comp, ((FTreeSet)collection).comp)) {
            FTreeSet fTreeSet = (FTreeSet)collection;
            return this.isSubset(this.tree, fTreeSet.tree);
        }
        for (Elt Elt : this) {
            if (collection.contains(Elt)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSuperset(Collection<?> collection) {
        if (collection == this) {
            return true;
        }
        if (this.size() < collection.size()) {
            return false;
        }
        if (collection instanceof FTreeSet && FTreeSet.eql(this.comp, ((FTreeSet)collection).comp)) {
            FTreeSet fTreeSet = (FTreeSet)collection;
            return this.isSubset(fTreeSet.tree, this.tree);
        }
        for (Object obj : collection) {
            if (this.contains(this.tree, obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        if (this.hash_code == Integer.MIN_VALUE) {
            this.hash_code = this.hashCode(this.tree);
        }
        return this.hash_code;
    }

    String dump() {
        return FTreeSet.dump(this.tree);
    }

    boolean verify() {
        return this.verify(this.tree, NEGATIVE_INFINITY, POSITIVE_INFINITY);
    }

    @Override
    public Comparator<Elt> comparator() {
        return this.comp;
    }

    @Override
    public Elt first() {
        if (this.tree == null) {
            throw new NoSuchElementException();
        }
        return (Elt)this.first(this.tree);
    }

    @Override
    public Elt last() {
        if (this.tree == null) {
            throw new NoSuchElementException();
        }
        return (Elt)this.last(this.tree);
    }

    @Override
    public SortedSet<Elt> subSet(Elt Elt, Elt Elt2) {
        if (this.tree == null) {
            return this;
        }
        Elt Elt3 = this.first();
        Elt Elt4 = this.last();
        if (this.compare(Elt, Elt2) >= 0 || this.compare(Elt3, Elt2) >= 0 || this.compare(Elt4, Elt) < 0) {
            return new FTreeSet<Elt>(this.comp);
        }
        if (this.compare(Elt3, Elt) >= 0 && this.compare(Elt4, Elt2) < 0) {
            return this;
        }
        Object object = this.split(this.tree, Elt, Elt2);
        Object object2 = this.findEquiv(this.tree, Elt);
        if (object2 != NO_ELEMENT) {
            object = this.with(object, object2);
        }
        return FTreeSet.make(object, this.comp);
    }

    @Override
    public SortedSet<Elt> headSet(Elt Elt) {
        if (this.tree == null || this.compare(this.last(), Elt) < 0) {
            return this;
        }
        if (this.compare(this.first(), Elt) >= 0) {
            return FTreeSet.make(null, this.comp);
        }
        return FTreeSet.make(this.split(this.tree, NEGATIVE_INFINITY, Elt), this.comp);
    }

    @Override
    public SortedSet<Elt> tailSet(Elt Elt) {
        if (this.tree == null || this.compare(this.first(), Elt) >= 0) {
            return this;
        }
        if (this.compare(this.last(), Elt) < 0) {
            return FTreeSet.make(null, this.comp);
        }
        Object object = this.split(this.tree, Elt, POSITIVE_INFINITY);
        Object object2 = this.findEquiv(this.tree, Elt);
        if (object2 != NO_ELEMENT) {
            object = this.with(object, object2);
        }
        return FTreeSet.make(object, this.comp);
    }

    private FTreeSet(int n, Object object, Comparator<? super Elt> comparator) {
        this.comp = comparator;
        this.tree = object;
    }

    static <Elt> FTreeSet<Elt> make(Object object, Comparator<? super Elt> comparator) {
        if (object == null && comparator == null) {
            return FTreeSet.emptySet();
        }
        return new FTreeSet<Elt>(42, object, comparator);
    }

    static Node makeNode(Object object, Object object2, Object object3) {
        return new Node(FTreeSet.treeSize(object2) + FTreeSet.treeSize(object3) + FTreeSet.elementSize(object), object, object2, object3);
    }

    private static int treeSize(Object object) {
        if (object == null) {
            return 0;
        }
        if (!(object instanceof Node)) {
            return ((Object[])object).length;
        }
        return ((Node)object).size;
    }

    private static int elementSize(Object object) {
        if (object instanceof EquivalentSet) {
            return ((EquivalentSet)object).contents.size();
        }
        return 1;
    }

    private Object first(Object object) {
        if (!(object instanceof Node)) {
            return ((Object[])object)[0];
        }
        Node node = (Node)object;
        if (node.left == null) {
            if (node.element instanceof EquivalentSet) {
                return ((EquivalentSet)node.element).contents.get(0);
            }
            return node.element;
        }
        return this.first(node.left);
    }

    private Object last(Object object) {
        if (!(object instanceof Node)) {
            Object[] objectArray = (Object[])object;
            return objectArray[objectArray.length - 1];
        }
        Node node = (Node)object;
        if (node.right == null) {
            if (node.element instanceof EquivalentSet) {
                ArrayList<Object> arrayList = ((EquivalentSet)node.element).contents;
                return arrayList.get(arrayList.size() - 1);
            }
            return node.element;
        }
        return this.last(node.right);
    }

    private boolean contains(Object object, Object object2) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Node)) {
            Object[] objectArray = (Object[])object;
            int n = this.binarySearch(objectArray, object2);
            if ((n & 1) == 1) {
                Object object3 = objectArray[n >> 1];
                return FTreeSet.eql(object2, object3);
            }
            return false;
        }
        Node node = (Node)object;
        Object object4 = node.element;
        int n = this.compare(object2, object4);
        if (n == 0) {
            if (object4 instanceof EquivalentSet) {
                return ((EquivalentSet)object4).contents.contains(object2);
            }
            return FTreeSet.eql(object2, object4);
        }
        if (n < 0) {
            return this.contains(node.left, object2);
        }
        return this.contains(node.right, object2);
    }

    Object with(Object object, Object object2) {
        if (object == null) {
            if (!(object2 instanceof EquivalentSet)) {
                Object[] objectArray = new Object[]{object2};
                return objectArray;
            }
            return FTreeSet.makeNode(object2, null, null);
        }
        if (!(object instanceof Node)) {
            Object[] objectArray = (Object[])object;
            int n = this.binarySearch(objectArray, object2);
            int n2 = n & 1;
            int n3 = n >> 1;
            if (n2 == 1 && !(object2 instanceof EquivalentSet) && FTreeSet.eql(object2, objectArray[n3])) {
                return object;
            }
            if (n2 == 0 && objectArray.length < 8 && !(object2 instanceof EquivalentSet)) {
                return FTreeSet.insert(objectArray, n3, object2);
            }
            return FTreeSet.makeNode(n2 == 1 ? FTreeSet.equivUnion(objectArray[n3], object2) : object2, FTreeSet.subseq(objectArray, 0, n3), FTreeSet.subseq(objectArray, n2 == 1 ? n3 + 1 : n3, objectArray.length));
        }
        Node node = (Node)object;
        Object object3 = node.element;
        int n = this.compare(object2, object3);
        if (n == 0) {
            if (!(object2 instanceof EquivalentSet) && !(object3 instanceof EquivalentSet) && FTreeSet.eql(object2, object3)) {
                return object;
            }
            return FTreeSet.makeNode(FTreeSet.equivUnion(object2, object3), node.left, node.right);
        }
        if (n < 0) {
            Object object4 = this.with(node.left, object2);
            if (object4 == node.left) {
                return object;
            }
            return this.buildNode(object3, object4, node.right);
        }
        Object object5 = this.with(node.right, object2);
        if (object5 == node.right) {
            return object;
        }
        return this.buildNode(object3, node.left, object5);
    }

    private Object less(Object object, Object object2) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof Node)) {
            Object[] objectArray = (Object[])object;
            int n = this.binarySearch(objectArray, object2);
            int n2 = n & 1;
            int n3 = n >> 1;
            if (n2 == 1) {
                Object object3 = objectArray[n3];
                if (FTreeSet.eql(object2, object3)) {
                    return FTreeSet.remove(objectArray, n3);
                }
                return object;
            }
            return object;
        }
        Node node = (Node)object;
        Object object4 = node.element;
        int n = this.compare(object2, object4);
        if (n == 0) {
            if (!(object4 instanceof EquivalentSet)) {
                if (object2 != null && !object2.equals(object4)) {
                    return object;
                }
                return this.join(node.left, node.right);
            }
            Object object5 = FTreeSet.equivDiff(object4, object2);
            return this.buildNode(object5, node.left, node.right);
        }
        if (n < 0) {
            Object object6 = this.less(node.left, object2);
            if (object6 == node.left) {
                return object;
            }
            return this.buildNode(object4, object6, node.right);
        }
        Object object7 = this.less(node.right, object2);
        if (object7 == node.right) {
            return object;
        }
        return this.buildNode(object4, node.left, object7);
    }

    private Object min(Object object) {
        if (!(object instanceof Node)) {
            return ((Object[])object)[0];
        }
        Node node = (Node)object;
        if (node.left == null) {
            return node.element;
        }
        return this.min(node.left);
    }

    private Object lessMin(Object object) {
        if (!(object instanceof Node)) {
            Object[] objectArray = (Object[])object;
            return FTreeSet.subseq(objectArray, 1, objectArray.length);
        }
        Node node = (Node)object;
        if (node.left == null) {
            return node.right;
        }
        return this.concat(node.element, this.lessMin(node.left), node.right);
    }

    private Object union(Object object, Object object2) {
        return this.union(object, object2, NEGATIVE_INFINITY, POSITIVE_INFINITY);
    }

    private Object union(Object object, Object object2, Object object3, Object object4) {
        if (object == object2 || object2 == null) {
            return this.split(object, object3, object4);
        }
        if (object == null) {
            return this.split(object2, object3, object4);
        }
        if (!(object instanceof Node)) {
            if (!(object2 instanceof Node)) {
                return this.union((Object[])object, (Object[])object2, object3, object4);
            }
            return this.union(object2, object, object3, object4);
        }
        Node node = (Node)object;
        Object object5 = node.element;
        Object object6 = this.findEquiv(object2, object5);
        return this.concat(FTreeSet.equivUnion(object5, object6), this.union(this.trim(node.left, object3, object5), this.trim(object2, object3, object5), object3, object5), this.union(this.trim(node.right, object5, object4), this.trim(object2, object5, object4), object5, object4));
    }

    private Object intersection(Object object, Object object2) {
        return this.intersection(object, object2, NEGATIVE_INFINITY, POSITIVE_INFINITY);
    }

    private Object intersection(Object object, Object object2, Object object3, Object object4) {
        if (object == object2) {
            return this.split(object, object3, object4);
        }
        if (object == null || object2 == null) {
            return null;
        }
        if (!(object instanceof Node)) {
            if (!(object2 instanceof Node)) {
                return this.intersection((Object[])object, (Object[])object2, object3, object4);
            }
            return this.intersection(this.trim(object2, object3, object4), object, object3, object4);
        }
        Node node = (Node)object;
        Object object5 = node.element;
        Object object6 = this.findEquiv(object2, object5);
        Object object7 = this.intersection(node.left, this.trim(object2, object3, object5), object3, object5);
        Object object8 = this.intersection(node.right, this.trim(object2, object5, object4), object5, object4);
        Object object9 = FTreeSet.equivIntersect(object5, object6);
        if (object9 == NO_ELEMENT) {
            return this.join(object7, object8);
        }
        return this.concat(object9, object7, object8);
    }

    private Object difference(Object object, Object object2) {
        return this.difference(object, object2, NEGATIVE_INFINITY, POSITIVE_INFINITY);
    }

    private Object difference(Object object, Object object2, Object object3, Object object4) {
        if (object == null || object == object2) {
            return null;
        }
        if (object2 == null) {
            return this.split(object, object3, object4);
        }
        if (!(object instanceof Node)) {
            if (!(object2 instanceof Node)) {
                return this.difference((Object[])object, (Object[])object2, object3, object4);
            }
            Node node = (Node)object2;
            Object object5 = node.element;
            Object object6 = this.findEquiv(object, object5);
            Object object7 = this.difference(this.trim(object, object3, object5), this.trim(node.left, object3, object5), object3, object5);
            Object object8 = this.difference(this.trim(object, object5, object4), this.trim(node.right, object5, object4), object5, object4);
            Object object9 = FTreeSet.equivDiff(object6, object5);
            if (object9 == NO_ELEMENT) {
                return this.join(object7, object8);
            }
            return this.concat(object9, object7, object8);
        }
        Node node = (Node)object;
        Object object10 = node.element;
        Object object11 = this.findEquiv(object2, object10);
        Object object12 = this.difference(node.left, this.trim(object2, object3, object10), object3, object10);
        Object object13 = this.difference(node.right, this.trim(object2, object10, object4), object10, object4);
        Object object14 = FTreeSet.equivDiff(object10, object11);
        if (object14 == NO_ELEMENT) {
            return this.join(object12, object13);
        }
        return this.concat(object14, object12, object13);
    }

    private int compareTo(Object object, Object object2) {
        int n;
        if (object == object2) {
            return 0;
        }
        int n2 = FTreeSet.treeSize(object);
        if (n2 < (n = FTreeSet.treeSize(object2))) {
            return -1;
        }
        if (n2 > n) {
            return 1;
        }
        return this.compareTo(object, 0, object2, 0, 0, n2);
    }

    private int compareTo(Object object, int n, Object object2, int n2, int n3, int n4) {
        int n5;
        if (object == object2 && n == n2 || n3 == n4) {
            return 0;
        }
        if (!(object instanceof Node)) {
            if (!(object2 instanceof Node)) {
                Object[] objectArray = (Object[])object;
                Object[] objectArray2 = (Object[])object2;
                for (int i = n3; i < n4; ++i) {
                    int n6 = this.compare(objectArray[i - n], objectArray2[i - n2]);
                    if (n6 == 0) continue;
                    return n6;
                }
                return 0;
            }
            return -this.compareTo(object2, n2, object, n, n3, n4);
        }
        Node node = (Node)object;
        Object object3 = node.left;
        int n7 = FTreeSet.treeSize(object3);
        int n8 = n + n7;
        RankTrimResult rankTrimResult = this.rankTrim(object3, n, n3, n8);
        RankTrimResult rankTrimResult2 = this.rankTrim(object2, n2, n3, n8);
        int n9 = this.compareTo(rankTrimResult.subtree, rankTrimResult.base, rankTrimResult2.subtree, rankTrimResult2.base, n3, n8);
        if (n9 != 0) {
            return n9;
        }
        Object object4 = node.element;
        Object object5 = this.rankElement(object2, n8 - n2);
        int n10 = this.compare(object4, object5);
        if (n10 != 0) {
            return n10;
        }
        int n11 = FTreeSet.elementSize(object4);
        if (n11 < (n5 = FTreeSet.elementSize(object5))) {
            return 1;
        }
        if (n11 > n5) {
            return -1;
        }
        int n12 = n + n7 + n11;
        RankTrimResult rankTrimResult3 = this.rankTrim(node.right, n12, n12, n4);
        RankTrimResult rankTrimResult4 = this.rankTrim(object2, n2, n12, n4);
        return this.compareTo(rankTrimResult3.subtree, rankTrimResult3.base, rankTrimResult4.subtree, rankTrimResult4.base, n12, n4);
    }

    private boolean equals(Object object, Object object2) {
        int n;
        if (object == object2) {
            return true;
        }
        int n2 = FTreeSet.treeSize(object);
        if (n2 != (n = FTreeSet.treeSize(object2))) {
            return false;
        }
        return this.equals(object, 0, object2, 0, 0, n2);
    }

    private boolean equals(Object object, int n, Object object2, int n2, int n3, int n4) {
        if (object == object2 && n == n2 || n3 == n4) {
            return true;
        }
        if (!(object instanceof Node)) {
            if (!(object2 instanceof Node)) {
                Object[] objectArray = (Object[])object;
                Object[] objectArray2 = (Object[])object2;
                for (int i = n3; i < n4; ++i) {
                    Object object3 = objectArray[i - n];
                    Object object4 = objectArray2[i - n2];
                    if (FTreeSet.eql(object3, object4)) continue;
                    return false;
                }
                return true;
            }
            return this.equals(object2, n2, object, n, n3, n4);
        }
        Node node = (Node)object;
        Object object5 = node.left;
        int n5 = FTreeSet.treeSize(object5);
        int n6 = n + n5;
        RankTrimResult rankTrimResult = this.rankTrim(object5, n, n3, n6);
        RankTrimResult rankTrimResult2 = this.rankTrim(object2, n2, n3, n6);
        if (!this.equals(rankTrimResult.subtree, rankTrimResult.base, rankTrimResult2.subtree, rankTrimResult2.base, n3, n6)) {
            return false;
        }
        Object object6 = node.element;
        Object object7 = this.rankElement(object2, n6 - n2);
        if (!FTreeSet.equivEquals(object6, object7)) {
            return false;
        }
        int n7 = FTreeSet.elementSize(object6);
        int n8 = n + n5 + n7;
        RankTrimResult rankTrimResult3 = this.rankTrim(node.right, n8, n8, n4);
        RankTrimResult rankTrimResult4 = this.rankTrim(object2, n2, n8, n4);
        return this.equals(rankTrimResult3.subtree, rankTrimResult3.base, rankTrimResult4.subtree, rankTrimResult4.base, n8, n4);
    }

    private RankTrimResult rankTrim(Object object, int n, int n2, int n3) {
        while (object != null && object instanceof Node) {
            Node node = (Node)object;
            int n4 = n + FTreeSet.treeSize(node.left);
            if (n4 >= n2) {
                if (n4 < n3) break;
                object = node.left;
                continue;
            }
            int n5 = n4 + FTreeSet.elementSize(node.element);
            if (n5 > n2) break;
            n = n5;
            object = node.right;
        }
        return new RankTrimResult(object, n);
    }

    private Object rankElement(Object object, int n) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (!(object instanceof Node)) {
            return ((Object[])object)[n];
        }
        Node node = (Node)object;
        int n2 = FTreeSet.treeSize(node.left);
        if (n < n2) {
            return this.rankElement(node.left, n);
        }
        Object object2 = node.element;
        int n3 = FTreeSet.elementSize(object2);
        if (n < n2 + n3) {
            return object2;
        }
        return this.rankElement(node.right, n - (n2 + n3));
    }

    private boolean isSubset(Object object, Object object2) {
        return this.isSubset(object, object2, NEGATIVE_INFINITY, POSITIVE_INFINITY);
    }

    private boolean isSubset(Object object, Object object2, Object object3, Object object4) {
        if (object == object2 || object == null) {
            return true;
        }
        if (!(object instanceof Node)) {
            if (object2 == null || !(object2 instanceof Node)) {
                return this.isSubset((Object[])object, (Object[])object2, object3, object4);
            }
            Node node = (Node)object2;
            Object object5 = node.element;
            if (!this.isSubset(this.trim(object, object3, object5), node.left, object3, object5)) {
                return false;
            }
            Object object6 = this.findEquiv(object, object5);
            if (!FTreeSet.equivIsSubset(object6, object5)) {
                return false;
            }
            return this.isSubset(this.trim(object, object5, object4), node.right, object5, object4);
        }
        if (object2 == null) {
            return false;
        }
        Node node = (Node)object;
        Object object7 = node.element;
        if (!this.isSubset(node.left, this.trim(object2, object3, object7), object3, object7)) {
            return false;
        }
        Object object8 = this.findEquiv(object2, object7);
        if (!FTreeSet.equivIsSubset(object7, object8)) {
            return false;
        }
        return this.isSubset(node.right, this.trim(object2, object7, object4), object7, object4);
    }

    Object findEquiv(Object object, Object object2) {
        if (object == null) {
            return NO_ELEMENT;
        }
        if (!(object instanceof Node)) {
            int n = this.binarySearch((Object[])object, object2);
            int n2 = n & 1;
            int n3 = n >> 1;
            if (n2 == 1) {
                return ((Object[])object)[n3];
            }
            return NO_ELEMENT;
        }
        Node node = (Node)object;
        Object object3 = node.element;
        int n = this.compare(object2, object3);
        if (n == 0) {
            return object3;
        }
        if (n < 0) {
            return this.findEquiv(node.left, object2);
        }
        return this.findEquiv(node.right, object2);
    }

    private int compare(Object object, Object object2) {
        if (object == null) {
            return object2 == null ? 0 : -1;
        }
        if (object2 == null) {
            return 1;
        }
        if (object instanceof EquivalentSet) {
            object = ((EquivalentSet)object).contents.get(0);
        }
        if (object2 instanceof EquivalentSet) {
            object2 = ((EquivalentSet)object2).contents.get(0);
        }
        if (this.comp != null) {
            return this.comp.compare(object, object2);
        }
        Comparable comparable = (Comparable)object;
        Comparable comparable2 = (Comparable)object2;
        return comparable.compareTo(comparable2);
    }

    private Object split(Object object, Object object2, Object object3) {
        int n;
        int n2;
        if (object == null) {
            return null;
        }
        if (object2 == NEGATIVE_INFINITY && object3 == POSITIVE_INFINITY) {
            return object;
        }
        if (!(object instanceof Node)) {
            int n3;
            Object[] objectArray = (Object[])object;
            int n4 = objectArray.length;
            int n5 = object2 == NEGATIVE_INFINITY ? 0 : this.binarySearchLo(objectArray, object2);
            int n6 = n3 = object3 == POSITIVE_INFINITY ? n4 : this.binarySearchHi(objectArray, object3);
            if (n5 >= n3) {
                return null;
            }
            if (n5 == 0 && n3 == n4) {
                return object;
            }
            return FTreeSet.subseq(objectArray, n5, n3);
        }
        Node node = (Node)object;
        if (object2 != NEGATIVE_INFINITY && (n2 = this.compare(node.element, object2)) <= 0) {
            if (object3 == POSITIVE_INFINITY && n2 == 0) {
                return node.right;
            }
            return this.split(node.right, object2, object3);
        }
        if (object3 != POSITIVE_INFINITY && (n = this.compare(node.element, object3)) >= 0) {
            if (object2 == NEGATIVE_INFINITY && n == 0) {
                return node.left;
            }
            return this.split(node.left, object2, object3);
        }
        Object object4 = this.split(node.left, object2, POSITIVE_INFINITY);
        Object object5 = this.split(node.right, NEGATIVE_INFINITY, object3);
        if (object4 == node.left && object5 == node.right) {
            return object;
        }
        return this.concat(node.element, object4, object5);
    }

    Object trim(Object object, Object object2, Object object3) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof Node)) {
            Object[] objectArray = (Object[])object;
            if (object2 != NEGATIVE_INFINITY && this.compare(objectArray[objectArray.length - 1], object2) <= 0 || object3 != POSITIVE_INFINITY && this.compare(objectArray[0], object3) >= 0) {
                return null;
            }
            return object;
        }
        Node node = (Node)object;
        if (object2 == NEGATIVE_INFINITY || this.compare(node.element, object2) > 0) {
            if (object3 == POSITIVE_INFINITY || this.compare(node.element, object3) < 0) {
                return object;
            }
            return this.trim(node.left, object2, object3);
        }
        return this.trim(node.right, object2, object3);
    }

    private Object concat(Object object, Object object2, Object object3) {
        if (object2 == null) {
            return this.with(object3, object);
        }
        if (object3 == null) {
            return this.with(object2, object);
        }
        int n = FTreeSet.treeSize(object2);
        int n2 = FTreeSet.treeSize(object3);
        if (object2 instanceof Node && n > n2 * 4) {
            Node node = (Node)object2;
            return this.buildNode(node.element, node.left, this.concat(object, node.right, object3));
        }
        if (object3 instanceof Node && n2 > n * 4) {
            Node node = (Node)object3;
            return this.buildNode(node.element, this.concat(object, object2, node.left), node.right);
        }
        return this.buildNode(object, object2, object3);
    }

    private Object join(Object object, Object object2) {
        if (object == null) {
            return object2;
        }
        if (object2 == null) {
            return object;
        }
        return this.concat(this.min(object2), object, this.lessMin(object2));
    }

    private Object buildNode(Object object, Object object2, Object object3) {
        if (!(object2 != null && object2 instanceof Node || object3 != null && object3 instanceof Node)) {
            Object[] objectArray = (Object[])object2;
            Object[] objectArray2 = (Object[])object3;
            if (!(object instanceof EquivalentSet) && (object2 == null ? 0 : objectArray.length) + (object3 == null ? 0 : objectArray2.length) < 8) {
                return FTreeSet.concat(object, objectArray, objectArray2);
            }
            return FTreeSet.makeNode(object, object2, object3);
        }
        int n = FTreeSet.treeSize(object2);
        int n2 = FTreeSet.treeSize(object3);
        if (object3 instanceof Node && n2 > n * 4) {
            Node node = (Node)object3;
            Object object4 = node.left;
            Object object5 = node.right;
            if (!(object4 instanceof Node) || FTreeSet.treeSize(object4) <= FTreeSet.treeSize(object5)) {
                return FTreeSet.makeNode(node.element, this.buildNode(object, object2, object4), object5);
            }
            Node node2 = (Node)object4;
            return FTreeSet.makeNode(node2.element, this.buildNode(object, object2, node2.left), this.buildNode(node.element, node2.right, object5));
        }
        if (object2 instanceof Node && n > n2 * 4) {
            Node node = (Node)object2;
            Object object6 = node.left;
            Object object7 = node.right;
            if (!(object7 instanceof Node) || FTreeSet.treeSize(object7) <= FTreeSet.treeSize(object6)) {
                return FTreeSet.makeNode(node.element, object6, this.buildNode(object, object7, object3));
            }
            Node node3 = (Node)object7;
            return FTreeSet.makeNode(node3.element, this.buildNode(node.element, object6, node3.left), this.buildNode(object, node3.right, object3));
        }
        return FTreeSet.makeNode(object, object2, object3);
    }

    private int hashCode(Object object) {
        if (object == null) {
            return 0;
        }
        if (!(object instanceof Node)) {
            Object[] objectArray = (Object[])object;
            int n = 0;
            for (Object object2 : objectArray) {
                if (object2 == null) continue;
                n += object2.hashCode();
            }
            return n;
        }
        Node node = (Node)object;
        int n = this.hashCode(node.left) + this.hashCode(node.right);
        Object object3 = node.element;
        if (object3 instanceof EquivalentSet) {
            ArrayList<Object> arrayList = ((EquivalentSet)object3).contents;
            int n2 = arrayList.size();
            for (int i = 0; i < n2; ++i) {
                Object object4 = arrayList.get(i);
                if (object4 == null) continue;
                n += object4.hashCode();
            }
        } else if (object3 != null) {
            n += object3.hashCode();
        }
        return n;
    }

    private static String dump(Object object) {
        if (object == null) {
            return "[null]";
        }
        if (object == NEGATIVE_INFINITY) {
            return "-oo";
        }
        if (object == POSITIVE_INFINITY) {
            return "+oo";
        }
        if (object == NO_ELEMENT) {
            return "NADA";
        }
        if (object instanceof EquivalentSet) {
            ArrayList<Object> arrayList = ((EquivalentSet)object).contents;
            String string = "[";
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    string = string + ", ";
                }
                string = string + arrayList.get(i);
            }
            return string + "]";
        }
        if (object instanceof Object[]) {
            StringBuffer stringBuffer = new StringBuffer("{");
            Object[] objectArray = (Object[])object;
            for (int i = 0; i < objectArray.length; ++i) {
                stringBuffer.append(FTreeSet.dump(objectArray[i]));
                if (i >= objectArray.length - 1) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append("}");
            return stringBuffer.toString();
        }
        if (object instanceof Node) {
            Node node = (Node)object;
            return "(" + node.size + ", " + FTreeSet.dump(node.element) + ";\n" + FTreeSet.indent(FTreeSet.dump(node.left), "  ") + ",\n" + FTreeSet.indent(FTreeSet.dump(node.right), "  ") + ")";
        }
        return object.toString();
    }

    private static String indent(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string2);
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            stringBuffer.append(c);
            if (c != '\n' || i >= n - 1) continue;
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    private boolean verify(Object object, Object object2, Object object3) {
        int n;
        if (object == null) {
            return true;
        }
        if (!(object instanceof Node)) {
            Object[] objectArray = (Object[])object;
            if (objectArray.length > 8) {
                return false;
            }
            boolean bl = true;
            Object object4 = object2;
            for (Object object5 : objectArray) {
                if (object5 instanceof EquivalentSet) {
                    return false;
                }
                if (object4 != NEGATIVE_INFINITY && this.compare(object4, object5) >= 0) {
                    bl = false;
                }
                object4 = object5;
            }
            if (object3 != POSITIVE_INFINITY && this.compare(object4, object3) >= 0) {
                bl = false;
            }
            return bl;
        }
        Node node = (Node)object;
        int n2 = FTreeSet.treeSize(node.left);
        if (node.size != n2 + (n = FTreeSet.treeSize(node.right)) + FTreeSet.elementSize(node.element)) {
            return false;
        }
        if (node.element instanceof EquivalentSet && ((EquivalentSet)node.element).contents.size() < 2) {
            return false;
        }
        if (n > 4 && n2 > n * 4 || n2 > 4 && n > n2 * 4) {
            return false;
        }
        return this.verify(node.left, object2, node.element) && this.verify(node.right, node.element, object3);
    }

    private static Object equivUnion(Object object, Object object2) {
        if (object == NO_ELEMENT) {
            return object2;
        }
        if (object2 == NO_ELEMENT) {
            return object;
        }
        if (object instanceof EquivalentSet) {
            ArrayList<Object> arrayList = ((EquivalentSet)object).contents;
            if (object2 instanceof EquivalentSet) {
                ArrayList<Object> arrayList2 = ((EquivalentSet)object2).contents;
                int n = arrayList2.size();
                ArrayList arrayList3 = (ArrayList)arrayList.clone();
                for (int i = 0; i < n; ++i) {
                    Object object3 = arrayList2.get(i);
                    if (arrayList3.contains(object3)) continue;
                    arrayList3.add(object3);
                }
                arrayList3.trimToSize();
                return new EquivalentSet(arrayList3);
            }
            if (arrayList.contains(object2)) {
                return object;
            }
            ArrayList arrayList4 = (ArrayList)arrayList.clone();
            arrayList4.add(object2);
            arrayList4.trimToSize();
            return new EquivalentSet(arrayList4);
        }
        if (object2 instanceof EquivalentSet) {
            ArrayList<Object> arrayList = ((EquivalentSet)object2).contents;
            if (arrayList.contains(object)) {
                return object2;
            }
            ArrayList arrayList5 = (ArrayList)arrayList.clone();
            arrayList5.add(object);
            arrayList5.trimToSize();
            return new EquivalentSet(arrayList5);
        }
        if (FTreeSet.eql(object, object2)) {
            return object;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(2);
        arrayList.add(object);
        arrayList.add(object2);
        return new EquivalentSet(arrayList);
    }

    private static Object equivIntersect(Object object, Object object2) {
        if (object == NO_ELEMENT || object2 == NO_ELEMENT) {
            return NO_ELEMENT;
        }
        if (object instanceof EquivalentSet) {
            ArrayList<Object> arrayList = ((EquivalentSet)object).contents;
            if (object2 instanceof EquivalentSet) {
                ArrayList<Object> arrayList2 = ((EquivalentSet)object2).contents;
                ArrayList<Object> arrayList3 = new ArrayList<Object>();
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    Object object3 = arrayList.get(i);
                    if (!arrayList2.contains(object3)) continue;
                    arrayList3.add(object3);
                }
                if (arrayList3.size() == 0) {
                    return NO_ELEMENT;
                }
                if (arrayList3.size() == 1) {
                    return arrayList3.get(0);
                }
                arrayList3.trimToSize();
                return new EquivalentSet(arrayList3);
            }
            if (arrayList.contains(object2)) {
                return object2;
            }
            return NO_ELEMENT;
        }
        if (object2 instanceof EquivalentSet) {
            ArrayList<Object> arrayList = ((EquivalentSet)object2).contents;
            if (arrayList.contains(object)) {
                return object;
            }
            return NO_ELEMENT;
        }
        if (FTreeSet.eql(object, object2)) {
            return object;
        }
        return NO_ELEMENT;
    }

    private static Object equivDiff(Object object, Object object2) {
        if (object == NO_ELEMENT) {
            return NO_ELEMENT;
        }
        if (object2 == NO_ELEMENT) {
            return object;
        }
        if (object instanceof EquivalentSet) {
            ArrayList<Object> arrayList = ((EquivalentSet)object).contents;
            ArrayList<Object> arrayList2 = null;
            if (object2 instanceof EquivalentSet) {
                arrayList2 = ((EquivalentSet)object2).contents;
            }
            ArrayList<Object> arrayList3 = new ArrayList<Object>();
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Object object3 = arrayList.get(i);
                if (!(arrayList2 == null ? !FTreeSet.eql(object3, object2) : !arrayList2.contains(object3))) continue;
                arrayList3.add(object3);
            }
            if (arrayList3.size() == 0) {
                return NO_ELEMENT;
            }
            if (arrayList3.size() == 1) {
                return arrayList3.get(0);
            }
            arrayList3.trimToSize();
            return new EquivalentSet(arrayList3);
        }
        if (object2 instanceof EquivalentSet) {
            if (!((EquivalentSet)object2).contents.contains(object)) {
                return object;
            }
            return NO_ELEMENT;
        }
        if (!FTreeSet.eql(object, object2)) {
            return object;
        }
        return NO_ELEMENT;
    }

    private static boolean equivEquals(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        if (object instanceof EquivalentSet) {
            if (object2 instanceof EquivalentSet) {
                ArrayList<Object> arrayList = ((EquivalentSet)object).contents;
                ArrayList<Object> arrayList2 = ((EquivalentSet)object2).contents;
                int n = arrayList.size();
                if (n != arrayList2.size()) {
                    return false;
                }
                for (int i = 0; i < n; ++i) {
                    if (arrayList2.contains(arrayList.get(i))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (object2 instanceof EquivalentSet) {
            return false;
        }
        return object.equals(object2);
    }

    private static boolean equivIsSubset(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == NO_ELEMENT) {
            return true;
        }
        if (object2 == NO_ELEMENT) {
            return false;
        }
        if (object instanceof EquivalentSet) {
            ArrayList<Object> arrayList = ((EquivalentSet)object).contents;
            if (object2 instanceof EquivalentSet) {
                ArrayList<Object> arrayList2 = ((EquivalentSet)object2).contents;
                return arrayList2.containsAll(arrayList);
            }
            return false;
        }
        if (object2 instanceof EquivalentSet) {
            ArrayList<Object> arrayList = ((EquivalentSet)object2).contents;
            return arrayList.contains(object);
        }
        return object.equals(object2);
    }

    private static Object[] concat(Object object, Object[] objectArray, Object[] objectArray2) {
        int n;
        int n2 = objectArray == null ? 0 : objectArray.length;
        int n3 = objectArray2 == null ? 0 : objectArray2.length;
        int n4 = n2 + 1 + n3;
        Object[] objectArray3 = new Object[n4];
        for (n = 0; n < n2; ++n) {
            objectArray3[n] = objectArray[n];
        }
        objectArray3[n2] = object;
        for (n = 0; n < n3; ++n) {
            objectArray3[n + n2 + 1] = objectArray2[n];
        }
        return objectArray3;
    }

    private static Object[] insert(Object[] objectArray, int n, Object object) {
        int n2;
        int n3 = objectArray.length + 1;
        Object[] objectArray2 = new Object[n3];
        for (n2 = 0; n2 < n; ++n2) {
            objectArray2[n2] = objectArray[n2];
        }
        objectArray2[n] = object;
        for (n2 = n + 1; n2 < n3; ++n2) {
            objectArray2[n2] = objectArray[n2 - 1];
        }
        return objectArray2;
    }

    private static Object[] remove(Object[] objectArray, int n) {
        int n2;
        int n3 = objectArray.length - 1;
        if (n3 == 0) {
            return null;
        }
        Object[] objectArray2 = new Object[n3];
        for (n2 = 0; n2 < n; ++n2) {
            objectArray2[n2] = objectArray[n2];
        }
        for (n2 = n; n2 < n3; ++n2) {
            objectArray2[n2] = objectArray[n2 + 1];
        }
        return objectArray2;
    }

    private static Object[] subseq(Object[] objectArray, int n, int n2) {
        if (n >= n2) {
            return null;
        }
        int n3 = n2 - n;
        Object[] objectArray2 = new Object[n3];
        for (int i = 0; i < n3; ++i) {
            objectArray2[i] = objectArray[i + n];
        }
        return objectArray2;
    }

    private Object union(Object[] objectArray, Object[] objectArray2, Object object, Object object2) {
        Object object3;
        Object object4;
        int n2;
        int n3 = 0;
        int n4 = objectArray.length;
        int n5 = objectArray2.length;
        if (object != NEGATIVE_INFINITY) {
            for (n2 = 0; n2 < n4 && this.compare(object, objectArray[n2]) >= 0; ++n2) {
            }
            while (n3 < n5 && this.compare(object, objectArray2[n3]) >= 0) {
                ++n3;
            }
        }
        if (object2 != POSITIVE_INFINITY) {
            while (n2 < n4 && this.compare(object2, objectArray[n4 - 1]) <= 0) {
                --n4;
            }
            while (n3 < n5 && this.compare(object2, objectArray2[n5 - 1]) <= 0) {
                --n5;
            }
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        boolean bl = false;
        while (true) {
            if (n2 == n4) {
                while (n3 < n5) {
                    arrayList.add(objectArray2[n3++]);
                }
                break;
            }
            if (n3 == n5) {
                while (n2 < n4) {
                    arrayList.add(objectArray[n2++]);
                }
                break;
            }
            object4 = objectArray[n2];
            object3 = objectArray2[n3];
            int n = this.compare(object4, object3);
            if (n < 0) {
                arrayList.add(object4);
                ++n2;
                continue;
            }
            if (n > 0) {
                arrayList.add(object3);
                ++n3;
                continue;
            }
            if (FTreeSet.eql(object4, object3)) {
                arrayList.add(object4);
            } else {
                arrayList.add(FTreeSet.equivUnion(object4, object3));
                bl = true;
            }
            ++n2;
            ++n3;
        }
        if (bl) {
            object4 = null;
            for (Object e : arrayList) {
                object4 = this.with(object4, e);
            }
            return object4;
        }
        int n6 = arrayList.size();
        object3 = arrayList.toArray();
        if (n6 > 8) {
            int n = n6 / 2;
            return FTreeSet.makeNode(arrayList.get(n), FTreeSet.subseq((Object[])object3, 0, n), FTreeSet.subseq((Object[])object3, n + 1, n6));
        }
        return object3;
    }

    private Object[] intersection(Object[] objectArray, Object[] objectArray2, Object object, Object object2) {
        int n;
        int n2 = 0;
        int n3 = objectArray.length;
        int n4 = objectArray2.length;
        if (object != NEGATIVE_INFINITY) {
            for (n = 0; n < n3 && this.compare(object, objectArray[n]) >= 0; ++n) {
            }
        }
        if (object2 != POSITIVE_INFINITY) {
            while (n < n3 && this.compare(object2, objectArray[n3 - 1]) <= 0) {
                --n3;
            }
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (n < n3 && n2 < n4) {
            Object object3 = objectArray[n];
            Object object4 = objectArray2[n2];
            int n5 = this.compare(object3, object4);
            if (n5 < 0) {
                ++n;
                continue;
            }
            if (n5 > 0) {
                ++n2;
                continue;
            }
            if (FTreeSet.eql(object3, object4)) {
                arrayList.add(object3);
            }
            ++n;
            ++n2;
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList.toArray();
    }

    private Object[] difference(Object[] objectArray, Object[] objectArray2, Object object, Object object2) {
        int n;
        int n2 = 0;
        int n3 = objectArray.length;
        int n4 = objectArray2.length;
        if (object != NEGATIVE_INFINITY) {
            for (n = 0; n < n3 && this.compare(object, objectArray[n]) >= 0; ++n) {
            }
        }
        if (object2 != POSITIVE_INFINITY) {
            while (n < n3 && this.compare(object2, objectArray[n3 - 1]) <= 0) {
                --n3;
            }
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (n < n3 && n2 < n4) {
            Object object3 = objectArray[n];
            Object object4 = objectArray2[n2];
            int n5 = this.compare(object3, object4);
            if (n5 < 0) {
                arrayList.add(object3);
                ++n;
                continue;
            }
            if (n5 > 0) {
                ++n2;
                continue;
            }
            if (!FTreeSet.eql(object3, object4)) {
                arrayList.add(object3);
            }
            ++n;
            ++n2;
        }
        while (n < n3) {
            arrayList.add(objectArray[n++]);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList.toArray();
    }

    private boolean isSubset(Object[] objectArray, Object[] objectArray2, Object object, Object object2) {
        int n;
        int n2;
        int n3 = 0;
        int n4 = objectArray.length;
        int n5 = n2 = objectArray2 != null ? objectArray2.length : 0;
        if (object != NEGATIVE_INFINITY) {
            for (n = 0; n < n4 && this.compare(object, objectArray[n]) >= 0; ++n) {
            }
        }
        if (object2 != POSITIVE_INFINITY) {
            while (n < n4 && this.compare(object2, objectArray[n4 - 1]) <= 0) {
                --n4;
            }
        }
        while (n < n4 && n3 < n2) {
            Object object3 = objectArray[n];
            Object object4 = objectArray2[n3];
            int n6 = this.compare(object3, object4);
            if (n6 < 0) {
                return false;
            }
            if (n6 > 0) {
                ++n3;
                continue;
            }
            if (!FTreeSet.eql(object3, object4)) {
                return false;
            }
            ++n;
            ++n3;
        }
        return n >= n4;
    }

    private int binarySearch(Object[] objectArray, Object object) {
        int n = 0;
        int n2 = objectArray.length - 1;
        while (n <= n2) {
            int n3 = (n + n2) / 2;
            Object object2 = objectArray[n3];
            int n4 = this.compare(object, object2);
            if (n4 == 0) {
                return n3 << 1 | 1;
            }
            if (n4 < 0) {
                n2 = n3 - 1;
                continue;
            }
            n = n3 + 1;
        }
        return n << 1 | 0;
    }

    private int binarySearchLo(Object[] objectArray, Object object) {
        int n = this.binarySearch(objectArray, object);
        int n2 = n >> 1;
        if ((n & 1) == 1) {
            return n2 + 1;
        }
        return n2;
    }

    private int binarySearchHi(Object[] objectArray, Object object) {
        int n = this.binarySearch(objectArray, object);
        return n >> 1;
    }

    private static boolean eql(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size());
        for (Elt Elt : this) {
            objectOutputStream.writeObject(Elt);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.hash_code = Integer.MIN_VALUE;
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        Object object = null;
        for (int i = 0; i < n; ++i) {
            object = this.with(object, objectInputStream.readObject());
        }
        try {
            TreeField.set(this, object);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("FTreeSet deserialization failed", illegalAccessException);
        }
    }

    static {
        try {
            TreeField = FTreeSet.class.getDeclaredField("tree");
            TreeField.setAccessible(true);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new RuntimeException("Static initialization failed", noSuchFieldException);
        }
    }

    private static final class FTSIterator<Elt>
    implements Iterator<Elt> {
        private IteratorNode inode;

        private FTSIterator(Object object) {
            this.inode = new IteratorNode(object, 0, null);
            this.canonicalize();
        }

        private void canonicalize() {
            while (this.inode != null) {
                if (this.inode.subtree == null) {
                    this.inode = this.inode.parent;
                    if (this.inode == null) break;
                    ++this.inode.index;
                    continue;
                }
                if (!(this.inode.subtree instanceof Node)) {
                    if (this.inode.index < ((Object[])this.inode.subtree).length) break;
                    this.inode = this.inode.parent;
                    if (this.inode == null) break;
                    ++this.inode.index;
                    continue;
                }
                Node node = (Node)this.inode.subtree;
                if (this.inode.index == 0) {
                    this.inode = new IteratorNode(node.left, 0, this.inode);
                    continue;
                }
                if (this.inode.index != FTreeSet.elementSize(node.element) + 1) break;
                this.inode = new IteratorNode(node.right, 0, this.inode.parent);
            }
        }

        @Override
        public boolean hasNext() {
            return this.inode != null;
        }

        @Override
        public Elt next() {
            Object object;
            if (this.inode == null) {
                throw new NoSuchElementException();
            }
            if (!(this.inode.subtree instanceof Node)) {
                object = ((Object[])this.inode.subtree)[this.inode.index];
            } else {
                Node node = (Node)this.inode.subtree;
                if (node.element instanceof EquivalentSet) {
                    ArrayList<Object> arrayList = ((EquivalentSet)node.element).contents;
                    object = arrayList.get(this.inode.index - 1);
                } else {
                    object = node.element;
                }
            }
            this.inode.index++;
            this.canonicalize();
            return (Elt)object;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private static final class IteratorNode {
            private final Object subtree;
            private int index;
            private final IteratorNode parent;

            IteratorNode(Object object, int n, IteratorNode iteratorNode) {
                this.subtree = object;
                this.index = n;
                this.parent = iteratorNode;
            }
        }
    }

    static final class EquivalentSet {
        ArrayList<Object> contents;

        EquivalentSet(ArrayList<Object> arrayList) {
            this.contents = arrayList;
        }
    }

    private static final class RankTrimResult {
        Object subtree;
        int base;

        RankTrimResult(Object object, int n) {
            this.subtree = object;
            this.base = n;
        }
    }

    static final class Node {
        final int size;
        final Object element;
        final Object left;
        final Object right;

        Node(int n, Object object, Object object2, Object object3) {
            this.size = n;
            this.element = object;
            this.left = object2;
            this.right = object3;
        }
    }
}

