/*
 * Copyright © Lightbend, Inc. dba Akka
 * All rights reserved.
 * No information contained herein may be reproduced or transmitted in any form
 * or by any means without the express written permission of Akka, Inc.
 */

package com.lightbend.tools.fortify.plugin

import scala.tools.nsc

import com.fortify.frontend.nst

import nst._

// I consider it safe to use an implicit conversion here, since
// we never use either Position or SourceInfo in any other way.

trait Positions {
  import scala.language.implicitConversions
  def mapLine(lineNumber: Int): Int
  implicit def position2info(p: nsc.Global#Position): SourceInfo =
    if (p.isDefined)
      new SourceInfo(mapLine(p.line), p.column)
    else
      new SourceInfo
}
