/*
 * Copyright (C) 2016-2021 Lightbend Inc. <https://www.lightbend.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package cloudflow.streamlets.proto.javadsl

import cloudflow.streamlets._
import com.google.protobuf.GeneratedMessageV3

import scala.util.Try

class ProtoCodec[T <: GeneratedMessageV3](clazz: Class[T]) extends Codec[T] {
  val parser = clazz.getMethod("parseFrom", classOf[Array[Byte]])

  def encode(value: T): Array[Byte] = value.toByteArray
  def decode(bytes: Array[Byte]): Try[T] = Try {
    parser.invoke(clazz, bytes).asInstanceOf[T]
  }
}
