/*
 * Copyright (C) 2016-2021 Lightbend Inc. <https://www.lightbend.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package cloudflow.streamlets

sealed trait AccessMode
case object ReadWriteMany extends AccessMode
case object ReadOnlyMany  extends AccessMode

case class VolumeMount(name: String, private[cloudflow] val path: String, accessMode: AccessMode)
object VolumeMount {
  // Java Api
  def createReadOnlyMany(name: String, path: String)  = VolumeMount(name, path, ReadOnlyMany)
  def createReadWriteMany(name: String, path: String) = VolumeMount(name, path, ReadWriteMany)
}
