/*
 * Decompiled with CFR 0.152.
 */
package cloudflow.operator.event;

import akka.datap.crd.App;
import akka.kube.actions.Action;
import cloudflow.operator.action.CloudflowLabels$;
import cloudflow.operator.action.EventActions$;
import cloudflow.operator.action.runner.Runner;
import cloudflow.operator.event.Event;
import cloudflow.operator.event.Event$;
import cloudflow.operator.event.StreamletChangeEvent;
import cloudflow.operator.event.WatchEvent;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.client.informers.EventType;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class StreamletChangeEvent$
implements Event,
Serializable {
    public static final StreamletChangeEvent$ MODULE$ = new StreamletChangeEvent$();
    private static final Logger log;

    static {
        Event.$init$(MODULE$);
        log = LoggerFactory.getLogger(MODULE$.getClass());
    }

    @Override
    public <T extends HasMetadata> String changeInfo(WatchEvent<T> watchEvent) {
        return Event.changeInfo$(this, watchEvent);
    }

    @Override
    public String getKind(HasMetadata obj) {
        return Event.getKind$(this, obj);
    }

    private Logger log() {
        return log;
    }

    public Tuple2<Map<String, WatchEvent<Secret>>, List<StreamletChangeEvent<Secret>>> toStreamletChangeEvent(Map<String, WatchEvent<Secret>> currentObjects, WatchEvent<Secret> watchEvent) {
        Tuple2 tuple2;
        Secret secret = watchEvent.obj();
        ObjectMeta metadata = secret.getMetadata();
        String secretName = metadata.getName();
        String namespace = metadata.getNamespace();
        String absoluteName = new StringBuilder(1).append(namespace).append(".").append(secretName).toString();
        EventType eventType = watchEvent.eventType();
        if (EventType.DELETION.equals(eventType)) {
            List events = Option$.MODULE$.apply(metadata.getLabels().get(CloudflowLabels$.MODULE$.AppIdLabel())).flatMap((Function1 & Serializable)appId -> Option$.MODULE$.apply(metadata.getLabels().get(CloudflowLabels$.MODULE$.StreamletNameLabel())).map((Function1 & Serializable)streamletName -> new StreamletChangeEvent((String)appId, (String)streamletName, watchEvent))).toList();
            tuple2 = new Tuple2((Object)currentObjects.$minus((Object)absoluteName), (Object)events);
        } else {
            boolean bl = EventType.ADDITION.equals(eventType) ? true : EventType.UPDATION.equals(eventType);
            if (bl) {
                tuple2 = currentObjects.get((Object)absoluteName).forall((Function1 & Serializable)existingEvent -> BoxesRunTime.boxToBoolean((boolean)StreamletChangeEvent$.hasChanged$1(existingEvent, secret))) ? (Tuple2)Option$.MODULE$.apply(metadata.getLabels().get(CloudflowLabels$.MODULE$.AppIdLabel())).flatMap((Function1 & Serializable)appId -> Option$.MODULE$.apply(metadata.getLabels().get(CloudflowLabels$.MODULE$.StreamletNameLabel())).map((Function1 & Serializable)streamletName -> new Tuple2((Object)currentObjects.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)absoluteName), (Object)watchEvent)), package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StreamletChangeEvent[]{new StreamletChangeEvent((String)appId, (String)streamletName, watchEvent)}))))).getOrElse((Function0 & Serializable)() -> new Tuple2((Object)currentObjects, package$.MODULE$.List().apply((Seq)Nil$.MODULE$))) : new Tuple2(currentObjects, package$.MODULE$.List().apply((Seq)Nil$.MODULE$));
            } else if (EventType.ERROR.equals(eventType)) {
                this.log().error("Received an error event!");
                tuple2 = new Tuple2((Object)Predef$.MODULE$.Map().empty(), (Object)package$.MODULE$.List().empty());
            } else {
                throw new MatchError((Object)eventType);
            }
        }
        return tuple2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Seq<Action> toActionList(Option<App.Cr> mappedApp, StreamletChangeEvent<Secret> event, Map<String, Runner<?>> runners, String podName) {
        Tuple2 tuple2 = new Tuple2(mappedApp, event);
        if (tuple2 == null) return package$.MODULE$.Nil();
        Option option = (Option)tuple2._1();
        StreamletChangeEvent streamletChangeEvent = (StreamletChangeEvent)tuple2._2();
        if (!(option instanceof Some)) return package$.MODULE$.Nil();
        Some some = (Some)option;
        App.Cr app = (App.Cr)some.value();
        EventType eventType = streamletChangeEvent.watchEvent().eventType();
        EventType eventType2 = EventType.UPDATION;
        if (eventType == null) {
            if (eventType2 != null) {
                return package$.MODULE$.Nil();
            }
        } else if (!eventType.equals(eventType2)) return package$.MODULE$.Nil();
        Secret secret = (Secret)streamletChangeEvent.watchEvent().obj();
        ObjectMeta metadata = secret.getMetadata();
        return (Seq)Option$.MODULE$.apply(metadata.getLabels().get(CloudflowLabels$.MODULE$.ConfigFormat())).map((Function1 & Serializable)configFormat -> {
            List<Action> list;
            String string = configFormat;
            String string2 = CloudflowLabels$.MODULE$.StreamletDeploymentConfigFormat();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                MODULE$.log().debug(new StringBuilder(38).append("[app: ").append(streamletChangeEvent.appId()).append(" updating config for streamlet ").append(streamletChangeEvent.streamletName()).append("]").toString());
                list = MODULE$.actionsForRunner(app, streamletChangeEvent, podName, runners);
            } else {
                list = package$.MODULE$.Nil();
            }
            return list;
        }).getOrElse((Function0 & Serializable)() -> package$.MODULE$.Nil());
    }

    public List<Action> actionsForRunner(App.Cr app, StreamletChangeEvent<Secret> streamletChangeEvent, String podName, Map<String, Runner<?>> runners) {
        Secret secret = streamletChangeEvent.watchEvent().obj();
        return (List)((App.Spec)app.getSpec()).deployments().find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StreamletChangeEvent$.$anonfun$actionsForRunner$1(streamletChangeEvent, x$1))).map((Function1 & Serializable)streamletDeployment -> {
            MODULE$.log().info(new StringBuilder(44).append("[app: ").append(((App.Spec)app.getSpec()).appId()).append(" configuration changed for streamlet ").append(streamletChangeEvent.streamletName()).append("]").toString());
            List updateAction = runners.get((Object)streamletDeployment.runtime()).map((Function1 & Serializable)x$2 -> x$2.streamletChangeAction(app, runners, (App.Deployment)streamletDeployment, secret)).toList();
            Action streamletChangeEventAction = EventActions$.MODULE$.streamletChangeEvent(app, (App.Deployment)streamletDeployment, podName, Event$.MODULE$.toObjectReference((HasMetadata)secret));
            return (List)updateAction.$colon$plus((Object)streamletChangeEventAction);
        }).getOrElse((Function0 & Serializable)() -> package$.MODULE$.Nil());
    }

    public <T extends HasMetadata> StreamletChangeEvent<T> apply(String appId, String streamletName, WatchEvent<T> watchEvent) {
        return new StreamletChangeEvent<T>(appId, streamletName, watchEvent);
    }

    public <T extends HasMetadata> Option<Tuple3<String, String, WatchEvent<T>>> unapply(StreamletChangeEvent<T> x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple3((Object)x$0.appId(), (Object)x$0.streamletName(), x$0.watchEvent()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(StreamletChangeEvent$.class);
    }

    private static final boolean hasChanged$1(WatchEvent existingEvent, Secret secret$1) {
        String string = secret$1.getMetadata().getResourceVersion();
        String string2 = ((Secret)existingEvent.obj()).getMetadata().getResourceVersion();
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$actionsForRunner$1(StreamletChangeEvent streamletChangeEvent$2, App.Deployment x$1) {
        String string = x$1.streamletName();
        String string2 = streamletChangeEvent$2.streamletName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private StreamletChangeEvent$() {
    }
}

