/*
 * Decompiled with CFR 0.152.
 */
package cloudflow.operator.event;

import akka.datap.crd.App;
import akka.kube.actions.Action;
import cloudflow.operator.action.CloudflowLabels$;
import cloudflow.operator.action.CloudflowStatus$;
import cloudflow.operator.action.CloudflowStatus$Status$;
import cloudflow.operator.action.runner.Runner;
import cloudflow.operator.event.Event;
import cloudflow.operator.event.StatusChangeEvent;
import cloudflow.operator.event.WatchEvent;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.informers.EventType;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class StatusChangeEvent$
implements Event,
Serializable {
    public static final StatusChangeEvent$ MODULE$ = new StatusChangeEvent$();
    private static Logger log;
    private static volatile boolean bitmap$0;

    static {
        Event.$init$(MODULE$);
    }

    @Override
    public <T extends HasMetadata> String changeInfo(WatchEvent<T> watchEvent) {
        return Event.changeInfo$(this, watchEvent);
    }

    @Override
    public String getKind(HasMetadata obj) {
        return Event.getKind$(this, obj);
    }

    private Logger log$lzycompute() {
        StatusChangeEvent$ statusChangeEvent$ = this;
        synchronized (statusChangeEvent$) {
            if (!bitmap$0) {
                log = LoggerFactory.getLogger(this.getClass());
                bitmap$0 = true;
            }
        }
        return log;
    }

    public Logger log() {
        return !bitmap$0 ? this.log$lzycompute() : log;
    }

    public String detected(StatusChangeEvent event) {
        return new StringBuilder(54).append("Status change for streamlet ").append(event.streamletName()).append(" detected in application ").append(event.appId()).append(".").toString();
    }

    public Tuple2<Map<String, WatchEvent<Pod>>, List<StatusChangeEvent>> toStatusChangeEvent(Map<String, WatchEvent<Pod>> currentObjects, WatchEvent<Pod> watchEvent) {
        Tuple2 tuple2;
        Pod obj = watchEvent.obj();
        ObjectMeta metadata = obj.getMetadata();
        String objName = obj.getMetadata().getName();
        String namespace = obj.getMetadata().getNamespace();
        String absoluteName = new StringBuilder(1).append(namespace).append(".").append(objName).toString();
        EventType eventType = watchEvent.eventType();
        if (EventType.DELETION.equals(eventType)) {
            List events = Option$.MODULE$.apply(metadata.getLabels().get(CloudflowLabels$.MODULE$.AppIdLabel())).flatMap((Function1 & Serializable)appId -> Option$.MODULE$.apply(metadata.getLabels().get(CloudflowLabels$.MODULE$.StreamletNameLabel())).map((Function1 & Serializable)streamletName -> {
                MODULE$.log().debug(new StringBuilder(51).append("[Status changes] Detected StatusChangeEvent for ").append(absoluteName).append(": ").append(MODULE$.changeInfo(watchEvent)).append(".").toString());
                return new StatusChangeEvent((String)appId, (String)streamletName, watchEvent);
            })).toList();
            tuple2 = new Tuple2((Object)currentObjects.$minus((Object)absoluteName), (Object)events);
        } else {
            boolean bl = EventType.ADDITION.equals(eventType) ? true : EventType.UPDATION.equals(eventType);
            if (bl) {
                tuple2 = (Tuple2)Option$.MODULE$.apply(metadata.getLabels().get(CloudflowLabels$.MODULE$.AppIdLabel())).flatMap((Function1 & Serializable)appId -> Option$.MODULE$.apply(metadata.getLabels().get(CloudflowLabels$.MODULE$.StreamletNameLabel())).map((Function1 & Serializable)streamletName -> {
                    MODULE$.log().debug(new StringBuilder(51).append("[Status changes] Detected StatusChangeEvent for ").append(absoluteName).append(": ").append(MODULE$.changeInfo(watchEvent)).append(".").toString());
                    return new Tuple2((Object)currentObjects.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)absoluteName), (Object)watchEvent)), package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StatusChangeEvent[]{new StatusChangeEvent((String)appId, (String)streamletName, watchEvent)})));
                })).getOrElse((Function0 & Serializable)() -> new Tuple2((Object)currentObjects, package$.MODULE$.List().apply((Seq)Nil$.MODULE$)));
            } else {
                if (EventType.ERROR.equals(eventType)) {
                    throw new Exception("Received Error event!");
                }
                throw new MatchError((Object)eventType);
            }
        }
        return tuple2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Tuple2<Map<String, App.Cr>, Seq<Action>> toActionList(Map<String, App.Cr> currentStatuses, Option<App.Cr> mappedApp, Map<String, Runner<?>> runners, StatusChangeEvent event) {
        Tuple2 tuple2;
        Option option;
        Tuple2 tuple22 = new Tuple2(mappedApp, (Object)event);
        if (tuple22 != null) {
            Option option2 = (Option)tuple22._1();
            StatusChangeEvent statusChangeEvent = (StatusChangeEvent)tuple22._2();
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                App.Cr app = (App.Cr)some.value();
                Option option3 = Option$.MODULE$.apply(app.getStatus()).flatMap((Function1 & Serializable)s -> Option$.MODULE$.apply((Object)s.appStatus()));
                Some some2 = new Some((Object)CloudflowStatus$Status$.MODULE$.Error());
                if (option3 == null ? some2 != null : !option3.equals(some2)) {
                    this.log().debug(new StringBuilder(46).append("[Status changes] Handling StatusChange for ").append(((App.Spec)app.getSpec()).appId()).append(": ").append(this.changeInfo(statusChangeEvent.watchEvent())).append(".").toString());
                    String appId = ((App.Spec)app.getSpec()).appId();
                    App.Cr appCr = (App.Cr)currentStatuses.get((Object)appId).map((Function1 & Serializable)curr -> {
                        App.Cr cr;
                        if (curr.getStatus() != null) {
                            app.setStatus(curr.getStatus());
                            cr = CloudflowStatus$.MODULE$.updateApp(app, runners);
                        } else {
                            app.setStatus((Object)CloudflowStatus$.MODULE$.freshStatus((App.Spec)app.getSpec(), runners));
                            cr = app;
                        }
                        return cr;
                    }).getOrElse((Function0 & Serializable)() -> {
                        app.setStatus((Object)CloudflowStatus$.MODULE$.freshStatus((App.Spec)app.getSpec(), runners));
                        return app;
                    });
                    StatusChangeEvent statusChangeEvent2 = statusChangeEvent;
                    if (statusChangeEvent2 != null) {
                        String appId2 = statusChangeEvent2.appId();
                        String streamletName = statusChangeEvent2.streamletName();
                        WatchEvent<Pod> watchEvent = statusChangeEvent2.watchEvent();
                        EventType eventType = watchEvent.eventType();
                        boolean bl = EventType.ADDITION.equals(eventType) ? true : EventType.UPDATION.equals(eventType);
                        if (bl) {
                            this.log().debug(new StringBuilder(53).append("[Status changes] app: ").append(appId2).append(" status of streamlet ").append(streamletName).append(" changed: ").append(this.changeInfo(watchEvent)).toString());
                            App.AppStatus newStatus = CloudflowStatus$.MODULE$.updatePod((App.AppStatus)appCr.getStatus(), streamletName, watchEvent.obj());
                            appCr.setStatus((Object)newStatus);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else if (EventType.DELETION.equals(eventType)) {
                            this.log().debug(new StringBuilder(53).append("[Status changes] app: ").append(appId2).append(" status of streamlet ").append(streamletName).append(" changed: ").append(this.changeInfo(watchEvent)).toString());
                            App.AppStatus newStatus = CloudflowStatus$.MODULE$.deletePod((App.AppStatus)appCr.getStatus(), streamletName, watchEvent.obj());
                            appCr.setStatus((Object)newStatus);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            this.log().warn(new StringBuilder(98).append("[Status changes] Detected an unexpected change in ").append(appId2).append(" ").append(this.changeInfo(watchEvent)).append(" in streamlet ").append(streamletName).append(" (only expecting Pod changes): \n ").append(watchEvent).toString());
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        this.log().warn(new StringBuilder(53).append("[Status changes] Unhandled status change event in ").append(appId).append(" : ").append(statusChangeEvent2).toString());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    Map updatedStatuses = (Map)currentStatuses.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)appId), (Object)appCr));
                    return new Tuple2((Object)updatedStatuses, (Object)updatedStatuses.get((Object)appId).map((Function1 & Serializable)a -> {
                        App.Cr x$1 = a;
                        int x$2 = CloudflowStatus$.MODULE$.statusUpdateAction$default$2(x$1);
                        return CloudflowStatus$.MODULE$.statusUpdateAction(x$1, x$2);
                    }).toList());
                }
            }
        }
        if (tuple22 != null && (option = (Option)tuple22._1()) instanceof Some) {
            Some some = (Some)option;
            App.Cr app = (App.Cr)some.value();
            Option option4 = Option$.MODULE$.apply(app.getStatus()).flatMap((Function1 & Serializable)s -> Option$.MODULE$.apply((Object)s.appStatus()));
            Some some3 = new Some((Object)CloudflowStatus$Status$.MODULE$.Error());
            if (option4 == null) {
                if (some3 == null) return new Tuple2(currentStatuses, package$.MODULE$.List().apply((Seq)Nil$.MODULE$));
            } else if (option4.equals(some3)) {
                return new Tuple2(currentStatuses, package$.MODULE$.List().apply((Seq)Nil$.MODULE$));
            }
        }
        if (tuple22 == null) throw new MatchError((Object)tuple22);
        Option option5 = (Option)tuple22._1();
        StatusChangeEvent statusChangeEvent = (StatusChangeEvent)tuple22._2();
        if (!None$.MODULE$.equals(option5)) throw new MatchError((Object)tuple22);
        if (currentStatuses.contains((Object)statusChangeEvent.appId())) {
            this.log().info(new StringBuilder(91).append("[Status changes] App could not be found for StatusChange: ").append(this.changeInfo(statusChangeEvent.watchEvent())).append(", removing from current statuses.").toString());
            tuple2 = new Tuple2((Object)currentStatuses.$minus((Object)statusChangeEvent.appId()), package$.MODULE$.List().apply((Seq)Nil$.MODULE$));
            return tuple2;
        } else {
            tuple2 = new Tuple2(currentStatuses, package$.MODULE$.List().apply((Seq)Nil$.MODULE$));
        }
        return tuple2;
    }

    public StatusChangeEvent apply(String appId, String streamletName, WatchEvent<Pod> watchEvent) {
        return new StatusChangeEvent(appId, streamletName, watchEvent);
    }

    public Option<Tuple3<String, String, WatchEvent<Pod>>> unapply(StatusChangeEvent x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple3((Object)x$0.appId(), (Object)x$0.streamletName(), x$0.watchEvent()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(StatusChangeEvent$.class);
    }

    private StatusChangeEvent$() {
    }
}

