/*
 * Decompiled with CFR 0.152.
 */
package cloudflow.operator.action.runner;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.api.model.DeleteOptions;
import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.api.model.ListOptionsBuilder;
import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.kubernetes.client.dsl.base.OperationSupport;
import io.fabric8.kubernetes.client.dsl.internal.RawWatchConnectionManager;
import io.fabric8.kubernetes.client.internal.PatchUtils;
import io.fabric8.kubernetes.client.utils.HttpClientUtils;
import io.fabric8.kubernetes.client.utils.IOHelpers;
import io.fabric8.kubernetes.client.utils.Serialization;
import io.fabric8.kubernetes.client.utils.Utils;
import io.fabric8.kubernetes.client.utils.WatcherToggle;
import io.fabric8.zjsonpatch.JsonDiff;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class RawCustomResourceOperationsImpl
extends OperationSupport {
    private static final String METADATA = "metadata";
    private static final String RESOURCE_VERSION = "resourceVersion";
    private OkHttpClient client;
    private Config config;
    private CustomResourceDefinitionContext customResourceDefinition;
    private ObjectMapper objectMapper;

    public RawCustomResourceOperationsImpl(OkHttpClient okHttpClient, Config config, CustomResourceDefinitionContext customResourceDefinitionContext) {
        this.client = okHttpClient;
        this.config = config;
        this.customResourceDefinition = customResourceDefinitionContext;
        this.objectMapper = Serialization.jsonMapper();
    }

    public RawCustomResourceOperationsImpl(OkHttpClient okHttpClient, Config config, CustomResourceDefinitionContext customResourceDefinitionContext, ObjectMapper objectMapper) {
        this.client = okHttpClient;
        this.config = config;
        this.customResourceDefinition = customResourceDefinitionContext;
        this.objectMapper = objectMapper;
    }

    public Map<String, Object> load(InputStream inputStream) throws IOException {
        return this.convertJsonOrYamlStringToMap(IOHelpers.readFully((InputStream)inputStream));
    }

    public Map<String, Object> load(String string) throws IOException {
        return this.convertJsonOrYamlStringToMap(string);
    }

    public Map<String, Object> create(String string) throws IOException {
        return this.validateAndSubmitRequest(null, null, string, HttpCallMethod.POST);
    }

    public Map<String, Object> create(Map<String, Object> map) throws IOException {
        return this.validateAndSubmitRequest(null, null, this.objectMapper.writeValueAsString(map), HttpCallMethod.POST);
    }

    public Map<String, Object> create(String string, String string2) throws IOException {
        return this.validateAndSubmitRequest(string, null, string2, HttpCallMethod.POST);
    }

    public Map<String, Object> create(InputStream inputStream) throws IOException {
        return this.validateAndSubmitRequest(null, null, IOHelpers.readFully((InputStream)inputStream), HttpCallMethod.POST);
    }

    public Map<String, Object> create(String string, InputStream inputStream) throws IOException {
        return this.validateAndSubmitRequest(string, null, IOHelpers.readFully((InputStream)inputStream), HttpCallMethod.POST);
    }

    public Map<String, Object> create(String string, Map<String, Object> map) throws IOException {
        return this.validateAndSubmitRequest(string, null, this.objectMapper.writeValueAsString(map), HttpCallMethod.POST);
    }

    public Map<String, Object> createOrReplace(String string) throws IOException {
        return this.createOrReplaceObject(null, this.load(string));
    }

    public Map<String, Object> createOrReplace(Map<String, Object> map) throws IOException {
        return this.createOrReplaceObject(null, map);
    }

    public Map<String, Object> createOrReplace(InputStream inputStream) throws IOException {
        return this.createOrReplaceObject(null, this.load(inputStream));
    }

    public Map<String, Object> createOrReplace(String string, String string2) throws IOException {
        return this.createOrReplaceObject(string, this.load(string2));
    }

    public Map<String, Object> createOrReplace(String string, Map<String, Object> map) throws IOException {
        return this.createOrReplaceObject(string, map);
    }

    public Map<String, Object> createOrReplace(String string, InputStream inputStream) throws IOException {
        return this.createOrReplaceObject(string, this.load(inputStream));
    }

    public Map<String, Object> edit(String string, Map<String, Object> map) throws IOException {
        return this.validateAndSubmitRequest(null, string, this.objectMapper.writeValueAsString(map), HttpCallMethod.PATCH);
    }

    public Map<String, Object> edit(String string, String string2) throws IOException {
        return this.validateAndSubmitRequest(null, string, string2, HttpCallMethod.PATCH);
    }

    public Map<String, Object> edit(String string, String string2, Map<String, Object> map) throws IOException {
        String string3 = this.appendResourceVersionGetDiff(string, string2, map);
        return this.validateAndSubmitRequest(string, string2, string3, HttpCallMethod.PATCH);
    }

    public Map<String, Object> edit(String string, String string2, String string3) throws IOException {
        string3 = this.appendResourceVersionGetDiff(string, string2, string3);
        return this.validateAndSubmitRequest(string, string2, string3, HttpCallMethod.PATCH);
    }

    public Map<String, Object> edit(String string, InputStream inputStream) throws IOException {
        return this.validateAndSubmitRequest(null, string, IOHelpers.readFully((InputStream)inputStream), HttpCallMethod.PATCH);
    }

    public Map<String, Object> edit(String string, String string2, InputStream inputStream) throws IOException {
        return this.validateAndSubmitRequest(string, string2, IOHelpers.readFully((InputStream)inputStream), HttpCallMethod.PATCH);
    }

    public Map<String, Object> updateStatus(String string, Map<String, Object> map) throws IOException {
        return this.validateAndSubmitRequest(this.fetchUrl(null, string, null) + "/status", this.objectMapper.writeValueAsString(map), HttpCallMethod.PUT);
    }

    public Map<String, Object> updateStatus(String string, String string2) throws IOException {
        return this.validateAndSubmitRequest(this.fetchUrl(null, string, null) + "/status", string2, HttpCallMethod.PUT);
    }

    public Map<String, Object> updateStatus(String string, String string2, Map<String, Object> map) throws IOException {
        return this.validateAndSubmitRequest(this.fetchUrl(string, string2, null) + "/status", this.objectMapper.writeValueAsString(map), HttpCallMethod.PUT);
    }

    public Map<String, Object> updateStatus(String string, InputStream inputStream) throws IOException {
        return this.validateAndSubmitRequest(this.fetchUrl(null, string, null) + "/status", IOHelpers.readFully((InputStream)inputStream), HttpCallMethod.PUT);
    }

    public Map<String, Object> updateStatus(String string, String string2, InputStream inputStream) throws IOException {
        return this.validateAndSubmitRequest(this.fetchUrl(string, string2, null) + "/status", IOHelpers.readFully((InputStream)inputStream), HttpCallMethod.PUT);
    }

    public Map<String, Object> updateStatus(String string, String string2, String string3) throws IOException {
        return this.validateAndSubmitRequest(this.fetchUrl(string, string2, null) + "/status", string3, HttpCallMethod.PUT);
    }

    public Map<String, Object> get(String string) {
        return this.makeCall(this.fetchUrl(null, string, null), null, HttpCallMethod.GET);
    }

    public Map<String, Object> get(String string, String string2) {
        return this.makeCall(this.fetchUrl(string, string2, null), null, HttpCallMethod.GET);
    }

    public Map<String, Object> list() {
        return this.makeCall(this.fetchUrl(null, null, null), null, HttpCallMethod.GET);
    }

    public Map<String, Object> list(String string) {
        return this.makeCall(this.fetchUrl(string, null, null), null, HttpCallMethod.GET);
    }

    public Map<String, Object> list(String string, Map<String, String> map) {
        return this.makeCall(this.fetchUrl(string, null, map), null, HttpCallMethod.GET);
    }

    public Map<String, Object> delete(String string) {
        return this.makeCall(this.fetchUrl(string, null, null), null, HttpCallMethod.DELETE);
    }

    public Map<String, Object> delete(String string, boolean bl) throws IOException {
        return this.makeCall(this.fetchUrl(string, null, null), this.objectMapper.writeValueAsString((Object)this.fetchDeleteOptions(bl, null)), HttpCallMethod.DELETE);
    }

    public Map<String, Object> delete(String string, DeleteOptions deleteOptions) throws IOException {
        return this.makeCall(this.fetchUrl(string, null, null), this.objectMapper.writeValueAsString((Object)deleteOptions), HttpCallMethod.DELETE);
    }

    public Map<String, Object> delete(String string, String string2) throws IOException {
        return this.makeCall(this.fetchUrl(string, string2, null), this.objectMapper.writeValueAsString((Object)this.fetchDeleteOptions(false, DeletionPropagation.BACKGROUND.toString())), HttpCallMethod.DELETE);
    }

    public Map<String, Object> delete(String string, String string2, boolean bl) throws IOException {
        return this.makeCall(this.fetchUrl(string, string2, null), this.objectMapper.writeValueAsString((Object)this.fetchDeleteOptions(bl, null)), HttpCallMethod.DELETE);
    }

    public Map<String, Object> delete(String string, String string2, String string3) throws IOException {
        return this.makeCall(this.fetchUrl(string, string2, null), this.objectMapper.writeValueAsString((Object)this.fetchDeleteOptions(false, string3)), HttpCallMethod.DELETE);
    }

    public Map<String, Object> delete(String string, String string2, DeleteOptions deleteOptions) throws IOException {
        return this.makeCall(this.fetchUrl(string, string2, null), this.objectMapper.writeValueAsString((Object)deleteOptions), HttpCallMethod.DELETE);
    }

    public void watch(String string, Watcher<String> watcher) throws IOException {
        this.watch(string, null, null, new ListOptionsBuilder().build(), watcher);
    }

    public void watch(String string, String string2, Watcher<String> watcher) throws IOException {
        this.watch(string, null, null, ((ListOptionsBuilder)new ListOptionsBuilder().withResourceVersion(string2)).build(), watcher);
    }

    public void watch(String string, ListOptions listOptions, Watcher<String> watcher) throws IOException {
        this.watch(string, null, null, listOptions, watcher);
    }

    public void watch(Watcher<String> watcher) throws IOException {
        this.watch(null, null, null, new ListOptionsBuilder().build(), watcher);
    }

    public Watch watch(String string, String string2, Map<String, String> map, String string3, Watcher<String> watcher) throws IOException {
        return this.watch(string, string2, map, ((ListOptionsBuilder)new ListOptionsBuilder().withResourceVersion(string3)).build(), watcher);
    }

    public Watch watch(String string, String string2, Map<String, String> map, ListOptions listOptions, Watcher<String> watcher) throws IOException {
        if (listOptions == null) {
            listOptions = new ListOptions();
        }
        listOptions.setWatch(Boolean.valueOf(true));
        HttpUrl.Builder builder = this.fetchWatchUrl(string, string2, map, listOptions);
        OkHttpClient.Builder builder2 = this.client.newBuilder();
        builder2.readTimeout(this.getConfig() != null ? this.getConfig().getWebsocketTimeout() : Config.DEFAULT_WEBSOCKET_TIMEOUT.longValue(), TimeUnit.MILLISECONDS);
        builder2.pingInterval(this.getConfig() != null ? this.getConfig().getWebsocketPingInterval() : Config.DEFAULT_WEBSOCKET_PING_INTERVAL.longValue(), TimeUnit.MILLISECONDS);
        OkHttpClient okHttpClient = builder2.build();
        WatcherToggle watcherToggle = new WatcherToggle(watcher, true);
        RawWatchConnectionManager rawWatchConnectionManager = null;
        try {
            rawWatchConnectionManager = new RawWatchConnectionManager(okHttpClient, builder, listOptions, this.objectMapper, watcher, this.getConfig() != null ? this.getConfig().getWatchReconnectLimit() : -1, this.getConfig() != null ? this.getConfig().getWatchReconnectInterval() : 1000, 5);
            rawWatchConnectionManager.waitUntilReady();
            return rawWatchConnectionManager;
        }
        catch (KubernetesClientException kubernetesClientException) {
            if (kubernetesClientException.getCode() != 200) {
                if (rawWatchConnectionManager != null) {
                    rawWatchConnectionManager.close();
                }
                throw kubernetesClientException;
            }
            if (rawWatchConnectionManager != null) {
                watcherToggle.disable();
                rawWatchConnectionManager.close();
            }
            return new RawWatchConnectionManager(okHttpClient, builder, listOptions, this.objectMapper, watcher, this.getConfig() != null ? this.getConfig().getWatchReconnectLimit() : -1, this.getConfig() != null ? this.getConfig().getWatchReconnectInterval() : 1000, 5);
        }
    }

    private Map<String, Object> createOrReplaceObject(String string, Map<String, Object> map) throws IOException {
        Map<String, Object> map2;
        Map map3 = (Map)map.get(METADATA);
        if (map3 == null) {
            throw KubernetesClientException.launderThrowable((Throwable)new IllegalStateException("Invalid object provided -- metadata is required."));
        }
        String string2 = (String)map3.get(RESOURCE_VERSION);
        map3.remove(RESOURCE_VERSION);
        try {
            map2 = string != null ? this.create(string, map) : this.create(map);
        }
        catch (KubernetesClientException kubernetesClientException) {
            if (kubernetesClientException.getCode() != 409) {
                throw kubernetesClientException;
            }
            try {
                if (string2 != null) {
                    map3.put(RESOURCE_VERSION, string2);
                }
                String string3 = (String)map3.get("name");
                map2 = string != null ? this.edit(string, string3, map) : this.edit(string3, map);
            }
            catch (NullPointerException nullPointerException) {
                throw KubernetesClientException.launderThrowable((Throwable)new IllegalStateException("Invalid object provided -- metadata.name is required."));
            }
        }
        return map2;
    }

    private Map<String, Object> convertJsonOrYamlStringToMap(String string) throws IOException {
        HashMap hashMap = null;
        hashMap = IOHelpers.isJSONValid((String)string) ? (HashMap)this.objectMapper.readValue(string, HashMap.class) : (HashMap)this.objectMapper.readValue(IOHelpers.convertYamlToJson((String)string), HashMap.class);
        return hashMap;
    }

    protected HttpUrl.Builder fetchWatchUrl(String string, String string2, Map<String, String> map, ListOptions listOptions) throws MalformedURLException {
        String string3 = this.fetchUrl(string, null, map);
        if (string3.endsWith("/")) {
            string3 = string3.substring(0, string3.length() - 1);
        }
        URL uRL = new URL(string3);
        HttpUrl.Builder builder = HttpUrl.get((URL)uRL).newBuilder();
        if (string2 != null) {
            builder.addQueryParameter("fieldSelector", "metadata.name=" + string2);
        }
        HttpClientUtils.appendListOptionParams((HttpUrl.Builder)builder, (ListOptions)listOptions);
        return builder;
    }

    private String fetchUrl(String string, String string2, Map<String, String> map) {
        if (this.config.getMasterUrl() == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(this.config.getMasterUrl());
        stringBuilder.append(this.config.getMasterUrl().endsWith("/") ? "" : "/");
        stringBuilder.append("apis/").append(this.customResourceDefinition.getGroup()).append("/").append(this.customResourceDefinition.getVersion()).append("/");
        if (this.customResourceDefinition.getScope().equals("Namespaced") && string != null) {
            stringBuilder.append("namespaces/").append(string).append("/");
        }
        stringBuilder.append(this.customResourceDefinition.getPlural());
        if (string2 != null) {
            stringBuilder.append("/").append(string2);
        }
        if (map != null) {
            stringBuilder.append("?labelSelector").append("=").append(this.getLabelsQueryParam(map));
        }
        return stringBuilder.toString();
    }

    private String getLabelsQueryParam(Map<String, String> map) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(entry.getKey()).append(Utils.toUrlEncoded((String)"=")).append(entry.getValue());
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, Object> makeCall(String string, String string2, HttpCallMethod httpCallMethod) {
        Request request = string2 == null ? this.getRequest(string, httpCallMethod) : this.getRequest(string, string2, httpCallMethod);
        try (Response response = this.client.newCall(request).execute();){
            if (response.isSuccessful()) {
                String string3 = response.body().string();
                if (Utils.isNullOrEmpty((String)string3)) {
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    return hashMap;
                }
                Map map = (Map)this.objectMapper.readValue(string3, HashMap.class);
                return map;
            }
            throw RawCustomResourceOperationsImpl.requestFailure((Request)request, (Status)RawCustomResourceOperationsImpl.createStatus((Response)response));
        }
        catch (Exception exception) {
            throw KubernetesClientException.launderThrowable((Throwable)exception);
        }
    }

    private Map<String, Object> validateAndSubmitRequest(String string, String string2, String string3, HttpCallMethod httpCallMethod) throws IOException {
        return this.validateAndSubmitRequest(this.fetchUrl(string, string2, null), string3, httpCallMethod);
    }

    private Map<String, Object> validateAndSubmitRequest(String string, String string2, HttpCallMethod httpCallMethod) throws IOException {
        if (IOHelpers.isJSONValid((String)string2)) {
            return this.makeCall(string, string2, httpCallMethod);
        }
        return this.makeCall(string, IOHelpers.convertYamlToJson((String)string2), httpCallMethod);
    }

    private Request getRequest(String string, HttpCallMethod httpCallMethod) {
        Request.Builder builder = new Request.Builder();
        switch (httpCallMethod) {
            case GET: {
                builder.get().url(string);
                break;
            }
            case DELETE: {
                builder.delete().url(string);
            }
        }
        return builder.build();
    }

    private Request getRequest(String string, String string2, HttpCallMethod httpCallMethod) {
        Request.Builder builder = new Request.Builder();
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)string2);
        switch (httpCallMethod) {
            case DELETE: {
                return builder.delete(requestBody).url(string).build();
            }
            case POST: {
                return builder.post(requestBody).url(string).build();
            }
            case PUT: {
                return builder.put(requestBody).url(string).build();
            }
            case PATCH: {
                return builder.patch(RequestBody.create((MediaType)JSON_PATCH, (String)string2)).url(string).build();
            }
        }
        return builder.build();
    }

    private String appendResourceVersionGetDiff(String string, String string2, String string3) throws IOException {
        Map<String, Object> map = this.convertJsonOrYamlStringToMap(string3);
        return this.appendResourceVersionGetDiff(string, string2, map);
    }

    private String appendResourceVersionGetDiff(String string, String string2, Map<String, Object> map) throws IOException {
        Map<String, Object> map2 = this.get(string, string2);
        String string3 = ((Map)map2.get(METADATA)).get(RESOURCE_VERSION).toString();
        ((Map)map.get(METADATA)).put(RESOURCE_VERSION, string3);
        map2.put("status", null);
        map.put("status", null);
        JsonNode jsonNode = JsonDiff.asJson((JsonNode)PatchUtils.patchMapper().valueToTree(map2), (JsonNode)PatchUtils.patchMapper().valueToTree(map));
        String string4 = this.objectMapper.writeValueAsString((Object)jsonNode);
        return string4;
    }

    private DeleteOptions fetchDeleteOptions(boolean bl, String string) {
        DeleteOptions deleteOptions = new DeleteOptions();
        if (string != null) {
            deleteOptions.setPropagationPolicy(string);
        } else {
            deleteOptions.setOrphanDependents(Boolean.valueOf(!bl));
        }
        return deleteOptions;
    }

    private static enum HttpCallMethod {
        GET,
        POST,
        PUT,
        DELETE,
        PATCH;

    }
}

